/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

public abstract class MarlinJniListener extends MarlinJniClient {

 protected native final long OpenListener(String clientId,
                                          String groupId,
                                          int rpcTimeoutMillis,
                                          boolean hardMount,
                                          boolean autoCommitEnabled,
                                          long autoCommitIntervalMillis,
                                          long metadataMaxAgeMillis,
                                          int fetchMsgMaxBytesPerPartition,
                                          int fetchMinBytes,
                                          int fetchMaxWaitMs,
                                          String autoResetEarliest,
                                          String consumerDefaultStreamName,
                                          long bufferMaxMemory,
                                          boolean zeroOffsetOnEof);

  protected native final int AssignmentList(long clntPtr, NativeData data);

  protected native final int SubscriptionList(long clntPtr, MarlinStringArrayWrapper result);

  protected native final int SubscribeRegex(long clntPtr, String regexTopic, MarlinRebalanceCallbackWrapper callback);

  protected native final int SubscribeTopics(long clntPtr, String[] topic, MarlinRebalanceCallbackWrapper callback);

  protected native final int AssignFeeds(long clntPtr, String[] topic, int[] feeds);

  protected native final int Unsubscribe(long clntPtr);

  protected native final int Poll(long clntPtr, long timeout, NativeData nativeresult);

  protected native final void Wakeup(long clntPtr);

  protected native final int Commit(long clntPtr, String[] topics, int[] feeds,
                                    long[] offsets, boolean syncCommit,
                                    MarlinCommitCallbackWrapper callback);

  protected native final int CommitAll(long clntPtr, boolean syncCommit,
                                       MarlinCommitCallbackWrapper callback);

  protected native final int Seek(long clntPtr, String[] topics, 
                                  int[] feeds, long[] offsets);

  protected native final int QueryCursor(long clntPtr, String topic, 
                                         int feed, NativeData data);

  protected native final int QueryPosition(long clntPtr, String topic, int feed,
                                           NativeData data);

  public interface MarlinJoinCallbackWrapper {
    public void onJoin(byte[] data);
    public void onRejoin(byte[] data);
  }

  protected native final void CloseListener(long clntPtr);

  protected native final int GetTopicInfo(long clntPtr, String topic);

  protected native final int GetTopicsFromStream(long clntPtr, String stream, MarlinStringArrayWrapper result);

  protected native final int Pause(long clntPtr, String[] topics, int[] feeds);

  protected native final int Resume(long clntPtr, String[] topics, int[] feeds);

  protected native final byte[] Join(long clntPtr, byte[] joinDesc, MarlinJoinCallbackWrapper cb);

  public interface MarlinRebalanceCallbackWrapper {
    public void onPartitionsAssigned(NativeData data);
    public void onPartitionsRevoked(NativeData data);
  }

  public interface MarlinCommitCallbackWrapper {
    public void onComplete(NativeData data, long[] offsets, int errorCode);
  }

  public interface MarlinStringArrayWrapper {
    public void SetStringArrayElements(String tn, int[] tns, int[] np, int nt);
  }
}
