/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

import com.mapr.fs.jni.MapRConstants.ErrorValue;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.MarlinJniClient;

public abstract class MarlinJniAdmin extends MarlinJniClient {

  protected native final long OpenAdmin();

  protected native final int CreateTopicWithDefaultFeeds(long clntPtr,
                                                         String topic,
                                                         MapRUserInfo userInfo);

  protected native final int CreateTopic(long clntPtr, String topic, int feeds,
                                         MapRUserInfo userInfo);

  protected native final int EditTopic(long clntPtr, String topic, int feeds,
                                       MapRUserInfo userInfo);

  protected native final int DeleteTopic(long clntPtr, String topic,
                                         MapRUserInfo userInfo);

  protected native byte[] GetTopicMetaEntry(long clntPtr, String topic,
                                            ErrorValue err,
                                            MapRUserInfo userInfo);

  protected native byte[] StatTopicFeed(long clntPtr, String topic, int feedId,
                                        boolean headOnly,
                                        ErrorValue err, MapRUserInfo userInfo);

  protected native byte[] StatFeedsOnTablet(long clntPtr, String stream,
                                            int cid, int cinum, int uniq,
                                            ErrorValue err,
                                            MapRUserInfo userInfo);

  protected native final void CloseAdmin(long clntPtr);
}
