/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/* Note that we cannot load the UserGroupInformation class or resolve
 * method IDs as part of the class load because we will almost certainly
 * not have the UserGroupInformation class loaded at that time
 */
public class MapRUserGroupInfo {

  private static volatile Method getCurrentUser = null;
  private static volatile Method getShortName   = null;
  private static volatile Method getLoginUser   = null;
  private static boolean haveMethodIDs = false;
  
  public static String getCurrentUserName() 
         throws IllegalArgumentException, IllegalAccessException, 
                InvocationTargetException, SecurityException,
                NoSuchMethodException {
    String userName = null;
    
    // Get the necessary method IDs if we need to
    if (!haveMethodIDs)
      GetMethodIDs();
      
    // Get the UGI for our current user
    Object currentUser = getCurrentUser.invoke(null);
    userName           = (String) getShortName.invoke(currentUser);
    
    return userName;
  }
          
  public static String getLoginUserName() 
		 throws SecurityException, NoSuchMethodException,
		        IllegalArgumentException, IllegalAccessException,
		 	    InvocationTargetException {
	String userName = null;
	    
	if (!haveMethodIDs)
	  GetMethodIDs();
	        
    // Get the UGI for our login user user
    Object loginUser = getLoginUser.invoke(null);
    userName           = (String) getShortName.invoke(loginUser);
    
    return userName;
	  
  }
  
  /* GetMethodIDs: Get all method IDs needed for this class.  All method
   * IDs are obtained to avoid the overhead of obtaining the class
   * loader and class needed to get method IDs for individual methods
   */
  private static void GetMethodIDs() 
		  throws SecurityException, NoSuchMethodException {
    try {
      /* We need the class loader because the default does not 
       * necessarily work
       */
      ClassLoader cl = Thread.currentThread().getContextClassLoader();
        
      // Get the class from which we can obtain method IDs
      Class<?> UGIClass = 
        Class.forName("org.apache.hadoop.security.UserGroupInformation",
                       true, cl);
    
      if (getCurrentUser == null)
        getCurrentUser = UGIClass.getMethod("getCurrentUser");
      
      if (getShortName == null)
        getShortName = UGIClass.getMethod("getShortUserName");
      
      if (getLoginUser == null)
        getLoginUser = UGIClass.getMethod("getLoginUser");
   
      if (getCurrentUser != null &&
          getShortName   != null &&
          getLoginUser   != null)
    	haveMethodIDs = true;
    }
    catch(ClassNotFoundException e) {
        /* This is OK because we may not always have the 
         * UserGroupInformation class loaded
         */
    }
      
    return;
  }
}

