/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

import com.mapr.fs.jni.Errno;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Arrays;
import static com.mapr.fs.jni.MapRConstants.PutConstants.*;

// MapRUpdateAndGet : Tracks the return values from UpdateAndGet related jni Ops
public class MapRUpdateAndGet {
  public int            status;
  public int            numSuccess;
  public int            numFailed;
  public byte           opType;
  public boolean        conditionSuccess;

  // Batched Put (from streaming reader) related fields
  public int            numKeys;
  public byte[][]         keys; // one key per row
  public ByteBuffer[][]   encBuffers; // one encoded record's buffer per key

  public MapRUpdateAndGet() {
    status = 0;
    numSuccess = 0;
    numFailed = 0;
    opType = 0;
    conditionSuccess = true;
  }

  public int getStatus() {
    return this.status;
  }

  public int getNumSuccess() {
    return this.numSuccess;
  }

  public int getNumFailed() {
    return this.numFailed;
  }

  public byte getOpType() {
    return this.opType;
  }
}
