/* Copyright (c) 2011 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

import java.nio.ByteBuffer;

import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.jni.MapRUpdateAndGet;

public class MapRTableTools {
  // goose native calls
  public static native int FlushPuts(long  clusterP, long fileP);
  public static native int PutOrDeleteRPC(long clusterP, long fileP,
					 MapRPut[] puts, boolean shouldBlock,
					 boolean shouldFlush, boolean isRowMut, MapRUserInfo userInfo);
  public static native int GetRPC(long clusterP,
                           long fileP, MapRGet[] gets,
                           boolean shouldFlush, MapRUserInfo userInfo);
  public static native int IncrementRPC(long clusterP,
                                 long fileP, MapRIncrement incr,
                                 boolean shouldFlush,
                                 MapRUserInfo userInfo);
  public static native int AppendRPC(long clusterP, long fileP,
                              MapRPut mput, boolean needResult,
                              boolean shouldFlush,
                              MapRUserInfo userInfo);
  public static native int FreeArena(long clusterP, long fileP, long arenaAddr);
  
  public static native int CheckAndPutOrDeleteRPC(long clusterP, long fileP, 
                                           byte[] row, 
                                           boolean useCf, int familyId, 
                                           byte[] qualifier,
                                           byte[] value,
                                           MapRPut mput,
                                           boolean shouldFlush,
                                           MapRUserInfo userInfo);

  public static native int UpdateAndGetRPC(long clusterP, long fileP,
                                           byte[] row,
                                           boolean useCf,
                                           boolean checkForNonExist,
                                           MapRRowConstraint checkConstraint,
                                           byte[] serFilter,
                                           MapRPut[] mputs,
                                           boolean shouldFlush,
                                           MapRUserInfo userInfo);

  // scanner calls
  public static native int ScanNext(long clusterP, long fileP, long scannerP,
                             int numRows, MapRResult[] results, MapRUserInfo userInfo);
  // AH TODO do we need to pass inode and client ptr to scanner as its already saved in Init
  public static native int ScannerClose(long clusterP, long fileP, long scannerP);
  public static native int ScannerClearOldBuffer(long clusterP, long fileP, long scannerP);
  public static native long GetScanner(long clusterP, long fileP, MapRScan scan,
                                       MapRUserInfo userInfo);

  // BulkLoader calls
  public static native long GetBulkLoader(long clusterP, long fileP, byte[] tableUuidForPuts,
                                          MapRUserInfo userInfo);
  public static native int BulkLoaderAppend(long clusterP, long fileP, 
                                            long bulkLoaderP, MapRPut[] puts,
                                            MapRUserInfo userInfo);
  public static native int BulkLoaderAppendEncoded(long clusterP, long fileP,
                                                   long bulkLoaderP, MapRJSONPut[] puts);
  public static native int BulkLoaderClose(long clusterP, long fileP,
                                           long bulkLoaderP);

  public static native byte [] GetSchema(long clusterP, long fileP, long version);
  public static native String GetColumnFamilyName(long clusterP, long fileP, 
                                           int id, MapRConstants.ErrorValue err);
  public static native int GetColumnFamilyId(long clusterP, long fileP, 
                                             String fname,
                                             MapRConstants.ErrorValue err);

  public static native int CheckAndReplaceOrDeleteRPC(long clusterP, long fileP,
                                                      ByteBuffer key,
                                                      ByteBuffer[] serRecords,
                                                      int[] recordFamilyIds,
                                                      byte [] serReadConstraint,
                                                      ByteBuffer condition,
                                                      boolean shouldFlush,
                                                      boolean isDelete,
                                                      MapRUpdateAndGet muag);

  public static native int CheckAndMutateRPC(long clusterP, long fileP,
                                             ByteBuffer key,
                                             ByteBuffer[] serRecordMutations,
                                             int[] mutationsFamilyIds,
                                             byte [] serReadConstraint,
                                             ByteBuffer serCondition,
                                             boolean shouldFlush,
                                             MapRUpdateAndGet muag);

  public static native int UpdateRecordRPC(long clusterP, long fileP,
                                           ByteBuffer key,
                                           ByteBuffer[] serRecordMutations,
                                           int[] mutationsFamilyIds,
                                           byte [] serReadConstraint,
                                           boolean shouldFlush,
                                           MapRUpdateAndGet muag);
}
