/* Copyright (c) 2011 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

public class MapRKeyValue {
  private final long timestamp;
  private final byte [] serializedKeyValue; //immutable buffer
  private final int columnOff, valueOff, columnLen, valueLen; //offset and lengths inside byte buffer

  // async hbase style key values
  private final byte [] qualifier;
  private final byte [] value;
  private final boolean deleteColumn; // deleteColumn() apis should be handled in a special way
  private final boolean firstCell;
  private final boolean lastCell;  
  // Both firstCell and lastCell could be true if its a single cell for the column

  // hbase
  public MapRKeyValue( byte[] buffer, int columnOff, int columnLen, 
                       int valueOff, int valueLen, long timestamp, 
                       boolean firstCell, boolean lastCell) {
    this(buffer,columnOff, columnLen, valueOff, valueLen, timestamp, 
         firstCell, lastCell, false);
  }

  public MapRKeyValue( byte[] buffer, int columnOff, int columnLen, 
                       int valueOff, int valueLen, long timestamp, 
                       boolean firstCell, boolean lastCell,
                       boolean deleteColumn) {
    this.serializedKeyValue = buffer;
    this.timestamp = timestamp;
    this.columnOff = columnOff;
    this.valueOff = valueOff;
    this.columnLen = columnLen;
    this.valueLen = valueLen;
    this.qualifier = null;
    this.value = null;
    this.firstCell = firstCell;
    this.lastCell = lastCell;
    this.deleteColumn = deleteColumn;
  }

  // async
  public MapRKeyValue(byte[] qualifier, byte [] value, long timestamp, 
                      boolean firstCell, boolean lastCell) {
    this.qualifier = qualifier;
    this.value = value;
    this.timestamp = timestamp;
    this.serializedKeyValue = null;
    columnOff = valueOff = columnLen = valueLen = -1;
    this.firstCell = firstCell;
    this.lastCell = lastCell;
    this.deleteColumn = false;
  }

  public byte [] getBuffer() {
    return serializedKeyValue;
  }

  public int getColumnOffset() { return columnOff; }
  public int getColumnLength() { return columnLen; }
  public int getValueOffset() { return valueOff; }
  public int getValueLength() { return valueLen; }
  public long getTimeStamp() { return timestamp; }

  public byte [] getQualifier() { return qualifier; }
  public byte [] getValue() { return value; }
}
