/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

import com.mapr.fs.jni.Errno;
import java.nio.ByteBuffer;

/*
 * MapRJSONPut: Container for holding encoded MapR-DB Records
 *
 */
public class MapRJSONPut {
    public int nFamilies;
    public byte[] key;

    // 1:1 mapping for familyId:record
    public int[] familyIdList;
    public ByteBuffer[] recordList;
    public long recordTotalBytes;

    public MapRJSONPut(byte[] key, int nFamTotal) {
      nFamilies = 0;
      recordTotalBytes = 0;
      familyIdList = new int[nFamTotal];
      recordList = new ByteBuffer[nFamTotal];
      this.key = key;
      recordTotalBytes += key.length;
    }

    public void addCFEntry(int familyId, ByteBuffer encodedRecord) {
      assert (key != null);
      familyIdList[nFamilies] = familyId;
      recordList[nFamilies] = encodedRecord;
      if (encodedRecord != null) {
        recordTotalBytes += encodedRecord.remaining();
      }
      nFamilies++;
    }

    public int getNumFamilies() { return nFamilies; }
}
