/* Copyright (c) 2011 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

import java.nio.ByteBuffer;

public class MapRGet {
  public byte[]             key;            // extract key separately
  public MapRResult         result;         // embed result in same object
  public MapRRowConstraint  rowConstraint;
  public byte[]             filter;
  long                      arenaAddr;

  /* When MapRGets are passed in a list, this field identifies the 
     order in which the elements were passed to support the
     reordering to the original order for the result, after a
     sort that orders the list for optimal server performance
  */
  public int                listIndex;

  // For JSON tables, jni returns the encoded row as is from server to be
  // converted into ojai Documents in the java layer.
  public boolean            isEncodedResult;

  public void setEncodedResult(boolean val) {
    isEncodedResult = val;
  }

  public boolean getEncodedResult() {
    return isEncodedResult;
  }

  public MapRResult getResult() {
    return result;
  }

  public byte[] getKey() {
    return key;
  }

  public long getArena() {
    return arenaAddr;
  }

  public void setArena(long arenaAddr) {
    this.arenaAddr = arenaAddr;
  }

  public byte[] getFilter() {
    return filter;
  }

  public void setFilter(byte[] filter) {
    this.filter = filter;
  }
}
