/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

public interface MapRConstants {

  // BitMasks for setattr
  public static final int UserBit = 1;
  public static final int GroupBit = 1 << 1;
  public static final int MtimeBit = 1 << 2;
  public static final int AtimeBit = 1 << 3;
  public static final int ModeBit = 1 << 4;
  public static final int ReplBit = 1 << 5;
  public static final int CompressBit = 1 << 6;
  public static final int ChunkSizeBit = 1 << 7;
  public static final int CompressorTypeBit = 1 << 9;
  public static final int FidNameBit = 1 << 10;
  public static final int WireSecureBit = 1 << 12;
  public static final int AuditBit = 1 <<13;

  public static final long DefaultChunkSize = 256L << 20; // 256m
  public static final long MinChunkSize = 65536L;

  //Related to /opt/mapr/conf/mapr-clusters.conf
  public static final String MapRHomeDefault = "/opt/mapr/";
  public static final String ClusterConfDefault = "/conf/mapr-clusters.conf";
  public static final String MAPR_ENV_VAR = "MAPR_HOME";
  public static final String MAPR_PROPERTY_HOME = "mapr.home.dir";

  public static final String MapRClusterDir = "/mapr";
  public static final String MapRClusterDirSlash = MapRClusterDir + "/";
  public static final String MapRClusterDirPattern = "^" + MapRClusterDirSlash + ".+";
  public static final String DefaultCLDBIp = "127.0.0.1";
  public static final int DefaultCLDBPort = 7222;

  // URI scheme for MapRFs
  public static final String MAPRFS_SCHEME = "maprfs";
  public static final String MAPRFS_PREFIX = "maprfs:///";
  public static final int MAX_PATH_LENGTH = 8000;
  public static final String MULTI_ADDR_SEPARATOR = ";";
  public static final String HOSTNAME_IP_SEPARATOR = ",";
  public static final String IP_PORT_SEPARATOR = ":";
  public static final int MAX_PORT_NUMBER = 65535;

  public static final int MAX_CLUSTERS_CROSSED = 8; // For symlinks across clusters
  public static final String DEFAULT_USER_IDENTIFIER = "$USERNAME";
  public static final String DEFAULT_USER_IDENTIFIER_ESCAPED = "\\$USERNAME";

  public static final String HADOOP_SECURITY_SPOOFED_USER = "hadoop.spoofed.user.username";
  public static final String HADOOP_SECURITY_SPOOFED_GROUP = "hadoop.spoofed.user.groupname";
  public static final String HADOOP_SECURITY_SPOOFED_UID = "hadoop.spoofed.user.uid";
  public static final String HADOOP_SECURITY_SPOOFED_GID = "hadoop.spoofed.user.gid";

  public static final String UTF8_ENCODING = "UTF-8";
  public static final int NUM_CONTAINERS_PER_RPC = 50;
  public static final int MAX_RA_THREADS = 256;
  public static final int MIN_RA_THREADS = 10;

  /**
   * An empty instance of byte array
   */
  public static final byte [] EMPTY_BYTE_ARRAY = new byte [0];

  /**
   * Used by scanners when they want to start at the beginning of a key range
   */
  public static final byte [] EMPTY_START_ROW = EMPTY_BYTE_ARRAY;

  /**
   * Indicative of last row key in a table.
   */
  public static final byte [] EMPTY_END_ROW = EMPTY_START_ROW;

  /**
    * Used by scanners and others when they're trying to detect the end of a
    * table
    */
  public static final byte [] LAST_ROW = EMPTY_BYTE_ARRAY;

  /**
   * Timestamp to use when we want to refer to the latest cell.
   * This is the timestamp sent by clients when no timestamp is specified on
   * object/mutation.
   */
  public static final long LATEST_TIMESTAMP = Long.MAX_VALUE;

  /**
   * Timestamp to use when we want to refer to the oldest cell.
   */
  public static final long OLDEST_TIMESTAMP = Long.MIN_VALUE;

  public static class ErrorValue {
    public int error;
    public String trailpath; // Used by symlinks to different clusters
    
    // Used for mapred performance
    public String fid;       // Used by some apis to return the fid    
    public long fileptr;     // Used by openFid2
  }  
  
  public static class JniUsername {
    public String username;
  }

  
  public interface PutConstants{
    public static final byte TYPE_PUT_ROW            = 0X00; // default 
    public static final byte TYPE_PUT_ROW_ASYNC      = 0X01; // aysnc put
    public static final byte TYPE_PUT_ROW_BUFFERED   = 0X02; // buffered put, encoding is same as default put, but has callback as async put
    public static final byte TYPE_DELETE_ROW         = 0X11; // delete the entire row
    public static final byte TYPE_DELETE_ROW_ASYNC   = 0X12; // delete the entire row
    public static final byte TYPE_DELETE_ROW_BUFFERED= 0X13; // delete the entire row
    public static final byte TYPE_DELETE_CELLS       = 0X14; // delete inside row families/columns
    public static final byte TYPE_DELETE_CELLS_ASYNC = 0X18; // delete inside row families/columns
    public static final byte TYPE_DELETE_CELLS_BUFFERED = 0X19; // delete inside row families/columns
    public static final byte TYPE_DELETE_CELLS_EXACT_ASYNC = 0X1C; // delete inside row families/columns
    public static final byte TYPE_DELETE_CELLS_EXACT_BUFFERED = 0X1D; // delete inside row families/columns
    
    public static final byte TYPE_ISDELETE_MASK      = 0x10; // mask to see if its put or delete    
  }
  
  public interface RowConstants{
    //-9223372036854775808 gets converted to unsigned int in c++, Thus adding a 1 here.
    public static final long DEFAULT_MIN_STAMP = (Long.MIN_VALUE + 1);
    public static final long DEFAULT_MAX_STAMP = Long.MAX_VALUE;
    public static final int DEFAULT_MAX_VERSIONS = 1;
  }

}
