/* Copyright (c) 2014 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

public class MapRClientInitParams {
  public MapRClientInitParams() {
    allTrace = null;
    aggregateWrites = true;
    dbPutBufSize = 0;
    dbPutThresholdMB = 0;
    dbPutThresholdSec = 0;
    disableLocalIO = false;
    memPoolSize = 512 * 5;
    numWriters = 8;
    tabletLruLimitKB = 0;
    readBuffering = true;
    rpcTimeout = 0;
    slowOpsThreshold = 0;
    spoofedGid = 0;
    spoofedGroup = "root";
    spoofedUid = 0;
    spoofedUser = "root";
    blQueueSizeMB = 0;
    blFlags = 0;
    numThreadPoolThreads = 10;
    maxThreadPoolQueueSize = 10000;
    maxThreadPoolBatchSize = 128;
    highPriThreadPoolThreads = 2;
    idleFlusherEnabled = true;
    idleFlusherTimeout = 3;
    flushUnaligned = false;
    hardMount = true;
    maxRAThreads = 0;
    setSeperateAuditPath = false;
    resolveUserAtServer = false;
    connectTimeout = 0;
    bindRetries = false;
    bailOutOnLibMismatch = true;
    flushInline = false;
  }

  public String      allTrace;
  public boolean     aggregateWrites;
  public int         dbPutBufSize;
  public int         dbPutThresholdMB;
  public int         dbPutThresholdSec;
  public boolean     disableLocalIO;
  public int         memPoolSize;
  public int         numWriters;
  public int         tabletLruLimitKB;
  public boolean     readBuffering;
  public int         rpcTimeout;
  public int         connectTimeout;
  public int         slowOpsThreshold;
  public String      spoofedGroup;
  public int         spoofedGid;
  public int         spoofedUid;
  public String      spoofedUser;
//  public JniUsername jniusername;
  public int         blQueueSizeMB;
  public int         blFlags;
  public int         numThreadPoolThreads;
  public int         maxThreadPoolQueueSize;
  public int         maxThreadPoolBatchSize;
  public int         highPriThreadPoolThreads;
  public boolean     idleFlusherEnabled;
  public int         idleFlusherTimeout;
  public boolean     flushUnaligned;
  public boolean     hardMount;
  public int         maxRAThreads;
  public boolean     setSeperateAuditPath;
  public boolean     resolveUserAtServer;
  public boolean     bindRetries;
  public boolean     flushInline;

  //bailOutOnMismatch will be parsed on by java layer.
  public boolean     bailOutOnLibMismatch;
}
