/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

import com.mapr.fs.jni.MapRClientInitParams;
import com.mapr.fs.jni.MapRConstants.ErrorValue;
import com.mapr.fs.jni.MapRConstants.JniUsername;
import com.mapr.fs.jni.MapRUserInfo;
import com.mapr.fs.jni.IPPort;

public abstract class MapRClient {

  protected native final long OpenClient(String clusterName, long[] ips, 
                                       String authority,
                                       boolean disableNameCache,
                                       MapRClientInitParams clientInitParams);

  protected native final long OpenClient2(String clusterName, long[] ips, 
                                       String authority,
                                       boolean disableNameCache,
                                       MapRClientInitParams clientInitParams,
                                       String buildVersion,
                                       String patchVersion,
                                       boolean bailOutOnLibMismatch);

  protected native final void CloseClient(long clntPtr);
  
  protected native final int getuserpermission(long clntPtr, String name,
                                               int accessBitsIn,
                                               ErrorValue err,
                                               MapRUserInfo userInfo);
  
  protected native final long create(long clntPtr, String name, int mask,
                                   int mode, 
                                   boolean createIfNonExistant, boolean append,
                                   boolean overwrite, short replication, long chunkSize,
                                   boolean createParent,
                                   ErrorValue err, MapRUserInfo userInfo);

  // TODO - change read_write to proper form - enumset ?
  protected native InodeAttributes open(long clntPtr, String name, 
                                        int read_write,
                                        ErrorValue err, MapRUserInfo userInfo);


  protected native final int remove(long clntPtr, String name, boolean recursive,
                    boolean batched, ErrorValue err, MapRUserInfo userInfo);

  protected native final JNIFileStatus getattr(long clntPtr, String name, 
                                              boolean needSlashMapr, 
                                              String authority, 
                                              ErrorValue err, MapRUserInfo userInfo);

  protected native final int setattr(long clntPtr, String name, int bitmask,
                                   String user, String group, long mtime, 
                                   long atime, int mode, short repl,
                                   boolean canCompress, String compressorType,
                                   long chunkSize, boolean wireSecurityEnabled,
                                   boolean audit,
                                   ErrorValue err, MapRUserInfo userInfo);

  protected native final int setxattr(long clntPtr, String fileName,
                                      String xname, byte [] value,
                                      ErrorValue err, MapRUserInfo userInfo);

  protected native final byte[] getxattr(long clntPtr, String fileName,
                                         String xname, ErrorValue err,
                                         MapRUserInfo userInfo);

  protected native final byte[] listxattr(long clntPtr, String fileName,
                                          ErrorValue err, MapRUserInfo userInfo);

  protected native final int removexattr(long clntPtr, String fileName,
                                         String xname, ErrorValue err,
                                         MapRUserInfo userInfo);

  protected native final int delace(long clntPtr, String name,
                                    ErrorValue err, MapRUserInfo userInfo);

  protected native final byte[] getace(long clntPtr, String name,
                                       ErrorValue err, MapRUserInfo userInfo, int serveridx);

  protected native final int setace(long clntPtr, String name,
                                    byte [] face, boolean isSet,
                                    String hintAceName, ErrorValue err,
                                    MapRUserInfo userInfo);

  protected native final int mkdirs(long clntPtr, String name, int mask,
                                  int mode, boolean compress, long chunkSize,
                                  ErrorValue err, boolean needFid, boolean createParent,
                                  MapRUserInfo userInfo);

  protected native final int rename(long clntPtr, String src, String dest,
                                  ErrorValue err, MapRUserInfo userInfo);

  protected native final JNIFileStatus[] readdirplus(long clntPtr, String name, 
                                                    boolean showVols,
                                                    boolean needSlashMapr,
                                                    boolean showHidden,
                                                    String authority,
                                                    ErrorValue err, 
                                                    MapRUserInfo userInfo);

  protected native final JNIBlockLocation[] getBlockInfo(long clntPtr,
                                                        String name, 
                                                        long start, 
                                                        long len, 
                                                        boolean usePrimaryFid,
                                                        boolean needDiskBlocks,
                                                        ErrorValue err);

  protected native final void createSymlink(long clntPtr, String target, String link, 
                                            boolean createParent, int mask, int mode, long chunkSize,
                                            ErrorValue linkErr, MapRUserInfo userInfo);
  
  protected native final void createHardlink(long clntPtr, String oldpath, String newpath, 
          ErrorValue linkErr, MapRUserInfo userInfo);

  protected native final JNIFsStatus getStatus(long clntPtr);
  
  protected native final String readlink(long clntPtr, String path, ErrorValue err);

  protected native final int mountVolume(long clntPtr, String volName, 
                                 String mountPath, String username, MapRUserInfo userInfo, int mode);

  protected native final int unmountVolume (long clntPtr, String volName,
                                   String mountPath, String username,
                                   int pCid, int pCinum, int pUniq, MapRUserInfo userInfo);

  protected native final String getPathFromFid(long clntPtr, String username,
                                     int pCid, int pCinum, int pUniq, MapRUserInfo userInfo);

  protected native final int createSnapshot(long clntPtr, String volName, int volId, int rootCid, 
                                    String snapshotName, boolean mirrorSnapshot, 
                                    String username, MapRUserInfo userInfo);

  public native byte[] getContainerInfo(long clntPtr, int [] cids, ErrorValue err,
                                               MapRUserInfo userInfo);
  public native int GetUserInfo(long clntPtr, MapRUserInfo userInfo);

  public native static int initSpoofedUser(String spoofedUser, int spoofedUid, 
						  String spoofedGroup, int spoofedGid);
  
  public native static void cleanup();
  
  public native static String getZkConnectString(long clntPtr, boolean cached);
  
  public native int createVolLink(long clntPtr, String volName, 
					  String volLink, boolean writeable,
					  boolean hidden, MapRUserInfo userInfo);
  
  public native int deleteVolLink(long clntPtr, String volLink, MapRUserInfo userInfo);

  // MapReduce performance apis - version 1
  public native InodeAttributes openFidWithParams(long clntPtr, 
							  String fid, long[] ips, 
							  long chunkSize, 
							  long fileSize,
							  ErrorValue err, MapRUserInfo userInfo);

  // rpc call (transplanted from Inode)
  public static final int  ERROR_VALUE = Integer.MAX_VALUE;
  public static final int LogPageSize = 13;
  public static final int PageSize = (1<< LogPageSize);
  // constants converting hadoop enum FadviseType to integer
  public static final int FADVISEDONTNEED = 0;
  public static final int FADVISERANDOM   = 1; // ignored
  public static final int FADVISESEQ      = 2; // ignored
  
  public static final int RA_THREADS      = 2;

  public static native IPPort[] getGatewayIps(long clusterP,
                                              String file,
                                              String dstCluster,
                                              boolean skipCache,
                                              GatewaySource source,
                                              ErrorValue err,
                                              MapRUserInfo userInfo);

  public static native int  readRPC(long   clusterP,
      long   fileP,
      Page[] pagesToGet,
      long intendReadTillOffset, //client is commited to read till this off
      SFid   sfid,
      String pfid, // used by openFid2
      long ips[], // used by openFid2
      String file, // used by openFid2
      ErrorValue err, // used by openFid2
      InodeAttributes attrs, // used by openFid2
      MapRUserInfo userInfo
      );
  
  public static native int  writeRPC(long   clusterP,
         long   fileP,
         Page[] pagesToSend,
         long   flushToPos,
         boolean flushToServer,
         MapRUserInfo userInfo);
  
  public static native long getAttrs(long clusterP, long fileP, InodeAttributes a);
  
  public static native int  flushJniBuffers(long  clusterP, long fileP, long flushToPos);
  
  public static native int  adviseFile(long  clusterP,
       long fileP,
       int type,
       long offset,
       long count, MapRUserInfo userInfo);
  
  public static native int  closeFile(long  clusterP, long fileP);
  
  public static native long[] getFidServers(long  clusterP, int cid);
  
  //static {System.out.println("Loaded MapRClient in !" + MapRClient.class.getClassLoader());}
  public native InodeAttributes openFid(long clntPtr, String pfid, 
						String file, 
						long [] ips, ErrorValue err, MapRUserInfo userInfo);

  public native final long createFid(long clntPtr, String pfid, String file, 
					     int mask, int mode, long chunkSize,
					     ErrorValue err, MapRUserInfo userInfo);

  public native final int removeFid(long clntPtr, String pfid, String dir, 
					    ErrorValue err, MapRUserInfo userInfo);

  public native final String mkdirsFid(long clntPtr, String pfid, String file, 
					       int mask, int mode, boolean compress, 
					       long chunkSize, ErrorValue err, MapRUserInfo userInfo);

  public native byte[] scanKV(long clntPtr, String name,
				      byte[] start, byte[] end, int maxkeys,
				      ErrorValue err);

  /** ------------------------ KvStore native calls -------------------------*/
  public native final byte[] lookupkv(long clntPtr, String kvPath,
					      byte[] key, ErrorValue err);

  public native final byte[] scankvgivenfid(long clntPtr, byte[] kvFid,
						    byte[] start, byte[] end,
						    ErrorValue err);

  /** ------------------------ Goose native calls ---------------------------
 * @param userInfo TODO*/
  public native final long opentable(long clntPtr, String name, ErrorValue err, MapRUserInfo userInfo);
  
  public native final String createtable(long clntPtr, String name, String user, byte[] attr, byte[] aces,
						 int mode, byte [][] splitKeys,
						 boolean needServerInfo, int auditValue, 
						 ErrorValue err, MapRUserInfo userInfo);
  
  public native final byte[] gettablets(long clntPtr, String tablePath, byte[] stKey,
						ErrorValue err, MapRUserInfo userInfo);

  public native final void createcolumnfamily(long clntPtr, String tablePath,
						      String name, byte[] schFamily,
						      ErrorValue err, MapRUserInfo userInfo);

  public native final void modifycolumnfamily(long clntPtr, String tablePath,
						      String name, byte[] schFamily,
						       ErrorValue err, MapRUserInfo userInfo);

  public native final void deletecolumnfamily(long clntPtr, String tablePath, 
						      String name, ErrorValue err, MapRUserInfo userInfo);

  public native final byte[] listcolumnfamily(long clntPtr, String tablePath,
                                              boolean wantAces,
					      ErrorValue err, MapRUserInfo userInfo);
  
  public native final void modifytableattr(long clntPtr, String tablePath,
						   byte[] tableAttr, byte[] tableAces, boolean genUuid,
						   ErrorValue err, MapRUserInfo userInfo);

  public native final byte[] gettableattr(long clntPtr, String tablePath,
						  ErrorValue err, MapRUserInfo userInfo);
  
  public native final String getServerForCid(long clntPtr, int cid, ErrorValue err);

  public native final byte[] tabletstat(long clntPtr, String fid, ErrorValue err);

  public native final void splittableregion(long clntPtr, String fidstr,
                                            boolean ignoreRegionTooSmallError,
                                            ErrorValue err);
  
  public native final void packtableregion(long clntPtr, String fidstr,
                                            int ctype, ErrorValue err);

  public native final void mergetableregion(long clntPtr, String fidstr,
                                              ErrorValue err);
  public static native final int getNumAvailRAPages();
  public static native final int getNumRAPages();

  public native final byte[] listtablereplicas(long clntPtr, String tablePath,
                                               boolean wantStats,
                                               boolean refreshNow,
                                               ErrorValue err,
                                               MapRUserInfo userInfo);

  public native final void addtablereplica(long clntPtr, String tablePath,
                                           byte[] replicaDesc,
                                           ErrorValue err,
                                           MapRUserInfo userInfo);

  public native final void edittablereplica(long clntPtr, String tablePath,
                                            String clusterName, String replicaPath,
                                            boolean allowAllCfs, byte[] replicaDesc,
                                            ErrorValue err, MapRUserInfo userInfo);

  public native final void removetablereplica(long clntPtr, String tablePath,
                                              byte[] replicaDesc,
                                              ErrorValue err,
                                              MapRUserInfo userInfo);

  public native final byte[] listtableupstreams(long clntPtr, String tablePath,
                                                ErrorValue err,
                                                MapRUserInfo userInfo);

  public native final void addtableupstream(long clntPtr, String tablePath,
                                            byte[] upstreamDesc,
                                            ErrorValue err,
                                            MapRUserInfo userInfo);

  public native final void removetableupstream(long clntPtr, String tablePath,
                                               byte[] upstreamDesc,
                                               ErrorValue err,
                                               MapRUserInfo userInfo);
  public native final void enablePrivilegedProcessAccess(long clntPtr,
                                                         boolean enable);
}
