package com.mapr.fs.jni;

public class JNIFileStatus {
  public long length;
  public boolean isdir;
  public boolean isRegular;
  public short block_replication;
  public long chunkSize; // In hadoop, this is referred to as blocksize
  public long modification_time;
  public long access_time;
  public short mode;
  public String owner;
  public String group;
  public String authority;
  public String symlink;
  public String pathStr;
  public String type;
  public String subType;
  public int major;
  public int minor;
  public long nblocks;

  // MapRFs specific parameters
  public boolean hasAce;
  public boolean compress;
  public String compressionName;
  public int cid;
  public int cinum;
  public int uniq;
  public boolean isTable;
  public boolean wireSecurityEnabled;
  public boolean audit;
  public int nlink;
  public int pcid;
  public int pcinum;
  public int puniq;

  public static class VolumeInfo {
    public String name;
    public int cid;
    public int cinum;
    public int uniq;
    public int linkAttrType;

    public VolumeInfo(String volName, int volCid, int volCinum, 
        int volUniq, int volLinkAttrType) {
      this.name = volName;
      this.cid = volCid;
      this.cinum = volCinum;
      this.uniq = volUniq;
      this.linkAttrType = volLinkAttrType;
    }
    public String getName() {
      return name;
    }
    public int getCid() {
      return cid;
    }
    public int getCinum() {
      return cinum;
    }
    public int getUniq() {
      return uniq;
    }
    public int getVolLinkAttrType() {
      return linkAttrType;
    }
  }

  public VolumeInfo volInfo;

  public JNIFileStatus() {
    this(0, false, false, 0, 0, 0, 0, (short) 0, null, null, null, null, null, true,
      null, false, 0, 0, 0, null, null, 0, false, false,
      /* nlink, type, subtype, major, minor, nblocks */ 0, null, null, 0, 0, 0,
      /* pcid, pcinum, puniq */ 0, 0, 0);
  }

  public JNIFileStatus(String dir, long time) {
    this(0, true, false, 0, 0, time, time, (short) 0555, "root", "root", null, null,
      dir, true, null, false, 0, 0, 0, null, null, 0, false, false,
      /* nlink, type, subtype, major, minor, nblocks */ 0, null, null, 0, 0, 0,
      /* pcid, pcinum, puniq */ 0, 0, 0);
  }

  public JNIFileStatus(long length, boolean isdir, boolean isRegular, int block_replication,
      long chunkSize, long modification_time, long access_time, short mode,
      String owner, String group, String authority, String symlink, String pathStr,
      boolean compress, String compressionName, boolean hasAce, int cid, int cinum, int uniq,
      JNIFileStatus volJNIStatus, String volName, int volLinkAttrType,
      boolean wireSecurityEnabled, boolean audit, int nlink, String type,
      String subType, int major, int minor, long nblocks, int pcid, int pcinum,
      int puniq) {
    this(length, isdir, false, isRegular, block_replication, chunkSize, modification_time,
      access_time, mode, owner, group, authority, symlink, pathStr, compress,
      compressionName, hasAce, cid, cinum, uniq, volName, 0, 0, 0,
      volLinkAttrType, wireSecurityEnabled, audit, nlink, type, subType,
      pcid, pcinum, puniq, major, minor, nblocks);
  }

  public JNIFileStatus(long length, boolean isdir, boolean isTable, boolean isRegular,
      int block_replication, long chunkSize, long modification_time, long access_time,
      short mode, String owner, String group, String authority, String symlink, 
      String pathStr, boolean compress, String compressionName, boolean hasAce,
      int cid, int cinum, int uniq, String volName, int volCid, int volCinum,
      int volUniq, int volLinkAttrType, boolean wireSecurityEnabled,
      boolean audit, int nlink, String type, String subType, int pcid, int pcinum,
      int puniq, int major, int minor, long nblocks) {
    this.isRegular = isRegular;
    this.isTable = isTable;
    this.length = length;
    this.isdir = isdir;
    this.block_replication = (short) block_replication;
    this.chunkSize = chunkSize;
    this.modification_time = modification_time;
    this.access_time = access_time;
    this.mode = mode;
    this.owner = (owner == null) ? "" : owner;
    this.group = (group == null) ? "" : group;
    this.authority = authority;
    this.symlink = symlink;
    this.pathStr = pathStr;
    this.compress = compress;
    this.compressionName = (compressionName == null) ? "" : compressionName;
    this.hasAce = hasAce;
    this.cid = cid;
    this.cinum = cinum;
    this.uniq = uniq;
    if (volName != null) {
      this.volInfo = new VolumeInfo(volName, volCid, volCinum, volUniq, volLinkAttrType);
    }
    this.wireSecurityEnabled = wireSecurityEnabled;
    this.audit = audit;
    this.nlink = nlink;
    this.type = type;
    this.subType = subType;
    this.major = major;
    this.minor = minor;
    this.nblocks = nblocks;
    this.pcid = pcid;
    this.pcinum = pcinum;
    this.puniq = puniq;
  }
}
