/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

// import org.apache.commons.logging.Log;
// import org.apache.commons.logging.LogFactory;

public class InodeAttributes {
  // public static final Log LOG = LogFactory.getLog(InodeAttributes.class);
  
  public int           cid;
  public int           cinum;
  public int           uniq;

  public long          filesize;
  public long          chunksize;
  public boolean       compress;
  public long          filePtr;

  public InodeAttributes () {
    cid = cinum = uniq = 0;
    filesize = 0;
    filePtr = 0;
  }
  
  public InodeAttributes (int cid, int cinum, int uniq,
                          long filesize, long chunksize, 
                          boolean compress, long filePtr) {
    this.cid = cid;
    this.cinum = cinum;
    this.uniq = uniq;
    this.filesize = filesize;
    this.chunksize = chunksize;
    this.compress = compress;
    this.filePtr = filePtr;
    
//    if (JNILoggerProxy.isDebugEnabled()) {
//    	JNILoggerProxy.debug(">InodeAttributes: fid: " + toString() + 
//          ", filesize: " + filesize + ", chunksize: " + chunksize);
//    }
  }
  
  public String toString() { return cid + "." + cinum + "." + uniq; }

  public boolean eq(InodeAttributes a) {
    return a != null &&
        this.cinum == a.cinum && this.uniq == a.uniq && this.cid == a.cid;
  }
}
