package com.mapr.fs.jni;

import java.io.IOException;

/**
 * This class is used to bundle a filesystem error code 
 * with a standard IOException.
 */
public class IOExceptionWithErrorCode extends IOException {
  private int _errorCode;

  /** 
   * default constructor
   * @param errorCode Filesystem error code
   */
  public IOExceptionWithErrorCode(int errorCode) {
    super();
    _errorCode = errorCode;
  }

  /**
   * Constructor
   * @param s message
   * @param errorCode Filesystem error code
   */
  public IOExceptionWithErrorCode(String s, int errorCode) {
    super(s);
    _errorCode = errorCode;
  }

  /**
   * Constructor taking another exception.
   * @param t Exception to grab data from.
   * @param errorCode Filesystem error code
   */
  public IOExceptionWithErrorCode(Throwable t, int errorCode) {
    super(t);
    _errorCode = errorCode;
  }

  /**
   * Constructor taking a message and another exception.
   * @param s message
   * @param t Exception to grab data from.
   * @param errorCode Filesystem error code
   */
  public IOExceptionWithErrorCode(String s, Throwable t, int errorCode) {
    super(s, t);
    _errorCode = errorCode;
  }

  /**
   * Accessor for filesystem error code
   * @return Filesystem error code
   */
  public int getErrorCode() {
    return _errorCode;
  }
}
