/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.jni;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestClassLoaders {
    static final String MAVEN_REPO_BASE = "/C:/Users/jnadeau/.m2/repository";
    static final String[] MAVEN_JARS = new String[]{"/com/mapr/hadoop/hadoop-core/2.1.1/hadoop-core-2.1.1.jar", "/com/mapr/hadoop/mapr-jni/2.1.2-SNAPSHOT/mapr-jni-2.2.1-SNAPSHOT.jar", "/commons-cli/commons-cli/1.2/commons-cli-1.2.jar", "/xerces/xerces/1.4.4/xerces-1.4.4.jar", "/xmlenc/xmlenc/0.52/xmlenc-0.52.jar", "/commons-httpclient/commons-httpclient/3.1/commons-httpclient-3.1.jar", "/commons-codec/commons-codec/1.5/commons-codec-1.5.jar", "/commons-net/commons-net/3.1/commons-net-3.1.jar", "/org/mortbay/jetty/jetty/6.1.14/jetty-6.1.14.jar", "/org/mortbay/jetty/jetty-util/6.1.14/jetty-util-6.1.14.jar", "/asm/asm/3.2/asm-3.2.jar", "/com/sun/jersey/jersey-core/1.8/jersey-core-1.8.jar", "/com/sun/jersey/jersey-json/1.8/jersey-json-1.8.jar", "/org/codehaus/jettison/jettison/1.1/jettison-1.1.jar", "/stax/stax-api/1.0.1/stax-api-1.0.1.jar", "/com/sun/xml/bind/jaxb-impl/2.2.3-1/jaxb-impl-2.2.3-1.jar", "/javax/xml/bind/jaxb-api/2.2.2/jaxb-api-2.2.2.jar", "/javax/xml/stream/stax-api/1.0-2/stax-api-1.0-2.jar", "/org/codehaus/jackson/jackson-core-asl/1.7.1/jackson-core-asl-1.7.1.jar", "/org/codehaus/jackson/jackson-jaxrs/1.7.1/jackson-jaxrs-1.7.1.jar", "/org/codehaus/jackson/jackson-xc/1.7.1/jackson-xc-1.7.1.jar", "/com/sun/jersey/jersey-server/1.8/jersey-server-1.8.jar", "/tomcat/jasper-runtime/5.5.12/jasper-runtime-5.5.12.jar", "/tomcat/jasper-compiler/5.5.12/jasper-compiler-5.5.12.jar", "/commons-el/commons-el/1.0/commons-el-1.0.jar", "/commons-daemon/commons-daemon/1.0.1/commons-daemon-1.0.1.jar", "/commons-logging/commons-logging/1.0.4/commons-logging-1.0.4.jar", "/log4j/log4j/1.2.15/log4j-1.2.15.jar", "/javax/mail/mail/1.4/mail-1.4.jar", "/javax/activation/activation/1.1/activation-1.1.jar", "/net/java/dev/jets3t/jets3t/0.6.1/jets3t-0.6.1.jar", "/org/mortbay/jetty/servlet-api-2.5/6.1.14/servlet-api-2.5-6.1.14.jar", "/com/google/code/p/arat/rat-lib/0.5.1/rat-lib-0.5.1.jar", "/commons-lang/commons-lang/2.4/commons-lang-2.4.jar", "/commons-collections/commons-collections/3.1/commons-collections-3.1.jar", "/commons-logging/commons-logging-api/1.0.4/commons-logging-api-1.0.4.jar", "/org/slf4j/slf4j-api/1.4.3/slf4j-api-1.4.3.jar", "/org/eclipse/jdt/core/3.1.1/core-3.1.1.jar", "/oro/oro/2.0.8/oro-2.0.8.jar", "/org/slf4j/slf4j-log4j12/1.4.3/slf4j-log4j12-1.4.3.jar", "/org/mockito/mockito-all/1.8.5/mockito-all-1.8.5.jar", "/org/mortbay/jetty/jetty-servlet-tester/6.1.14/jetty-servlet-tester-6.1.14.jar", "/org/codehaus/jackson/jackson-mapper-asl/1.5.2/jackson-mapper-asl-1.5.2.jar", "/org/aspectj/aspectjrt/1.6.5/aspectjrt-1.6.5.jar", "/org/aspectj/aspectjtools/1.6.5/aspectjtools-1.6.5.jar", "/commons-configuration/commons-configuration/1.8/commons-configuration-1.8.jar", "/org/apache/commons/commons-math/2.1/commons-math-2.1.jar", "/com/google/guava/guava/14.0.1/guava-14.0.1.jar", "/net/java/dev/eval/eval/0.5/eval-0.5.jar", "/org/apache/zookeeper/zookeeper/3.3.6/zookeeper-3.3.6.jar", "/jline/jline/0.9.94/jline-0.9.94.jar", "/com/mapr/util/central-logging/2.1.1/central-logging-2.1.1.jar", "/junit/junit/4.11/junit-4.11.jar"};
    static final String[] BASE_CLASSES = new String[]{"../jni/target/classes/", "../java/target/classes/", "../java/target/test-classes/"};

    public static BufferedInputStream openByteStream(Class<?> referenceClass, String resourceFileName) throws IOException {
        URL url = TestClassLoaders.find(referenceClass, resourceFileName);
        if (url != null) {
            return new BufferedInputStream(url.openStream());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String loadIntoString(Class<T> referenceClass, String path) throws IOException {
        BufferedInputStream in = TestClassLoaders.openByteStream(referenceClass, path);
        if (in == null) {
            throw new FileNotFoundException(String.format("reference class:%s, path:%s", referenceClass.getName(), path));
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            byte[] tmp = new byte[4028];
            int readBytes = 0;
            while ((readBytes = in.read(tmp)) != -1) {
                buf.write(tmp, 0, readBytes);
            }
            buf.flush();
            String string = buf.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    @Test
    @Ignore(value="The class path points to stale entries, reeable after fixing.")
    public void loadWithDiffentClassloadersInTheSameJVM() throws Exception {
        String fileSystemClass = "com.mapr.fs.MapRFileSystem";
        URL[] originalClassPaths = TestClassLoaders.getURLs();
        ClassLoader parent = this.getClass().getClassLoader().getParent();
        ClassWorld cw = new ClassWorld();
        ClassRealm P = cw.newRealm("P", parent);
        System.out.println("===================SWITCHING TO P: " + P + "===============");
        try {
            P.loadClass("com.mapr.fs.MapRFileSystem");
            Assert.fail((String)"com.mapr.fs.MapRFileSystem is found in the parent");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        ClassRealm L1 = cw.newRealm("l1", (ClassLoader)URLClassLoader.newInstance(originalClassPaths, parent));
        System.out.println("===================SWITCHING TO C1: " + L1 + "===============");
        TestClassLoaders.runBasicTest(L1);
        ClassRealm L2 = cw.newRealm("l2", (ClassLoader)URLClassLoader.newInstance(originalClassPaths, parent));
        System.out.println("===================SWITCHING TO C2: " + L2 + "===============");
        TestClassLoaders.runBasicTest(L2);
    }

    private static void runBasicTest(ClassRealm realm) throws Exception {
        Class C2 = realm.loadClass("com.mapr.fs.BasicReadTest");
        Method m = C2.getMethod("fsops", new Class[0]);
        m.invoke(null, new Object[0]);
    }

    private static String packagePath(String packageName) {
        String packageAsPath = packageName.replaceAll("\\.", "/");
        return packageAsPath.endsWith("/") ? packageAsPath : packageAsPath + "/";
    }

    public static URL find(Class<?> referenceClass, String resourceFileName) {
        String packagePath = TestClassLoaders.packagePath(referenceClass.getPackage().getName());
        String resourcePath = packagePath + resourceFileName;
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        for (ClassLoader cl = Thread.currentThread().getContextClassLoader(); cl != null; cl = cl.getParent()) {
            URL r = cl.getResource(resourcePath);
            if (r == null) continue;
            return r;
        }
        return TestClassLoaders.class.getResource(resourcePath);
    }

    static URL[] getURLs() throws MalformedURLException {
        int i;
        URL[] u = new URL[MAVEN_JARS.length + BASE_CLASSES.length];
        for (i = 0; i < MAVEN_JARS.length; ++i) {
            u[i] = new File(MAVEN_REPO_BASE + MAVEN_JARS[i]).toURL();
        }
        int x = 0;
        while (x < BASE_CLASSES.length) {
            u[i] = new File(BASE_CLASSES[x]).toURL();
            ++x;
            ++i;
        }
        return u;
    }

    public static void main(String[] args) throws Exception {
        TestClassLoaders t = new TestClassLoaders();
        t.loadWithDiffentClassloadersInTheSameJVM();
    }
}

