/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.io.Console;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RSpeedTest {
    public static final String MAPRFS_URI = "maprfs:///";
    public static final int NUM_THREADS = 16;
    public static final int THREAD_MEGS = 8;
    public static final int SINGLE_READ_BYTES = 0x800000;
    String dirName;
    int numThreads;
    int threadMegs;
    int singleReadSize;
    String uri;

    public static void usage() {
        System.err.println("usage: RWSpeedTest dirname [-threads <num threads>] [-thread-megs <thread read megabytes>] [-uri <uri>] [-single-read <single read bytes>] [-input]");
        System.err.println("    threads: number of reader threads");
        System.err.println("    thread-megs: bytes to be read per read task");
        System.err.println("    single-read: bytes to be read per read call");
        System.err.println("    uri: FileSystem URI");
        System.err.println("    input: Wait for user input before starting(Usefulto attach debugger to the process)");
    }

    public RSpeedTest(String dName, int nThreads, int tMegs, int sRead, String u) {
        this.dirName = dName;
        this.numThreads = nThreads;
        this.threadMegs = tMegs;
        this.singleReadSize = sRead;
        this.uri = u;
    }

    public void run() throws Exception {
        long sT = System.nanoTime();
        Configuration conf = new Configuration();
        System.out.println("Dir Name: " + this.dirName);
        System.out.println("Num Thrs: " + this.numThreads);
        System.out.println("Thr Megs: " + this.threadMegs + "M");
        System.out.println("Single Read: " + this.singleReadSize);
        System.out.println("URI     : " + this.uri);
        conf.set("fs.default.name", MAPRFS_URI);
        if (this.uri.equals(MAPRFS_URI)) {
            conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        }
        if (this.uri.contains("hdfs")) {
            conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs");
        }
        FileSystem fs = FileSystem.get((URI)URI.create(this.uri), (Configuration)conf);
        Path p = new Path(this.dirName);
        FileStatus[] fileStatuses = fs.listStatus(p);
        ArrayList<Thread> readers = new ArrayList<Thread>();
        ReadTasks rTasks = new ReadTasks();
        this.threadMegs = this.threadMegs * 1024 * 1024;
        for (int i = 0; i < fileStatuses.length; ++i) {
            int j = 0;
            while ((long)j < fileStatuses[i].getLen()) {
                ReadTask t = new ReadTask(fs, fileStatuses[i], j);
                rTasks.addTask(t);
                j += this.threadMegs;
            }
        }
        rTasks.shuffleTasks();
        int numTasksPerThread = rTasks.numPending() / this.numThreads + 1;
        for (int i = 0; i < this.numThreads; ++i) {
            Reader r = new Reader(this.threadMegs, this.singleReadSize);
            r.getTasks(rTasks, numTasksPerThread);
            Thread t = new Thread(r);
            readers.add(t);
            t.start();
        }
        long eT = System.nanoTime();
        System.out.println("Setup time: " + (eT - sT) / 1000000L + " msecs");
        sT = System.nanoTime();
        for (int i = 0; i < this.numThreads; ++i) {
            ((Thread)readers.get(i)).join();
        }
        eT = System.nanoTime();
        System.out.println("Run time: " + (eT - sT) / 1000000L + " msecs");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            RSpeedTest.usage();
            System.exit(1);
        }
        int ac = 0;
        int numThreads = 16;
        int threadMegs = 8;
        int singleReadSize = 0x800000;
        String uri = MAPRFS_URI;
        String dirName = args[ac++];
        while (ac < args.length) {
            if (args[ac].equals("-threads")) {
                int n = ++ac;
                ++ac;
                numThreads = Integer.parseInt(args[n]);
                continue;
            }
            if (args[ac].equals("-thread-megs")) {
                int n = ++ac;
                ++ac;
                threadMegs = Integer.parseInt(args[n]);
                continue;
            }
            if (args[ac].equals("-single-read")) {
                int n = ++ac;
                ++ac;
                singleReadSize = Integer.parseInt(args[n]);
                continue;
            }
            if (args[ac].equals("-uri")) {
                int n = ++ac;
                ++ac;
                uri = args[n];
                continue;
            }
            if (args[ac++].equals("-input")) {
                Console console = System.console();
                console.readLine("Enter input:", new Object[0]);
                continue;
            }
            RSpeedTest.usage();
            System.exit(1);
        }
        RSpeedTest test = new RSpeedTest(dirName, numThreads, threadMegs, singleReadSize, uri);
        test.run();
    }

    private class ReadTasks {
        ArrayList<ReadTask> tasks = new ArrayList();

        public int numPending() {
            int ret = this.tasks.size();
            return ret;
        }

        public void shuffleTasks() {
            Collections.shuffle(this.tasks);
        }

        public void addTask(ReadTask t) {
            this.tasks.add(t);
        }

        public ReadTask removeTask() {
            ReadTask t = null;
            if (this.tasks.size() > 0) {
                t = this.tasks.remove(0);
            }
            return t;
        }
    }

    private class ReadTask {
        FileSystem fileSystem;
        FileStatus stat;
        int offset;

        public ReadTask(FileSystem fs, FileStatus s, int o) {
            this.fileSystem = fs;
            this.stat = s;
            this.offset = o;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public FileStatus getStat() {
            return this.stat;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private class Reader
    implements Runnable {
        private ReadTasks rTasks;
        private int numReadMegs;
        private int singleReadSize;

        public Reader(int megs, int sRead) {
            this.numReadMegs = megs;
            this.singleReadSize = sRead;
            this.rTasks = new ReadTasks();
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[this.numReadMegs];
                while (this.rTasks.numPending() != 0) {
                    int readOffset;
                    int iterRead;
                    ReadTask t = this.rTasks.removeTask();
                    FileSystem fs = t.getFileSystem();
                    Path filePath = t.getStat().getPath();
                    FSDataInputStream is = null;
                    try {
                        is = fs.open(filePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                    int toRead = this.numReadMegs;
                    for (int numRead = 0; numRead < toRead && (iterRead = is.read((long)(readOffset = t.getOffset() + numRead), buf, 0, this.singleReadSize)) > 0; numRead += iterRead) {
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void getTasks(ReadTasks allTasks, int maxTasks) {
            for (int i = 0; i < maxTasks && allTasks.numPending() != 0; ++i) {
                this.rTasks.addTask(allTasks.removeTask());
            }
        }
    }
}

