/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.tables;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.mapr.fs.FSTests;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.PathBuilder;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.ExtIndexDesc;
import com.mapr.fs.tables.ExtIndexFieldDesc;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestTableIndexes
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestTableIndexes.class);
    private static final String YAML_SEP = ": ";
    private static final String FAMILY_F = "f";
    private static final String FAMILY_G = "g";
    static final Path TEST_TABLE_PATH_ALT = new Path("/user/aditya/employee_tab");
    static final Path TEST_TABLE_PATH = new Path(FSTests.getTestRoot(), "table-testGetTableIndexes");
    static final Path ES_REPLICA_BASE_PATH = new Path("/opt/external/elasticsearch/replicas");
    static final Path TEST_REPLICA1_PATH = new Path("/opt/external/elasticsearch/replicas");
    static final String ES_REPLICA_CLUSTER_NAME = "test-elastic-cluster";
    static final String ES_INDEX_NAME = "test-elastic-index";
    static final String ES_TYPE_NAME = "test-elastic-type";
    static final String REPLICA_INDEX_NAME = "test-elastic-index/test-elastic-type";
    static final Dbserver.ColumnFamilyAttr FAMILY_F_ATTR = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(Dbserver.SchemaFamily.newBuilder().setName("f")).build();
    static final Dbserver.ColumnFamilyAttr FAMILY_G_ATTR = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(Dbserver.SchemaFamily.newBuilder().setName("g")).build();
    private static Path tableReplicaBasePath;

    @BeforeClass
    public static void setupTestTableIndexes() throws IOException {
        Dbserver.TableAttr.Builder tableAttrBuilder = Dbserver.TableAttr.getDefaultInstance().toBuilder();
        tableAttrBuilder.setJson(false);
        FSTests.maprfs().createTable(TEST_TABLE_PATH, null, false, false);
        FSTests.maprfs().createColumnFamily(TEST_TABLE_PATH, FAMILY_F, FAMILY_F_ATTR, null);
        FSTests.maprfs().createColumnFamily(TEST_TABLE_PATH, FAMILY_G, FAMILY_G_ATTR, null);
        MapRFileStatus fStatus = FSTests.maprfs().getMapRFileStatus(TEST_TABLE_PATH);
        byte[] tableUUID = FSTests.maprfs().getTableProperties(TEST_TABLE_PATH).getUuid();
        tableReplicaBasePath = new Path(ES_REPLICA_BASE_PATH, fStatus.getFidStr());
        Path replicaTableParent = new PathBuilder(tableReplicaBasePath).add(ES_REPLICA_CLUSTER_NAME).add(ES_INDEX_NAME).add(ES_TYPE_NAME).build();
        if (!FSTests.maprfs().exists(replicaTableParent)) {
            FSTests.maprfs().mkdirs(replicaTableParent);
        }
        Path replicaTablePath = new Path(replicaTableParent, "config.es");
        try (FSDataOutputStream out = FSTests.maprfs().create(replicaTablePath, true);){
            StringBuilder sb = new StringBuilder();
            sb.append("sink.class.path").append(YAML_SEP).append("/tmp").append('\n');
            sb.append("es.target.name").append(YAML_SEP).append(ES_REPLICA_CLUSTER_NAME).append('\n');
            sb.append("es.index.name").append(YAML_SEP).append(ES_INDEX_NAME).append('\n');
            sb.append("es.index.type").append(YAML_SEP).append(ES_TYPE_NAME).append('\n');
            out.writeBytes(sb.toString());
        }
        Dbserver.TableReplicaDesc.Builder replBuilder = Dbserver.TableReplicaDesc.newBuilder().setIsPaused(true).setExternal(true).setEncryptonwire(false).setThrottle(false).setTablePath(replicaTablePath.toString()).setTableUuid(ByteString.copyFrom((byte[])tableUUID)).setReplicaClassName("com.mapr.fs.external.es.ESSink").setIndexedFields("f:name, f:street;f:city;g,g:age; f").setClusterName(FSTests.maprfs().getClusterNameUnchecked(replicaTablePath.toString()));
        FSTests.maprfs().addTableReplica(TEST_TABLE_PATH, replBuilder.build(), null);
    }

    @AfterClass
    public static void cleanupTestTableIndexes() throws IOException {
        if (FSTests.maprfs().exists(TEST_TABLE_PATH)) {
            FSTests.maprfs().delete(TEST_TABLE_PATH);
        }
        if (FSTests.maprfs().exists(tableReplicaBasePath) && tableReplicaBasePath.toString().startsWith("/opt/external/elasticsearch/replicas")) {
            FSTests.maprfs().delete(tableReplicaBasePath, true);
        }
    }

    @Test
    public void testGetTableIndexes() throws IllegalArgumentException, IOException {
        Collection tableIndexes = FSTests.mapradmin().getTableExternalIndexes(TEST_TABLE_PATH, false);
        _logger.info(tableIndexes.toString());
        Assert.assertEquals((long)3L, (long)tableIndexes.size());
        Iterator indeItr = tableIndexes.iterator();
        ExtIndexDesc IndexDescDep = (ExtIndexDesc)indeItr.next();
        List indexedFields = IndexDescDep.getIndexedFields();
        Assert.assertEquals((long)1L, (long)indexedFields.size());
        ExtIndexFieldDesc indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(0);
        Assert.assertEquals((Object)"f:name", (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        Collection coveredFields = IndexDescDep.getCoveredFields();
        Assert.assertEquals((long)2L, (long)coveredFields.size());
        ImmutableSet expectedCoveredFields = ImmutableSet.of((Object)FAMILY_F, (Object)FAMILY_G);
        HashSet actualCoveredFields = Sets.newHashSet();
        for (ExtIndexFieldDesc coveredField : coveredFields) {
            actualCoveredFields.add(coveredField.getFieldName());
            Assert.assertEquals((Object)ExtIndexFieldDesc.Order.None, (Object)coveredField.getSortOrder());
            Assert.assertFalse((boolean)coveredField.isFunctional());
        }
        Assert.assertEquals((Object)expectedCoveredFields, (Object)actualCoveredFields);
        Assert.assertTrue((boolean)IndexDescDep.isDisabled());
        Assert.assertTrue((boolean)IndexDescDep.isExternal());
        Assert.assertFalse((boolean)IndexDescDep.isUnique());
        Assert.assertNull((Object)IndexDescDep.getConnectionString());
        Assert.assertEquals((Object)"elastic", (Object)IndexDescDep.getSystem());
        Assert.assertEquals((Object)ES_REPLICA_CLUSTER_NAME, (Object)IndexDescDep.getCluster());
        Assert.assertEquals((Object)REPLICA_INDEX_NAME, (Object)IndexDescDep.getIndexName());
        IndexDescDep = (ExtIndexDesc)indeItr.next();
        indexedFields = IndexDescDep.getIndexedFields();
        Assert.assertEquals((long)3L, (long)indexedFields.size());
        indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(0);
        Assert.assertEquals((Object)"f:street", (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(1);
        Assert.assertEquals((Object)"f:city", (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(2);
        Assert.assertEquals((Object)FAMILY_G, (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        coveredFields = IndexDescDep.getCoveredFields();
        Assert.assertEquals((long)1L, (long)coveredFields.size());
        ExtIndexFieldDesc coveredField = (ExtIndexFieldDesc)coveredFields.iterator().next();
        Assert.assertEquals((Object)FAMILY_F, (Object)coveredField.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.None, (Object)coveredField.getSortOrder());
        Assert.assertFalse((boolean)coveredField.isFunctional());
        Assert.assertTrue((boolean)IndexDescDep.isDisabled());
        Assert.assertTrue((boolean)IndexDescDep.isExternal());
        Assert.assertFalse((boolean)IndexDescDep.isUnique());
        Assert.assertNull((Object)IndexDescDep.getConnectionString());
        Assert.assertEquals((Object)"elastic", (Object)IndexDescDep.getSystem());
        Assert.assertEquals((Object)ES_REPLICA_CLUSTER_NAME, (Object)IndexDescDep.getCluster());
        Assert.assertEquals((Object)REPLICA_INDEX_NAME, (Object)IndexDescDep.getIndexName());
        IndexDescDep = (ExtIndexDesc)indeItr.next();
        indexedFields = IndexDescDep.getIndexedFields();
        Assert.assertEquals((long)2L, (long)indexedFields.size());
        indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(0);
        Assert.assertEquals((Object)"g:age", (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        indexFieldDesc = (ExtIndexFieldDesc)indexedFields.get(1);
        Assert.assertEquals((Object)FAMILY_F, (Object)indexFieldDesc.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.Asc, (Object)indexFieldDesc.getSortOrder());
        Assert.assertFalse((boolean)indexFieldDesc.isFunctional());
        coveredFields = IndexDescDep.getCoveredFields();
        Assert.assertEquals((long)1L, (long)coveredFields.size());
        coveredField = (ExtIndexFieldDesc)coveredFields.iterator().next();
        Assert.assertEquals((Object)FAMILY_G, (Object)coveredField.getFieldName());
        Assert.assertEquals((Object)ExtIndexFieldDesc.Order.None, (Object)coveredField.getSortOrder());
        Assert.assertFalse((boolean)coveredField.isFunctional());
        Assert.assertTrue((boolean)IndexDescDep.isDisabled());
        Assert.assertTrue((boolean)IndexDescDep.isExternal());
        Assert.assertFalse((boolean)IndexDescDep.isUnique());
        Assert.assertNull((Object)IndexDescDep.getConnectionString());
        Assert.assertEquals((Object)"elastic", (Object)IndexDescDep.getSystem());
        Assert.assertEquals((Object)ES_REPLICA_CLUSTER_NAME, (Object)IndexDescDep.getCluster());
        Assert.assertEquals((Object)REPLICA_INDEX_NAME, (Object)IndexDescDep.getIndexName());
    }
}

