/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.utils.ssh;

import com.jcraft.jsch.JSchException;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.ClusterConf;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.utils.ssh.RunCommand;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCluster {
    private static final Logger _logger;
    private static final TestCluster DEFAULT_TEST_CLUSTER;
    private static final int[] DEFAULT_SUCCESS_CODE;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ClusterConf clusterConf;
    private final ClusterConf.ClusterEntry defaultCluster;
    private final String firstCLDBHost;

    private TestCluster() {
        try {
            this.clusterConf = new ClusterConf();
            List entries = this.clusterConf.getClusterList();
            this.defaultCluster = (ClusterConf.ClusterEntry)entries.get(0);
            this.firstCLDBHost = ((CLDBRpcCommonUtils.SocketAddr)this.defaultCluster.getSocketAddrsList().get(0)).getIpAddr().toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse/initialize mapr-cluster.conf ", e);
        }
    }

    public RunCommand _runCommand(String command) throws IOException {
        String sbstCmd = command.replace("${cldb}", this.firstCLDBHost);
        RunCommand cmd = new RunCommand(this.firstCLDBHost, sbstCmd);
        try {
            _logger.debug("Running command [{}] on CLDB host {}", (Object)sbstCmd, (Object)this.firstCLDBHost);
            return this.executor.submit(cmd).get();
        }
        catch (InterruptedException | ExecutionException e) {
            IOException ioe = null;
            Throwable cause = e.getCause();
            if (cause instanceof JSchException) {
                String msg = String.format("Remote command execution failed with SSH error. Ensure that password-less SSH is configured from this node to CLDB node (%s).", this.firstCLDBHost);
                ioe = new IOException(msg, cause);
            } else {
                ioe = new IOException(cause);
            }
            _logger.debug(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public static TestCluster getTestCluster() {
        return DEFAULT_TEST_CLUSTER;
    }

    public static RunCommand runCommand(String command) throws Exception {
        return TestCluster.runCommand(command, DEFAULT_SUCCESS_CODE);
    }

    public static RunCommand runCommand(String command, int[] sucessCodes) throws Exception {
        RunCommand rc = TestCluster.getTestCluster()._runCommand(command);
        return rc;
    }

    static {
        ShimLoader.load();
        _logger = LoggerFactory.getLogger(TestCluster.class);
        DEFAULT_TEST_CLUSTER = new TestCluster();
        DEFAULT_SUCCESS_CODE = new int[]{0};
    }
}

