/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BlockLocationFileGenATest {
    static long fsize = 0x28000000L;
    static long chunksize = 0x4000000L;
    static String filePath = "/maprtbl";
    static Configuration conf;
    static FileSystem fs;
    public static final String MAPRFS_URI = "maprfs://localhost:7222/";

    public static void Usage() {
        System.err.println("usage: BlockLocationFileGen [-fsize filesize] [-csize chunksize] [-fpath /file/path]");
        System.exit(1);
    }

    public static void SetMaprFilesystemConfig() throws Exception {
        conf = new Configuration();
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        fs = FileSystem.get((URI)URI.create(conf.get("fs.default.name", MAPRFS_URI)), (Configuration)conf);
    }

    public static void WriteFile() throws Exception {
        byte[] data = new byte[0x4000000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        Path f = new Path(filePath);
        FSDataOutputStream out = fs.create(f, false, 8192, (short)1, chunksize);
        long outSize = 0L;
        long i = 0L;
        while (outSize < fsize) {
            System.out.println("Block # = " + i);
            String s = "<Block # = " + i + ">";
            out.writeChars(s);
            long fillLength = (i + 1L) * chunksize - (outSize += 2L * (long)s.length());
            out.write(data, 0, new Long(fillLength).intValue());
            outSize += fillLength;
            out.sync();
            ++i;
        }
        out.close();
    }

    public static void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-fsize")) {
                fsize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-csize")) {
                chunksize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-fpath")) {
                filePath = args[++i];
                continue;
            }
            BlockLocationFileGenATest.Usage();
        }
        System.out.println("fsize = " + fsize + "\nchunksize = " + chunksize + "\nfilePath = " + filePath + "\n");
    }

    public static void main(String[] args) throws Exception {
        BlockLocationFileGenATest.ParseArgs(args);
        BlockLocationFileGenATest.SetMaprFilesystemConfig();
        BlockLocationFileGenATest.WriteFile();
        System.out.println("BlockLocationFileGenATest completed.");
    }
}

