/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.FsPeck;
import java.util.ArrayList;
import java.util.Random;

class FSOpsThread
extends Thread {
    private long seed_;
    private long maxOps_;
    private long maxFileSize_;
    private ArrayList<String> volPaths_;
    private ArrayList<String> volNames_;
    private long endTime_;

    FSOpsThread(long seed, long maxOps, long maxFileSize, ArrayList<String> volPaths, ArrayList<String> volNames, long durationInSecs) {
        this.seed_ = seed;
        this.maxOps_ = maxOps;
        this.maxFileSize_ = maxFileSize;
        this.volPaths_ = volPaths;
        this.volNames_ = volNames;
        this.endTime_ = System.currentTimeMillis() + durationInSecs * 1000L;
    }

    @Override
    public void run() {
        System.out.println("Starting FSOpsThread");
        Random rand = new Random(this.seed_);
        FsPeck[] TestFs = new FsPeck[this.volPaths_.size()];
        System.out.println("Initializing FsPeck parameters");
        for (int i = 0; i < this.volPaths_.size(); ++i) {
            TestFs[i] = new FsPeck();
            TestFs[i].SetMaxOps(this.maxOps_);
            TestFs[i].SetMaxFileSize(this.maxFileSize_);
            TestFs[i].SetTopDir(this.volPaths_.get(i));
            TestFs[i].TestInit();
        }
        long currTime = System.currentTimeMillis();
        while (currTime < this.endTime_) {
            for (int i = 0; i < this.volPaths_.size(); ++i) {
                long randL = rand.nextLong();
                if (randL < 0L) {
                    randL = -randL;
                }
                System.out.println("Running FsPeck with seed: " + randL + " on path: " + this.volPaths_.get(i));
                TestFs[i].SetSeed(randL);
                TestFs[i].RunTest();
                TestFs[i].Verify();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                System.out.println("Exception received: " + e);
            }
            currTime = System.currentTimeMillis();
        }
    }
}

