/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.DataFrag;
import com.mapr.fs.MapRFileAce;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Vnode;
import com.mapr.fs.WriteParams;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FsPeck
implements Cloneable {
    private FsPeck[] snapShots_;
    private int[] snapShotNums_;
    private long nops_;
    private long maxOps_;
    private long seed_;
    private long maxFiles_;
    private long maxDirs_;
    private long streamingWrite_;
    private long streamingRead_;
    private long pureMap_;
    private long loadMap_;
    private long runMap_;
    private long runMapWriteOff_;
    private long maxFileSize_ = 0x100000L;
    private int maxSnapShots_ = 0;
    private boolean isListOps_ = false;
    private boolean skip = false;
    private boolean isVerifyOps_ = false;
    private boolean isIgnoreMaxFileSize_;
    private String topDir_;
    private Random rand_;
    private Vnode[] files_;
    private Vnode[] dirs_;
    private int dirCursor_;
    private int fileCursor_;
    private int fileDirCursor_;
    private int snapCursor_ = 1;
    private int fslot_;
    private int dslot_;
    private int fslotMax_;
    private int dslotMax_;
    private final int OPDIR = 0;
    private final int OPCREATE = 1;
    private final int OPUNLINK = 2;
    private final int OPWRITE = 3;
    private final int OPTRUNCATE = 4;
    private final int OPSETXATTR = 5;
    private final int OPREMOVEXATTR = 6;
    private final int OPSETACE = 7;
    private final int OPDELACE = 8;
    private final int OPSNAPCREATE = 9;
    private final int MAX_OP_TYPES = 10;
    private final int MAX_ACE_LEN = 4096;
    private int[] opsDist_ = new int[]{4, 50, 2, 1000, 0, 3, 1, 3, 1, 600};
    private int[] numOps_ = new int[10];
    private int[] opsCumulativeDist_ = new int[10];
    private final int APPEND_WRITE = 0;
    private final int APPEND_WRITE_SIZE_ALIGNED = 1;
    private final int OVERWRITE = 2;
    private static final int MAX_WRITE_OPS_TYPE = 3;
    int[] writeOpsDist_ = new int[]{700, 20, 0};
    private int[] writeOpsCumulativeDist_ = new int[3];
    private final int MAX_WRITE_SIZE = 0x200000;
    private final int BLOCKSIZE = 8192;
    private byte[] buf_ = new byte[0x200000];
    private final int MIN_DIRS = 2;
    private final int MAX_DIRS = 1000;
    private final int MIN_FILES = 10;
    private final int MAX_FILES = 10000;
    private final int MIN_XATTRS = 2;
    private final int MAX_XATTRS = 500;
    private final int MIN_ACES = 2;
    private final int MAX_ACES = 500;
    private int ndirs_ = 0;
    private int nfiles_ = 0;
    private int nxattrs_ = 0;
    private int naces_ = 0;
    private ArrayList<MapRFileAce> faces_;
    private FileSystem fs_;
    public static final String MAPRFS_URI = "maprfs:///";
    private final String SNAPSHOT = "SnapShot";

    public static void main(String[] Args) {
        int i = 0;
        boolean minusArgsDone = false;
        FsPeck TestFs = new FsPeck();
        if (Args.length == 0) {
            FsPeck.Usage();
        }
        while (i < Args.length) {
            String arg = Args[i++];
            if (minusArgsDone) {
                FsPeck.Usage();
            }
            if (arg.startsWith("-")) {
                if (arg.length() == 2) {
                    char c = arg.charAt(1);
                    switch (c) {
                        case 'l': {
                            TestFs.isListOps_ = true;
                            System.out.println(c + " len=" + arg.length());
                            break;
                        }
                        case 'v': {
                            TestFs.isVerifyOps_ = true;
                            System.out.println(c + " len=" + arg.length());
                            break;
                        }
                        case 'u': {
                            TestFs.isIgnoreMaxFileSize_ = true;
                            break;
                        }
                        case 'n': {
                            TestFs.maxOps_ = Long.parseLong(Args[i++]);
                            break;
                        }
                        case 's': {
                            TestFs.seed_ = Long.parseLong(Args[i++]);
                            System.out.println("seed_: " + TestFs.seed_);
                            break;
                        }
                        case 'f': {
                            TestFs.maxFiles_ = Long.parseLong(Args[i++]);
                            break;
                        }
                        case 'd': {
                            TestFs.maxDirs_ = Long.parseLong(Args[i++]);
                            break;
                        }
                        case 'e': {
                            TestFs.maxFileSize_ = Long.parseLong(Args[i++]);
                            break;
                        }
                        case 'x': {
                            TestFs.streamingWrite_ = 1L;
                            break;
                        }
                        case 'y': {
                            TestFs.streamingRead_ = 1L;
                            break;
                        }
                        case 'm': {
                            TestFs.pureMap_ = 1L;
                            break;
                        }
                        case 'g': {
                            TestFs.loadMap_ = 1L;
                            break;
                        }
                        case 'r': {
                            TestFs.runMap_ = 1L;
                            break;
                        }
                        case '1': {
                            TestFs.runMapWriteOff_ = 1L;
                            break;
                        }
                        case 'S': {
                            TestFs.maxSnapShots_ = Integer.parseInt(Args[i++]);
                            break;
                        }
                        default: {
                            FsPeck.Usage();
                            break;
                        }
                    }
                    continue;
                }
                FsPeck.Usage();
                continue;
            }
            minusArgsDone = true;
            TestFs.topDir_ = arg;
        }
        if (TestFs.maxSnapShots_ > 0) {
            TestFs.snapShots_ = new FsPeck[TestFs.maxSnapShots_];
            TestFs.snapShotNums_ = new int[TestFs.maxSnapShots_];
        }
        TestFs.TestInit();
        TestFs.RunTest();
        TestFs.Verify();
        for (i = 0; i < TestFs.maxSnapShots_; ++i) {
            if (TestFs.snapShotNums_[i] == 0) continue;
            TestFs.snapShots_[i].Verify();
        }
    }

    void InitAce() throws IOException {
        this.faces_ = new ArrayList();
        MapRFileAce ace = new MapRFileAce(MapRFileAce.AccessType.READFILE);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.WRITEFILE);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.EXECUTEFILE);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.READDIR);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.ADDCHILD);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.DELETECHILD);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
        ace = new MapRFileAce(MapRFileAce.AccessType.LOOKUPDIR);
        ace.setBooleanExpression("p");
        this.faces_.add(ace);
    }

    FsPeck() {
        int i;
        this.opsCumulativeDist_[0] = this.opsDist_[0];
        for (i = 1; i < 10; ++i) {
            this.opsCumulativeDist_[i] = this.opsCumulativeDist_[i - 1] + this.opsDist_[i];
        }
        this.writeOpsCumulativeDist_[0] = this.writeOpsDist_[0];
        for (i = 1; i < 3; ++i) {
            this.writeOpsCumulativeDist_[i] = this.writeOpsDist_[i - 1] + this.opsDist_[i];
        }
        try {
            this.InitAce();
        }
        catch (IOException e) {
            System.out.println("InitAce failed: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void Usage() {
        System.out.println("fspeck -n <numOPs> -s <seed> dirName -f <maxFiles> \n -d <maxDirs> -l <dryRun/listOps> \n-v <verificationOnly> -e <maxFileSize>\n-u <unlimited/NoCapOnSize>\n-S <maxSnapShots>\n");
        System.out.println("Please use all '-' arguments first and then options with arguments");
        System.exit(1);
    }

    public Object DeepClone(int snapID) throws CloneNotSupportedException {
        int i;
        FsPeck copy = (FsPeck)super.clone();
        copy.files_ = new Vnode[10000];
        for (i = 0; i < 10000; ++i) {
            if (this.files_[i] == null) continue;
            copy.files_[i] = new Vnode(this.files_[i], snapID);
            if (copy.files_[i] == null || copy.files_[i].data == null) continue;
            copy.files_[i].data = this.files_[i].data.DeepClone();
        }
        copy.dirs_ = new Vnode[1000];
        for (i = 0; i < 1000; ++i) {
            if (this.dirs_[i] == null) continue;
            copy.dirs_[i] = new Vnode(this.dirs_[i], snapID);
            if (copy.dirs_[i] == null || copy.dirs_[i].data == null) continue;
            copy.dirs_[i].data = this.dirs_[i].data.DeepClone();
        }
        return copy;
    }

    private void SetFs() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", MAPRFS_URI);
        conf.set("dfs.replication", "1");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("io.file.buffer.size", "65536");
        try {
            this.fs_ = FileSystem.get((URI)URI.create(MAPRFS_URI), (Configuration)conf);
        }
        catch (IOException e) {
            System.out.println("Fs get failed()");
        }
    }

    private int VerifySnapShot(int snapPos) {
        assert (this.snapShots_[snapPos] != null);
        this.snapShots_[snapPos].Verify();
        return 0;
    }

    private int PickSnapPos() {
        boolean idx = false;
        long rand = this.GetRandom();
        int snapPos = (int)(rand % (long)this.maxSnapShots_);
        if (this.snapShotNums_[snapPos] != 0) {
            if (this.VerifySnapShot(snapPos) != 0) {
                return 1;
            }
            String snapName = "SnapShot" + this.snapShotNums_[snapPos];
            this.DoRemoveSnapShot(snapName);
            this.snapShots_[snapPos] = null;
        }
        this.snapShotNums_[snapPos] = this.snapCursor_++;
        return snapPos;
    }

    private int DoCreateSnapShot(String snapName) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "~/mapr-hadoop/bin/maprcli volume snapshot create -snapshotname " + snapName + "  -volume mapr.cluster.root"});
            int exitVal = p.waitFor();
            return exitVal;
        }
        catch (Exception e) {
            System.out.println("Snapshot create failed with exception: " + e);
            return 1;
        }
    }

    private int DoRemoveSnapShot(String snapName) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", "~/mapr-hadoop/bin/maprcli volume snapshot remove -snapshotname " + snapName + "  -volume mapr.cluster.root"});
            int exitVal = p.waitFor();
            return exitVal;
        }
        catch (Exception e) {
            System.out.println("Snapshot remove '" + snapName + "' failed with exception: " + e);
            return 1;
        }
    }

    public int CreateSnapShot() {
        int snapPos = this.PickSnapPos();
        String snapName = "SnapShot" + this.snapShotNums_[snapPos];
        if (this.DoCreateSnapShot(snapName) != 0) {
            System.out.println("Snapshot create failed");
            return 1;
        }
        try {
            this.snapShots_[snapPos] = (FsPeck)this.DeepClone(this.snapShotNums_[snapPos]);
        }
        catch (Exception e) {
            System.out.println(e);
            return 1;
        }
        return 0;
    }

    public void SetSeed(long seed) {
        this.seed_ = seed;
    }

    public void SetMaxOps(long maxOps) {
        this.maxOps_ = maxOps;
    }

    public void SetMaxFileSize(long maxFileSize) {
        this.maxFileSize_ = maxFileSize;
    }

    public void SetTopDir(String topDir) {
        this.topDir_ = topDir;
    }

    public void SetMaxSnapShots(int maxSnapshots) {
        this.maxSnapShots_ = maxSnapshots;
    }

    public void TestInit() {
        this.fslotMax_ = 10000;
        this.dslotMax_ = 1000;
        this.rand_ = new Random(this.seed_);
        this.files_ = new Vnode[10000];
        this.dirs_ = new Vnode[1000];
        this.SetFs();
    }

    public void RunTest() {
        if (this.streamingWrite_ == 1L) {
            this.DoStreamingWrite();
            System.exit(1);
        }
        if (this.streamingRead_ == 1L) {
            this.DoStreamingRead();
            System.exit(1);
        }
        if (this.pureMap_ == 1L) {
            this.PureMap();
            System.exit(1);
        }
        if (this.loadMap_ == 1L) {
            this.LoadMap();
            System.exit(1);
        }
        if (this.runMap_ == 1L) {
            this.RunMap();
            System.exit(1);
        }
        while (this.nops_ < this.maxOps_) {
            long opPos = this.GenerateOp();
            int op = 0;
            for (op = 0; op < 10 && opPos >= (long)this.opsCumulativeDist_[op]; ++op) {
            }
            switch (op) {
                case 0: {
                    this.Mkdir();
                    break;
                }
                case 1: {
                    this.Creat();
                    break;
                }
                case 2: {
                    if (this.nfiles_ != 0) {
                        this.Unlink();
                        break;
                    }
                }
                case 3: {
                    this.Write();
                    break;
                }
                case 4: {
                    this.Truncate();
                    break;
                }
                case 5: {
                    if (this.nfiles_ != 0) {
                        this.SetXAttr(false);
                        break;
                    }
                }
                case 6: {
                    if (this.nfiles_ != 0) {
                        this.RemoveXAttr();
                        break;
                    }
                }
                case 7: {
                    if (this.nfiles_ != 0) {
                        this.SetAce(false);
                        break;
                    }
                }
                case 8: {
                    if (this.nfiles_ != 0) {
                        this.DelAce();
                        break;
                    }
                }
                case 9: {
                    if (this.maxSnapShots_ == 0) break;
                    this.CreateSnapShot();
                    break;
                }
            }
            ++this.nops_;
        }
        this.nops_ = 0L;
        this.SetXAttrsOnDirs();
        this.SetAcesOnDirs();
    }

    private void DoStreamingRead() {
        String file = new String(this.topDir_);
        Path p = new Path(file);
        try {
            long max = 0L;
            FSDataInputStream ih = this.fs_.open(p);
            FileStatus gattr = this.fs_.getFileStatus(p);
            max = gattr.getLen();
            long read = 0L;
            long pos = 0L;
            while (read < max) {
                int len = 65536;
                if (pos + (long)len > max) {
                    len = (int)(max - pos);
                }
                ih.read(pos, this.buf_, 0, len);
                read += (long)len;
                pos += (long)len;
            }
        }
        catch (IOException e) {
            System.out.println("Write Failed");
            System.exit(1);
        }
    }

    private void PureMap() {
        String dir = new String(this.topDir_);
        for (int j = 0; j < 100; ++j) {
            String baseDir = dir + "/dir" + j;
            for (int i = 0; i < 100; ++i) {
                String file = baseDir + "/file_" + i;
                Path p = new Path(file);
                try {
                    FSDataOutputStream fhOut = this.fs_.create(p);
                    fhOut.write(this.buf_, 0, 0x200000);
                    fhOut.write(this.buf_, 0, 0x200000);
                    fhOut.close();
                    continue;
                }
                catch (IOException e) {
                    System.out.println("Write Failed");
                    System.exit(1);
                }
            }
        }
    }

    private void LoadMap() {
        String dir = new String(this.topDir_);
        String file = dir + "/bgFile";
        Path p = new Path(file);
        try {
            FSDataOutputStream fhOut = this.fs_.create(p);
            for (int i = 0; i < 2000; ++i) {
                fhOut.write(this.buf_, 0, 0x200000);
                fhOut.write(this.buf_, 0, 0x200000);
            }
            fhOut.close();
        }
        catch (IOException e) {
            System.out.println("Write Failed");
            System.exit(1);
        }
    }

    private void RunMap() {
        String dir = new String(this.topDir_);
        String file = dir + "/bgFile";
        int smallFileWriteSz = 0x400000;
        int readBufSz = 0x10000000;
        long bgFileSize = 4L;
        bgFileSize = bgFileSize * 1024L * 1024L * 1024L;
        try {
            byte[] readBuf = new byte[readBufSz];
            Path rf = new Path(file);
            System.out.println("Alloced Read");
            FSDataInputStream ih = this.fs_.open(rf);
            long sT = System.currentTimeMillis();
            for (long i = 0L; i < bgFileSize / (long)readBufSz; ++i) {
                long off = 0L;
                int smallReadSize = 65536;
                for (int readBytes = 0; readBytes < readBufSz; readBytes += smallReadSize) {
                    off = i * (long)readBufSz + (long)readBytes;
                    ih.read(off, readBuf, readBytes, smallReadSize);
                }
                String baseDir = dir + "/dir" + i;
                for (int j = 0; j < readBufSz && this.runMapWriteOff_ == 0L; j += smallFileWriteSz) {
                    String wfile = baseDir + "/file_" + j;
                    Path p = new Path(wfile);
                    FSDataOutputStream fhOut = this.fs_.create(p);
                    fhOut.write(readBuf, j, smallFileWriteSz);
                    fhOut.close();
                }
            }
            long eT = System.currentTimeMillis();
            eT -= sT;
            double rate = bgFileSize;
            if (this.runMapWriteOff_ == 0L) {
                rate *= 2.0;
            }
            rate *= 1000.0;
            System.out.println("IO: " + (rate /= (double)eT) + " bytes/s" + rate / 1000000.0 + "MB/sec");
        }
        catch (IOException e) {
            System.out.println("RunMap failed");
            System.exit(1);
        }
    }

    private void DoStreamingWrite() {
        String file = new String(this.topDir_);
        Path p = new Path(file);
        boolean nocompress = false;
        if (this.seed_ % 2L == 0L) {
            nocompress = true;
        }
        for (int i = 0; i < 0x200000 && nocompress; i += 4) {
            long rand = this.rand_.nextLong();
            if (rand < 0L) {
                rand = -rand;
            }
            int data = (int)rand;
            this.buf_[i + 0] = (byte)(data >> 24);
            this.buf_[i + 1] = (byte)(data << 8 >> 24);
            this.buf_[i + 2] = (byte)(data << 16 >> 24);
            this.buf_[i + 3] = (byte)(data << 24 >> 24);
        }
        try {
            FSDataOutputStream fhOut = this.fs_.create(p);
            long max = 8000L;
            for (long wrote = 0L; wrote < max; ++wrote) {
                fhOut.write(this.buf_, 0, 0x200000);
                fhOut.sync();
            }
        }
        catch (IOException e) {
            System.out.println("Write Failed");
            System.exit(1);
        }
    }

    private void Mkdir() {
        int idx = this.PickFileOrDir(true);
        String path = this.dirs_[idx].name;
        String dir = path + "/dir_" + this.dslot_;
        this.dirs_[this.dslot_] = new Vnode(dir);
        if (!this.SkipOp()) {
            Path p = new Path(this.dirs_[this.dslot_].name);
            try {
                this.fs_.mkdirs(p);
            }
            catch (IOException e) {
                System.out.println("Mkdir failed: " + this.dirs_[this.dslot_].name);
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("MD: " + this.dirs_[this.dslot_].name);
        }
        this.dirs_[this.dslot_].data = null;
        this.dirs_[this.dslot_].size = 0L;
        this.dirs_[this.dslot_].removed = false;
        this.dirs_[this.dslot_].parent = idx;
        if (this.dslot_ + 1 >= this.dslotMax_) {
            int dslotMaxNew = this.dslotMax_ * 2;
            Vnode[] dirsNew = new Vnode[dslotMaxNew];
            for (int i = 0; i < this.dslotMax_; ++i) {
                dirsNew[i] = new Vnode(this.dirs_[i]);
            }
            this.dslotMax_ = dslotMaxNew;
            this.dirs_ = dirsNew;
        }
        ++this.ndirs_;
        ++this.dslot_;
    }

    private String PickDir() {
        boolean idx = false;
        long rand = this.GetRandom();
        String path = new String(this.topDir_);
        if (this.ndirs_ != 0 && this.GetRandom() % 1000L < 100L) {
            String dirPath = this.dirs_[this.dirCursor_ % this.ndirs_].name;
            ++this.dirCursor_;
            return dirPath;
        }
        return path;
    }

    boolean SkipOp() {
        return this.isListOps_ || this.isVerifyOps_;
    }

    private void Creat() {
        assert (this.nfiles_ >= 0);
        int idx = this.PickFileOrDir(true);
        String path = this.dirs_[idx].name;
        String fname = path + "/file_" + this.fslot_;
        this.files_[this.fslot_] = new Vnode(fname);
        if (!this.SkipOp()) {
            Path p = new Path(this.files_[this.fslot_].name);
            try {
                this.files_[this.fslot_].fhOut = this.fs_.create(p);
            }
            catch (IOException e) {
                System.out.println("create failed: " + this.files_[this.fslot_].name);
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("CR: " + this.files_[this.fslot_].name);
        }
        this.files_[this.fslot_].data = null;
        this.files_[this.fslot_].size = 0L;
        this.files_[this.fslot_].removed = false;
        this.files_[this.fslot_].parent = idx;
        if (this.fslot_ + 1 >= this.fslotMax_) {
            int fslotMaxNew = this.fslotMax_ * 2;
            Vnode[] filesNew = new Vnode[fslotMaxNew];
            for (int i = 0; i < this.fslotMax_; ++i) {
                filesNew[i] = new Vnode(this.files_[i]);
            }
            this.fslotMax_ = fslotMaxNew;
            this.files_ = filesNew;
        }
        ++this.fslot_;
        ++this.nfiles_;
    }

    private void Unlink() {
        int idx = this.PickWriteFile();
        Vnode vn = this.files_[idx];
        if (!this.SkipOp()) {
            try {
                Path p = new Path(vn.name);
                this.fs_.delete(p, false);
            }
            catch (IOException e) {
                System.out.println("Delete " + vn.name + " Failed");
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("Delete: " + vn.name);
        }
        vn.removed = true;
        if (vn.hasBaseXattr) {
            --this.nxattrs_;
        }
        if (vn.hasAce) {
            --this.naces_;
        }
        --this.nfiles_;
    }

    private int GetDataWord(Vnode vn, int data, int iterator) {
        if (this.seed_ % 3L == 0L) {
            return data;
        }
        if (this.seed_ % 3L == 1L) {
            long rand;
            if (vn.rand == null) {
                vn.rand = new Random(data);
            }
            if ((rand = vn.rand.nextLong()) < 0L) {
                rand = -rand;
            }
            int retdata = (int)rand % 7754802;
            if (data % 1 == 0) {
                data = retdata;
            }
            return data;
        }
        return data + iterator / 4;
    }

    private void Write() {
        int idx = this.PickWriteFile();
        WriteParams wp = new WriteParams();
        this.PickWriteParams(idx, wp);
        if (this.files_[idx].size < wp.off + wp.len) {
            this.files_[idx].size = wp.off + wp.len;
        }
        if (!this.SkipOp()) {
            long bufLen = wp.len > 0x200000L ? 0x200000L : wp.len;
            for (int i = 0; i < (int)bufLen; i += 4) {
                int data = this.GetDataWord(this.files_[idx], wp.data, i);
                this.buf_[i + 0] = (byte)(data >> 24);
                this.buf_[i + 1] = (byte)(data << 8 >> 24);
                this.buf_[i + 2] = (byte)(data << 16 >> 24);
                this.buf_[i + 3] = (byte)(data << 24 >> 24);
            }
            try {
                int lenToWrite;
                long len = wp.len;
                do {
                    lenToWrite = (int)len > 0x200000 ? 0x200000 : (int)len;
                    this.files_[idx].fhOut.write(this.buf_, 0, lenToWrite);
                    this.files_[idx].fhOut.sync();
                } while ((len -= (long)lenToWrite) > 0L);
            }
            catch (IOException e) {
                System.out.println(": " + this.files_[idx].name + "O=" + wp.off + " L=" + "Write Or Flush failed.");
                System.exit(1);
            }
        }
        this.AddDataFragToVnode(this.files_[idx], wp);
    }

    private int PickFileOrDir(boolean isDir) {
        if (!isDir) {
            return this.PickWriteFile();
        }
        int idx = 0;
        if (this.ndirs_ != 0 && this.GetRandom() % 1000L < 100L) {
            idx = this.dirCursor_;
            this.dirCursor_ = (this.dirCursor_ + 1) % this.dslot_;
        } else if (this.dirs_[idx] == null) {
            this.dirs_[idx] = new Vnode(this.topDir_);
        }
        return idx;
    }

    private int PickAceLen() {
        int l = (int)(this.GetRandom() % 4096L);
        if (l == 0) {
            l = 30;
        }
        return l;
    }

    private void GenerateAce(int aceLen) throws IOException {
        String aceBuf = new String("");
        MapRFileAce ace = new MapRFileAce(MapRFileAce.AccessType.WRITEFILE);
        if (aceLen == 30) {
            ace.setBooleanExpression("p");
            this.faces_.set(1, ace);
        } else {
            if (aceLen > 3968) {
                aceLen = 3968;
            }
            int numUsers = aceLen;
            numUsers += 8;
            numUsers /= 9;
            aceBuf = aceBuf.concat("g:0 | ");
            for (int i = 0; i < numUsers; ++i) {
                aceBuf = i < numUsers - 1 ? aceBuf.concat("u:" + i + " | ") : aceBuf.concat("u:" + i);
            }
            ace.setBooleanExpression(aceBuf);
            this.faces_.set(1, ace);
        }
    }

    int PickFileWithAce() {
        int i = 0;
        int slot = (int)(this.GetRandom() % (long)this.naces_);
        assert (this.naces_ > 0 && this.naces_ <= this.fslot_);
        for (i = 0; i < this.fslot_; ++i) {
            Vnode vn = this.files_[(slot + i) % this.fslot_];
            if (!vn.removed && vn.hasAce) break;
        }
        return (slot + i) % this.fslot_;
    }

    private void DelAce() {
        int slot = this.PickFileWithAce();
        Vnode vn = this.files_[slot];
        if (!this.SkipOp()) {
            try {
                ((MapRFileSystem)this.fs_).deleteAces(new Path(vn.name));
            }
            catch (Exception e) {
                System.out.println(vn.name + ": DelAce Failed, Error: " + e.getMessage());
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("DA: " + vn.name);
        }
        assert (!vn.removed);
        assert (vn.hasAce);
        vn.hasAce = false;
        assert (this.naces_ > 0);
        --this.naces_;
    }

    private void SetAce(boolean isDir) {
        Vnode vn = null;
        int slot = this.PickFileOrDir(isDir);
        vn = isDir ? this.dirs_[slot] : this.files_[slot];
        int len = this.PickAceLen();
        try {
            this.GenerateAce(len);
        }
        catch (IOException e) {
            System.out.println(vn.name + ": GenerateAce Failed, Error: " + e.getMessage());
            System.exit(1);
        }
        if (!this.SkipOp()) {
            try {
                ((MapRFileSystem)this.fs_).setAces(new Path(vn.name), this.faces_);
            }
            catch (Exception e) {
                System.out.println(vn.name + ": SetXAttr Failed, Error: " + e.getMessage());
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("SA: " + vn.name);
        }
        assert (!vn.removed);
        if (!vn.hasAce) {
            vn.hasAce = true;
            if (!isDir) {
                ++this.naces_;
            }
        }
    }

    int PickFileWithXAttr() {
        int i = 0;
        int slot = (int)(this.GetRandom() % (long)this.nxattrs_);
        assert (this.nxattrs_ > 0 && this.nxattrs_ <= this.fslot_);
        for (i = 0; i < this.fslot_; ++i) {
            Vnode vn = this.files_[(slot + i) % this.fslot_];
            if (!vn.removed && vn.hasBaseXattr) break;
        }
        return (slot + i) % this.fslot_;
    }

    private void RemoveXAttr() {
        int slot = this.PickFileWithXAttr();
        Vnode vn = this.files_[slot];
        String xName = vn.xName;
        if (!this.SkipOp()) {
            try {
                this.fs_.removeXAttr(new Path(vn.name), xName);
            }
            catch (Exception e) {
                System.out.println(vn.name + ": RemoveXAttr Failed for key: " + xName + ", Error: " + e.getMessage());
                System.exit(1);
            }
        }
        if (this.isListOps_) {
            System.out.println("RX: " + vn.name);
        }
        assert (!vn.removed);
        assert (vn.hasBaseXattr);
        vn.hasBaseXattr = false;
        assert (this.nxattrs_ > 0);
        --this.nxattrs_;
    }

    private void SetXAttr(boolean isDir) {
        String xVal;
        String xName;
        Vnode vn = null;
        int slot = this.PickFileOrDir(isDir);
        vn = isDir ? this.dirs_[slot] : this.files_[slot];
        if (vn.hasBaseXattr) {
            xName = String.format("user.fspeck_xattr_name_seed_%d_%d", this.seed_, slot);
            xVal = String.format("fspeck_xattr_value_seed_%d_%d %s", this.seed_, slot, vn.name);
            vn.hasXattr = true;
        } else {
            xName = String.format("user.fspeck_base_xattr_name_seed_%d_%d", this.seed_, vn.parent);
            xVal = String.format("fspeck_base_xattr_value_seed_%d_%d %s", this.seed_, slot, vn.name);
            vn.hasBaseXattr = true;
            if (!isDir) {
                ++this.nxattrs_;
            }
        }
        if (!this.SkipOp()) {
            try {
                this.fs_.setXAttr(new Path(vn.name), xName, xVal.getBytes());
            }
            catch (Exception e) {
                System.out.println(vn.name + ": SetXAttr Failed, Error: " + e.getMessage());
                System.exit(1);
            }
            vn.xName = new String(xName);
        }
        if (this.isListOps_) {
            System.out.println("SX: " + vn.name);
        }
        assert (!vn.removed);
    }

    private void SetXAttrsOnDirs() {
        int numDirsWithXAttrs = this.ndirs_ / 10;
        for (int i = 0; i < numDirsWithXAttrs; ++i) {
            this.SetXAttr(true);
        }
    }

    private void SetAcesOnDirs() {
        int numDirsWithAces = this.ndirs_ / 10;
        for (int i = 0; i < numDirsWithAces; ++i) {
            this.SetAce(true);
        }
    }

    private void AddDataFragToVnode(Vnode vn, WriteParams wp) {
        DataFrag tmpdf;
        DataFrag df = vn.data;
        DataFrag prevp = null;
        long eow = wp.off + wp.len;
        if (wp.len == 0L) {
            return;
        }
        while (df != null && df.off < eow) {
            if (df.eoff <= wp.off) {
                prevp = df;
                df = df.next;
                continue;
            }
            if (df.off >= wp.off && df.eoff <= eow) {
                DataFrag iter = df.next;
                if (prevp != null) {
                    prevp.next = df.next;
                } else {
                    vn.data = df.next;
                }
                df = iter;
                continue;
            }
            long tmp = df.eoff;
            if (df.off < wp.off) {
                df.eoff = wp.off;
            }
            if (tmp > eow) {
                tmpdf = new DataFrag();
                tmpdf.off = eow;
                tmpdf.eoff = tmp;
                tmpdf.data = df.data + (int)(eow - df.off) / 4;
                tmpdf.next = df.next;
                if (df.off > wp.off) {
                    if (prevp != null) {
                        prevp.next = tmpdf;
                    } else {
                        vn.data = tmpdf;
                    }
                    df = tmpdf;
                    continue;
                }
                tmpdf.next = df.next;
                df.next = tmpdf;
                prevp = df;
                df = tmpdf;
                continue;
            }
            prevp = df;
            df = df.next;
        }
        if (eow == Long.MAX_VALUE) {
            return;
        }
        prevp = null;
        df = vn.data;
        while (df != null && df.eoff <= wp.off) {
            prevp = df;
            df = df.next;
        }
        tmpdf = new DataFrag();
        tmpdf.off = wp.off;
        tmpdf.eoff = eow;
        tmpdf.data = wp.data;
        if (prevp != null) {
            tmpdf.next = prevp.next;
            prevp.next = tmpdf;
        } else {
            vn.data = tmpdf;
        }
    }

    private void Truncate() {
        System.out.println("Truncate");
    }

    public long GenerateOp() {
        int idx = -1;
        if (this.ndirs_ < 2 && this.opsDist_[0] != 0) {
            idx = 0;
        } else if (this.nfiles_ < 10 && this.opsDist_[1] != 0) {
            idx = 1;
        } else if (this.nfiles_ > 500 && this.opsDist_[2] != 0) {
            idx = 2;
        } else if (this.nxattrs_ < 2 && this.opsDist_[5] != 0) {
            idx = 5;
        } else if (this.naces_ < 2 && this.opsDist_[7] != 0) {
            idx = 7;
        } else if (this.nxattrs_ > 250 && this.opsDist_[6] != 0) {
            idx = 6;
        } else if (this.naces_ > 250 && this.opsDist_[8] != 0) {
            idx = 8;
        }
        if (idx != -1) {
            return this.opsCumulativeDist_[idx] - 1;
        }
        assert (this.nfiles_ != 0);
        long rand = this.rand_.nextLong();
        if (rand < 0L) {
            rand = -rand;
        }
        return rand %= (long)this.opsCumulativeDist_[9];
    }

    private int PickWriteFile() {
        long rand = this.rand_.nextLong();
        int slot = (int)(rand % (long)this.fslot_);
        int i = 0;
        if (slot < 0) {
            slot = -slot;
        }
        for (i = 0; i < this.fslot_ && this.files_[(slot + i) % this.fslot_].removed; ++i) {
        }
        assert (i != this.fslot_);
        return (slot + i) % this.fslot_;
    }

    private void PickWriteParams(int idx, WriteParams wp) {
        int i;
        Vnode vn = this.files_[idx];
        long rand = this.GetRandom();
        int distPoint = (int)(rand % (long)this.writeOpsCumulativeDist_[2]);
        for (i = 0; i < 3 && vn.size != 0L && distPoint >= this.writeOpsCumulativeDist_[i]; ++i) {
        }
        rand = this.GetRandom();
        wp.data = (int)(rand % 1193046L);
        if (wp.data == 0) {
            wp.data = 0xF2F2F2;
        }
        switch (i) {
            case 0: 
            case 1: {
                wp.off = vn.size;
                wp.len = this.GetRandom() % this.maxFileSize_;
                wp.len = wp.len >> 2 << 2;
                assert ((wp.off & 3L) == 0L);
                this.TrimLen(vn, wp);
                if (wp.len > 8192L && i == 1) {
                    wp.len &= 0x1FFFL;
                }
                if (!this.isListOps_) break;
                System.out.println("AW: " + vn.name + " off=" + wp.off + " len=" + wp.len + " data=" + Integer.toHexString(wp.data));
                break;
            }
            case 2: {
                wp.off = this.GetRandom() % vn.size;
                wp.off &= 3L;
                wp.len = this.GetRandom() % 0x200000L;
                wp.len = wp.len + 4L - 1L >> 2 << 2;
                this.TrimLen(vn, wp);
                if (!this.isListOps_) break;
                System.out.println("OW: " + vn.name + "off=" + wp.off + " len=" + wp.len + " data=" + wp.data);
            }
        }
    }

    private void TrimLen(Vnode vn, WriteParams wp) {
        if (this.isIgnoreMaxFileSize_) {
            return;
        }
        if (wp.off + wp.len > this.maxFileSize_) {
            wp.len = this.maxFileSize_ - wp.off;
        }
    }

    private long GetRandom() {
        long rand = this.rand_.nextLong();
        if (rand < 0L) {
            rand = -rand;
        }
        return rand;
    }

    private void VerifyDir() {
        for (int i = 0; i < this.dslot_; ++i) {
            Path p = new Path(this.dirs_[i].name);
            try {
                FileStatus info = this.fs_.getFileStatus(p);
                if (!this.dirs_[i].removed) continue;
                System.out.println("dir:" + this.dirs_[i].name + " not expected");
                System.exit(1);
                continue;
            }
            catch (IOException e) {
                if (this.dirs_[i].removed) continue;
                System.out.println("dirs:" + this.dirs_[i].name + "failed");
                System.exit(1);
            }
        }
    }

    private void VerifyFiles() {
        for (int i = 0; i < this.fslot_; ++i) {
            try {
                Path p = new Path(this.files_[i].name);
                FileStatus info = this.fs_.getFileStatus(p);
                if (!this.files_[i].removed) continue;
                System.out.println("file:" + this.files_[i].name + " not expected");
                System.exit(1);
                continue;
            }
            catch (IOException e) {
                if (this.files_[i].removed) continue;
                System.out.println("dirs:" + this.files_[i].name + "missing");
            }
        }
    }

    private void VerifyWrite() {
        for (int i = 0; i < this.fslot_; ++i) {
            if (this.files_[i].removed) continue;
            try {
                Path p = new Path(this.files_[i].name);
                FileStatus gattr = this.fs_.getFileStatus(p);
                if (gattr.getLen() != this.files_[i].size) {
                    System.out.println(this.files_[i].name + " Expected Size = " + this.files_[i].size + " Found = " + gattr.getLen());
                }
                if (gattr.getLen() == 0L) continue;
                long lastEof = 0L;
                Vnode vn = this.files_[i];
                FSDataInputStream ih = this.fs_.open(p);
                vn.rand = null;
                DataFrag df = vn.data;
                while (df != null) {
                    while (lastEof != df.off) {
                        long len = df.off - lastEof;
                        if (len > 0x200000L) {
                            len = 0x200000L;
                        }
                        ih.read(lastEof, this.buf_, 0, (int)len);
                        this.CheckData(vn, 0, lastEof, len);
                        lastEof += len;
                    }
                    ih.read(df.off, this.buf_, 0, (int)(df.eoff - df.off));
                    this.CheckData(vn, df.data, df.off, df.eoff - df.off);
                    lastEof = df.eoff;
                    df = df.next;
                }
                continue;
            }
            catch (IOException e) {
                System.out.println(this.files_[i].name + ": IOException found");
            }
        }
    }

    private void CheckData(Vnode vn, int expect, long off, long len) {
        byte[] nibble = new byte[4];
        for (int i = 0; i < (int)len; i += 4) {
            int data = expect;
            if (data != 0) {
                data = this.GetDataWord(vn, expect, i);
            }
            nibble[0] = (byte)(data >> 24);
            nibble[1] = (byte)(data << 8 >> 24);
            nibble[2] = (byte)(data << 16 >> 24);
            nibble[3] = (byte)(data << 24 >> 24);
            for (int j = 0; j < 4; ++j) {
                if (this.buf_[i + j] == nibble[j]) continue;
                System.out.println(vn.name + ": Mismatch: " + " Offset=" + (off + (long)i + (long)j) + " Expected:" + nibble[j] + " found=" + this.buf_[i + j]);
                return;
            }
        }
    }

    private void Verify() {
        if (this.isListOps_) {
            return;
        }
        this.VerifyDir();
        this.VerifyFiles();
        this.VerifyWrite();
    }
}

