/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class STest {
    public static void main(String[] args) throws Exception {
        byte[] buf = new byte[66560];
        int ac = 0;
        if (args.length != 1) {
            System.out.println("usage: dirtest pathname");
            return;
        }
        String uri = "maprfs:///";
        String dirname = args[ac++];
        Configuration conf = new Configuration();
        conf.set("fs.default.name", uri);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        while (true) {
            Path dirpath = new Path(dirname + "/dir");
            Path wfilepath = new Path(dirname + "/file.w");
            Path rfilepath = new Path(dirname + "/file.r");
            boolean res = fs.mkdirs(dirpath);
            if (!res) {
                System.out.println("mkdir failed, path: " + dirpath);
                return;
            }
            System.out.println("mkdir( " + dirpath + ") went ok, now writing file");
            FSDataOutputStream ostr = fs.create(wfilepath, true, 512, (short)1, 0x4000000L);
            ostr.write(buf);
            ostr.close();
            System.out.println("write( " + wfilepath + ") went ok");
            System.out.println("reading file: " + rfilepath);
            FSDataInputStream istr = fs.open(rfilepath);
            int bb = istr.readInt();
            istr.close();
            System.out.println("Read ok");
            System.out.println("hit enter to continue");
            int c = System.in.read();
        }
    }
}

