/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestRenameMany {
    static int nlevels = 4;
    static int entriesPerLevel = 25;
    static int numThreads = 64;
    static String rootDir = "renameMany";

    public static void populateDir(FileSystem fs, String parent, int nlevels) throws Exception {
        if (nlevels <= 0) {
            return;
        }
        for (int i = 0; i < entriesPerLevel; ++i) {
            String dname = parent + "/dir" + i;
            fs.mkdirs(new Path(dname));
            TestRenameMany.populateDir(fs, dname, nlevels - 1);
            String fname = parent + "/file" + i;
            fs.create(new Path(fname));
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("TestRenameMany");
        String uri = "maprfs:///";
        Configuration conf = new Configuration();
        conf.set("fs.default.name", uri);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        fs.mkdirs(new Path(rootDir));
        TestRenameMany.populateDir(fs, rootDir, nlevels);
        Random rand = new Random();
        Thread[] tid = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            tid[i] = new RenameThread(i, rand, fs);
            tid[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            tid[i].join();
        }
    }

    static class RenameThread
    extends Thread {
        FileSystem fs;
        Random rand;
        int myid;

        RenameThread(int id, Random r, FileSystem mfs) {
            this.myid = id;
            this.rand = r;
            this.fs = mfs;
        }

        public void RenameOne() {
            try {
                boolean isFile = false;
                if (this.rand.nextInt(2) == 0) {
                    isFile = true;
                }
                String src = rootDir;
                int slevel = this.rand.nextInt(nlevels);
                for (int i = 0; i < slevel; ++i) {
                    if (i == slevel - 1) {
                        if (isFile) {
                            src = src + "/dir" + this.rand.nextInt(entriesPerLevel);
                            continue;
                        }
                        src = src + "/file" + this.rand.nextInt(entriesPerLevel);
                        continue;
                    }
                    src = src + "/dir" + this.rand.nextInt(entriesPerLevel);
                }
                String dst = rootDir;
                int dlevel = this.rand.nextInt(nlevels);
                for (int i = 0; i < dlevel; ++i) {
                    dst = dst + "/dir" + this.rand.nextInt(entriesPerLevel);
                }
                System.out.println("id" + this.myid + ": rename " + src + " -> " + dst);
                this.fs.rename(new Path(src), new Path(dst));
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.RenameOne();
            }
        }
    }
}

