/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.resourcemanager;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.hadoop.yarn.util.YarnAppUtil;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class MapRTicketGenerator {
    private static final Log LOG = LogFactory.getLog(MapRTicketGenerator.class);

    public void generateToken(ApplicationSubmissionContext appCtx, String username, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        ApplicationId appId = appCtx.getApplicationId();
        try {
            this.generateMapRLoginTicket(appId, username, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeToken(ApplicationId appId, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path path = YarnAppUtil.getRMSystemDir(appId.toString(), fs, conf);
            fs.delete(path, true);
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Removed system ticket dir from MFS: " + path));
            }
            Path appStagingDir = YarnAppUtil.getRMStagingDir(appId.toString(), fs, conf);
            fs.delete(appStagingDir, true);
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Removed staging ticket dir from MFS: " + path));
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    private void generateMapRLoginTicket(ApplicationId appId, String username, Configuration conf) throws IOException {
        String appIdStr = appId.toString();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path appStagingDir = YarnAppUtil.getRMStagingDir(appIdStr, fs, conf);
        Path existingTicketPath = YarnAppUtil.getMapRTicketPath(appStagingDir);
        boolean isExistingTicketExpired = false;
        FSDataInputStream fsin = null;
        if (fs.isFile(existingTicketPath)) {
            fsin = fs.open(existingTicketPath);
        }
        if (fsin != null) {
            try {
                MutableInt err = new MutableInt();
                String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                Security.TicketAndKey ticketKey = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)currentClusterName, (MutableInt)err);
                if (!Security.IsTicketAndKeyUsable((Security.TicketAndKey)ticketKey)) {
                    fsin.close();
                    fsin = null;
                    isExistingTicketExpired = true;
                    LOG.debug((Object)("Existing ticket " + existingTicketPath + " has expired. Closing input stream"));
                }
            }
            catch (Throwable t) {
                throw new IOException("Getting expiry time for existing security ticket for app: " + appId + " and user: " + username + " failed", t);
            }
        }
        Path appSystemDir = YarnAppUtil.getRMSystemDir(appIdStr, fs, conf);
        FileSystem.mkdirs((FileSystem)fs, (Path)appSystemDir, (FsPermission)YarnAppUtil.APP_DIR_PERMISSION);
        Path ticketPath = YarnAppUtil.getMapRTicketPath(appSystemDir);
        FSDataOutputStream outTicket = FileSystem.create((FileSystem)fs, (Path)ticketPath, (FsPermission)new FsPermission(YarnAppUtil.APP_FILE_PERMISSION));
        long expiration = System.currentTimeMillis() + Long.parseLong(conf.get("yarn.mapr.ticket.expiration"));
        try {
            block20: {
                if (fsin != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Cloning MapR ticket for app: " + appId + " user: " + username + " at " + ticketPath));
                    }
                    try {
                        Security.CloneAndGenerateTicketFile((DataInputStream)fsin, (long)expiration, (DataOutputStream)outTicket);
                    }
                    catch (IOException e) {
                        String errMsg = e.getMessage();
                        if (errMsg != null && errMsg.contains("62")) {
                            fsin.close();
                            fsin = null;
                            isExistingTicketExpired = true;
                        }
                        if (isExistingTicketExpired) break block20;
                        throw new IOException(e);
                    }
                }
            }
            if (fsin == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Generating MapR ticket for app: " + appId + " user: " + username + " at " + ticketPath));
                }
                Security.MergeAndGenerateTicketFile((DataInputStream)fsin, (String)username, (long)expiration, (DataOutputStream)outTicket);
                if (isExistingTicketExpired) {
                    LOG.debug((Object)("Deleting existing expired ticket: " + existingTicketPath));
                    fs.delete(existingTicketPath, true);
                }
            }
        }
        catch (Throwable t) {
            throw new IOException("Security Ticket for app: " + appId + " and user: " + username + " failed", t);
        }
        finally {
            if (fsin != null) {
                fsin.close();
            }
            outTicket.close();
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Retained staged ticket dir from MFS: " + appStagingDir));
            }
        }
    }
}

