/**
 * 
 */
package org.apache.hadoop.yarn.client;

import static org.junit.Assert.*;

import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.mapr.fs.proto.Common.ServiceData;

/**
 *
 */
public class MapRZKRMFinderUtilsTest {

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void MapRZKRMFinderUtilstest() throws Exception {
		ServiceData servicedata = null;
		ServiceData servicedataOther = null;
		try {
		  Configuration conf = new Configuration();
		  conf.set("fs.default.name", "file:///");
		  servicedata = MapRZKRMFinderUtils.mapRZkBasedRMFinder(conf, "resourcemanager");
		} catch (UnsupportedOperationException e) {
			fail("should you maprfs implementation");
		} catch (RuntimeException ex) {
			// OK - may be ZK address is null, as it is UnitTest	
		}
		
		try {
		  Configuration confOther = new Configuration();
		  confOther.set("fs.default.name", "maprfs:///");
		  servicedataOther = MapRZKRMFinderUtils.mapRZkBasedRMFinder(confOther, "resourcemanager");
		} catch (UnsupportedOperationException e) {
			fail("should you maprfs implementation");
		} catch (RuntimeException ex) {
			// OK - may be ZK address is null, as it is UnitTest
		}

		if (servicedata != null &&  servicedataOther != null) {
		  assertTrue(servicedata.equals(servicedataOther));
		}
	}

}
