package com.mapr.hadoop.yarn.configuration;

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.junit.Test;

public class TemplateEscapingTest {

  @Test
  public void templateEscapingTest() throws Exception {
    boolean isHAEnabled = false;
    // testing non-existing file
    String newYarnSiteXml = new YarnSiteMyriadXmlBuilder("myriadeng.marathon.mesos",
        "yarn-site.xml", isHAEnabled).build();

    assertTrue(newYarnSiteXml.contains("${myriad.yarn.nodemanager.webapp.address}"));
    assertFalse(newYarnSiteXml.contains("\\$\\{myriad.yarn.nodemanager.webapp.address\\}"));

    // testing existing file
    InputStream haTemplateStream = Thread.currentThread()
        .getContextClassLoader()
        .getResourceAsStream("yarn-site-test.xml");

    if ( haTemplateStream == null ) {
      fail("Can not find test resource file: yarn-site-test.xml");
    }
    File tempFile = File.createTempFile("test-yarn-xml", null);
    tempFile.deleteOnExit();
    OutputStream ostr = new FileOutputStream(tempFile);
    try {
      byte[] buf = new byte[1024];
      int readBytes;
      while ( (readBytes = haTemplateStream.read(buf, 0, buf.length)) > 0) {
        ostr.write(buf, 0, readBytes);
      }
    } finally {
      ostr.close();
      haTemplateStream.close();
    }

    newYarnSiteXml = new YarnSiteMyriadXmlBuilder("myriadeng.marathon.mesos", 
        tempFile.getAbsolutePath(), isHAEnabled).build();

    assertTrue(newYarnSiteXml.contains("${myriad.yarn.nodemanager.webapp.address}"));
    assertFalse(newYarnSiteXml.contains("\\$\\{myriad.yarn.nodemanager.webapp.address\\}"));
    // spaces sensitive
    assertTrue(newYarnSiteXml.contains("<property>\n    <name>my.property</name>\n    <value>my.property.value</value>\n  </property>"));
  }
}
