/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import com.mapr.fs.proto.Common;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.UserGroupInformation;

public class MapRZKRMFinderUtils {
    private static final Log LOG = LogFactory.getLog(MapRZKRMFinderUtils.class);
    private static final Map<String, ZKDataRetrieval> zkConnectionMap = new HashMap<String, ZKDataRetrieval>();
    public static final Map<String, String> propertyMapping = new HashMap<String, String>();
    private static volatile String backupZKAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Common.ServiceData mapRZkBasedRMFinder(Configuration conf, String serviceName) {
        Class<MapRZKRMFinderUtils> e2;
        Object scheme;
        String zkAddress = null;
        if (conf == null) {
            LOG.error((Object)"Can not get RM address since passed config object is null");
            throw new RuntimeException("Can not get RM address since passed config object is null");
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            scheme = fs.getScheme();
            if (!"maprfs".equals(scheme)) {
                MapRZKRMFinderUtils.logH("FileSystem object is not maprfs, but: " + (String)scheme + " trying to getZkConnectString from MapRFileSystem impl");
                Configuration other = new Configuration(conf);
                other.set("fs.default.name", "maprfs:///");
                fs = FileSystem.get((Configuration)other);
            }
            zkAddress = fs.getZkConnectString();
        }
        catch (IOException e2) {
            MapRZKRMFinderUtils.logH("Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml" + e2);
        }
        if (zkAddress == null) {
            MapRZKRMFinderUtils.logH("Zookeeper address not found from MapRFilesystem. Will try the configuration from yarn-site.xml");
        }
        if (zkAddress == null) {
            MapRZKRMFinderUtils.logH("Zookeeper address can not be retrieved. Trying backup zk address");
            e2 = MapRZKRMFinderUtils.class;
            // MONITORENTER : org.apache.hadoop.yarn.client.MapRZKRMFinderUtils.class
            zkAddress = backupZKAddress;
            // MONITOREXIT : e2
        }
        if (zkAddress == null) {
            LOG.error((Object)"Zookeeper address not configured in Yarn configuration. Please check yarn-site.xml.");
            LOG.error((Object)"Unable to determine ResourceManager service address from Zookeeper.");
            throw new RuntimeException("Zookeeper address not found from MapR Filesystem and is also not configured in Yarn configuration.");
        }
        e2 = MapRZKRMFinderUtils.class;
        // MONITORENTER : org.apache.hadoop.yarn.client.MapRZKRMFinderUtils.class
        backupZKAddress = zkAddress;
        // MONITOREXIT : e2
        scheme = zkConnectionMap;
        // MONITORENTER : scheme
        ZKDataRetrieval zkConnection = zkConnectionMap.get(zkAddress);
        if (zkConnection == null) {
            zkConnection = new ZKDataRetrieval(zkAddress);
            zkConnectionMap.put(zkAddress, zkConnection);
        }
        // MONITOREXIT : scheme
        Common.ServiceData hostInfo = zkConnection.getServiceMasterData(serviceName);
        if (hostInfo != null) return hostInfo;
        LOG.error((Object)("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress));
        throw new RuntimeException("Unable to determine ResourceManager service address from Zookeeper at " + zkAddress);
    }

    private static void logH(String logString) {
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.error((Object)logString);
        } else {
            LOG.debug((Object)logString);
        }
    }

    static {
        propertyMapping.put("SCHEDULER_PORT", "yarn.resourcemanager.scheduler.address");
        propertyMapping.put("WEBAPP_PORT", "yarn.resourcemanager.webapp.address");
        propertyMapping.put("WEBAPP_HTTPS_PORT", "yarn.resourcemanager.webapp.https.address");
        propertyMapping.put("RESOURCETRACKER_PORT", "yarn.resourcemanager.resource-tracker.address");
        propertyMapping.put("ADMIN_PORT", "yarn.resourcemanager.admin.address");
    }
}

