/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.mapred;

import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsDataOutputStream;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.hadoop.mapred.LocalVolumeAuxService;
import com.mapr.hadoop.mapred.MapRDirectShuffleMetaData;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class LocalVolumeAuxServiceTest {
    private static final String TEST_HOST_NAME = "testhost";
    private static final String ROOT_FID = "2068.32.131304";
    private static final String ROOT_FID_ALT = "2070.32.131304";
    private static final String OUTPUT_FID = "2068.34.131308";
    private static final String OUTPUT_U_FID = "2068.36.131312";
    private static final String SPILL_FID = "2068.33.131306";
    private static final String SPILL_U_FID = "2068.35.131310";
    private static final String OUTPUT_FID_JOB = "2068.34.131309";
    private static final String OUTPUT_U_FID_JOB = "2068.36.131313";
    private static final String SPILL_FID_JOB = "2068.33.131307";
    private static final String SPILL_U_FID_JOB = "2068.35.131311";
    private static final Log LOG;
    private LocalVolumeAuxService lvService;
    private MapRFileSystem fs;
    private MapRFsDataOutputStream fileId;
    private Configuration conf;

    @Test
    public void testGetMapRedLocalVolumeMountPath() throws Exception {
        LocalVolumeAuxService service = new LocalVolumeAuxService();
        service.serviceInit(new Configuration());
        Assert.assertEquals((Object)"/var/mapr/local/testhost/mapred", (Object)service.getMapRedLocalVolumeMountPath());
    }

    @Before
    public void setup() throws Exception {
        this.lvService = new LocalVolumeAuxService();
        this.fs = (MapRFileSystem)Mockito.mock(MapRFileSystem.class);
        this.fileId = (MapRFsDataOutputStream)Mockito.mock(MapRFsDataOutputStream.class);
        Mockito.when((Object)this.fileId.getFidServers()).thenReturn((Object)new long[]{123L, 456L, 789L});
        Mockito.when((Object)this.fileId.getFidStr()).thenReturn((Object)ROOT_FID);
        Mockito.when((Object)this.fs.mkdirsFid(new Path("/var/mapr/local/" + BaseUtilsHelper.getMapRHostName() + "/mapred/nodeManager"))).thenReturn((Object)ROOT_FID);
        Mockito.when((Object)this.fs.mkdirsFid(ROOT_FID, "output")).thenReturn((Object)OUTPUT_FID);
        Mockito.when((Object)this.fs.mkdirsFid(ROOT_FID, "output.U")).thenReturn((Object)OUTPUT_U_FID);
        Mockito.when((Object)this.fs.mkdirsFid(ROOT_FID, "spill")).thenReturn((Object)SPILL_FID);
        Mockito.when((Object)this.fs.mkdirsFid(ROOT_FID, "spill.U")).thenReturn((Object)SPILL_U_FID);
        Mockito.when((Object)this.fs.createFid(ROOT_FID, "fidservers")).thenReturn((Object)this.fileId);
        Mockito.when((Object)this.fs.getFileStatus(new Path("/var/mapr/local/" + BaseUtilsHelper.getMapRHostName() + "/mapred"))).thenReturn(null);
        Mockito.when((Object)this.fs.getFileStatus(new Path("/var/mapr/local/" + BaseUtilsHelper.getMapRHostName() + "/mapred/nodeManager"))).thenReturn(null);
        this.lvService.setFS((FileSystem)this.fs);
        this.conf = new Configuration();
        this.conf.set("mapr.mapred.localvolume.root.dir.name", "nodeManager");
        this.lvService.setConf(this.conf);
    }

    @After
    public void shutDown() throws Exception {
        this.lvService = null;
        Mockito.reset((Object[])new MapRFileSystem[]{this.fs});
    }

    @Test(timeout=10000L)
    public void testInitMapReduceDirsWithException() throws Exception {
        Mockito.when((Object)this.fs.createFid(ROOT_FID, "fidservers")).thenThrow(new Throwable[]{new IOExceptionWithErrorCode("IOExceptionWithErrorCode", 13)});
        try {
            this.lvService.initMapReduceDirs();
            Assert.fail((String)"Should throw exception");
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                if (!"IOExceptionWithErrorCode".equalsIgnoreCase(t.getMessage())) {
                    Assert.fail((String)"Unexpected exception is thrown");
                }
            }
            Assert.fail((String)"Unexpected exception is thrown");
        }
    }

    @Test(timeout=10000L)
    public void testInitMapReduceDirs() throws Exception {
        this.lvService.serviceInit(this.conf);
        this.lvService.initMapReduceDirs();
        MapRDirectShuffleMetaData metadata = this.lvService.metaData;
        Map data = metadata.getMapReduceDirsPathIds();
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)5L, (long)data.size());
        PathId root = (PathId)data.get(".");
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)ROOT_FID, (Object)root.getFid());
    }

    @Test(timeout=10000L)
    public void testInitApplication() throws Exception {
        try {
            this.lvService.serviceInit(this.conf);
            this.lvService.initMapReduceDirs();
        }
        catch (Throwable t) {
            Assert.fail((String)"Should not throw");
        }
        long appTimestamp = System.currentTimeMillis();
        ApplicationId appId = ApplicationId.newInstance((long)appTimestamp, (int)12345);
        ApplicationInitializationContext appContext = new ApplicationInitializationContext("myuser", appId, null);
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        String jobIdStr = jobId.toString();
        Mockito.when((Object)this.fs.mkdirsFid(OUTPUT_FID, jobIdStr)).thenReturn((Object)OUTPUT_FID_JOB);
        Mockito.when((Object)this.fs.mkdirsFid(OUTPUT_U_FID, jobIdStr)).thenReturn((Object)OUTPUT_U_FID_JOB);
        Mockito.when((Object)this.fs.mkdirsFid(SPILL_FID, jobIdStr)).thenReturn((Object)SPILL_FID_JOB);
        Mockito.when((Object)this.fs.mkdirsFid(SPILL_U_FID, jobIdStr)).thenReturn((Object)SPILL_U_FID_JOB);
        ((MapRFileSystem)Mockito.doNothing().when((Object)this.fs)).setOwnerFid(OUTPUT_FID_JOB, "myuser", "myuser");
        ((MapRFileSystem)Mockito.doNothing().when((Object)this.fs)).setOwnerFid(OUTPUT_U_FID_JOB, "myuser", "myuser");
        ((MapRFileSystem)Mockito.doNothing().when((Object)this.fs)).setOwnerFid(SPILL_FID_JOB, "myuser", "myuser");
        ((MapRFileSystem)Mockito.doNothing().when((Object)this.fs)).setOwnerFid(SPILL_U_FID_JOB, "myuser", "myuser");
        this.lvService.initializeApplication(appContext);
        MapRDirectShuffleMetaData data = (MapRDirectShuffleMetaData)this.lvService.jobMetaData.get(jobIdStr);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((long)5L, (long)data.getMapReduceDirsPathIds().size());
        PathId root = (PathId)data.getMapReduceDirsPathIds().get(".");
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)ROOT_FID, (Object)root.getFid());
        PathId output = (PathId)data.getMapReduceDirsPathIds().get("output");
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((Object)OUTPUT_FID_JOB, (Object)output.getFid());
    }

    @Test(timeout=30000L)
    public void testLockingOnVolumeReInitNoException() throws Exception {
        final int[] switchFlag = new int[]{0};
        this.lvService.serviceInit(this.conf);
        Mockito.when((Object)this.fs.createFid(ROOT_FID_ALT, "fidservers")).thenAnswer((Answer)new Answer<MapRFsDataOutputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MapRFsDataOutputStream answer(InvocationOnMock invocation) throws Throwable {
                int[] nArray = switchFlag;
                synchronized (switchFlag) {
                    switchFlag[0] = 1;
                    switchFlag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    Thread.sleep(6000L);
                    nArray = switchFlag;
                    synchronized (switchFlag) {
                        switchFlag[0] = 2;
                        switchFlag.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return LocalVolumeAuxServiceTest.this.fileId;
                    }
                }
            }
        });
        final Throwable[] internalT = new Throwable[2];
        Thread maprDirsInit = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(new Path("/var/mapr/local/" + BaseUtilsHelper.getMapRHostName() + "/mapred/nodeManager"))).thenReturn((Object)LocalVolumeAuxServiceTest.ROOT_FID_ALT);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "output")).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "output.U")).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_U_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "spill")).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "spill.U")).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_U_FID);
                    LocalVolumeAuxServiceTest.this.lvService.initMapReduceDirs();
                }
                catch (Throwable t) {
                    LOG.error((Object)t.getMessage(), t);
                    internalT[0] = t;
                    Assert.fail((String)("Should not throw: " + t.getMessage()));
                }
            }
        });
        Thread initApp = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long appTimestamp = System.currentTimeMillis();
                ApplicationId appId = ApplicationId.newInstance((long)appTimestamp, (int)12345);
                ApplicationInitializationContext appContext = new ApplicationInitializationContext("myuser", appId, null);
                JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
                String jobIdStr = jobId.toString();
                try {
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.OUTPUT_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.OUTPUT_U_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_U_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.SPILL_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.SPILL_U_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_U_FID_JOB);
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.OUTPUT_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.OUTPUT_U_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.SPILL_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.SPILL_U_FID_JOB, "myuser", "myuser");
                    int[] nArray = switchFlag;
                    synchronized (switchFlag) {
                        while (switchFlag[0] == 0) {
                            try {
                                switchFlag.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        Assert.assertEquals((long)1L, (long)switchFlag[0]);
                        // ** MonitorExit[var7_6] (shouldn't be in output)
                        long time = System.currentTimeMillis();
                        LocalVolumeAuxServiceTest.this.lvService.initializeApplication(appContext);
                        long timeDiff = System.currentTimeMillis() - time;
                        LOG.info((Object)("TimeDiff: " + timeDiff));
                        Assert.assertTrue((timeDiff > 4000L ? 1 : 0) != 0);
                        MapRDirectShuffleMetaData data = (MapRDirectShuffleMetaData)((LocalVolumeAuxServiceTest)LocalVolumeAuxServiceTest.this).lvService.jobMetaData.get(jobIdStr);
                        Assert.assertNotNull((Object)data);
                        Assert.assertEquals((long)5L, (long)data.getMapReduceDirsPathIds().size());
                        LOG.info((Object)data.getMapReduceDirsPathIds());
                        PathId root = (PathId)data.getMapReduceDirsPathIds().get(".");
                        Assert.assertNotNull((Object)root);
                        Assert.assertEquals((Object)LocalVolumeAuxServiceTest.ROOT_FID_ALT, (Object)root.getFid());
                        PathId output = (PathId)data.getMapReduceDirsPathIds().get("output");
                        Assert.assertNotNull((Object)output);
                        Assert.assertEquals((Object)LocalVolumeAuxServiceTest.OUTPUT_FID_JOB, (Object)output.getFid());
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)t.getMessage(), t);
                    internalT[1] = t;
                    Assert.fail((String)("Should not throw" + t.getMessage()));
                }
            }
        });
        maprDirsInit.setDaemon(true);
        initApp.setDaemon(true);
        maprDirsInit.start();
        Thread.sleep(1000L);
        initApp.start();
        maprDirsInit.join();
        initApp.join();
        if (internalT[0] != null) {
            Assert.fail((String)("Exception Was thrown: " + internalT[0].getMessage()));
        }
        if (internalT[1] != null) {
            Assert.fail((String)("Exception Was thrown: " + internalT[1].getMessage()));
        }
    }

    @Test(timeout=30000L)
    public void testLockingOnVolumeReInitWithException() throws Exception {
        this.testInitMapReduceDirs();
        final int[] switchFlag = new int[]{0};
        this.lvService.serviceInit(this.conf);
        Mockito.when((Object)this.fs.createFid(ROOT_FID_ALT, "fidservers")).thenAnswer((Answer)new Answer<MapRFsDataOutputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MapRFsDataOutputStream answer(InvocationOnMock invocation) throws Throwable {
                int[] nArray = switchFlag;
                synchronized (switchFlag) {
                    switchFlag[0] = 1;
                    switchFlag.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    Thread.sleep(6000L);
                    nArray = switchFlag;
                    synchronized (switchFlag) {
                        switchFlag[0] = 2;
                        switchFlag.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        throw new IOExceptionWithErrorCode("IOExceptionWithErrorCode", 13);
                    }
                }
            }
        });
        final Throwable[] internalT = new Throwable[2];
        Thread maprDirsInit = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(new Path("/var/mapr/local/" + BaseUtilsHelper.getMapRHostName() + "/mapred/nodeManager"))).thenReturn((Object)LocalVolumeAuxServiceTest.ROOT_FID_ALT);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "output")).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "output.U")).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_U_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "spill")).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_FID);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.ROOT_FID_ALT, "spill.U")).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_U_FID);
                    LocalVolumeAuxServiceTest.this.lvService.initMapReduceDirs();
                    Assert.fail((String)"Should not succeed");
                }
                catch (Throwable t) {
                    if (t instanceof IOException) {
                        if (!"IOExceptionWithErrorCode".equalsIgnoreCase(t.getMessage())) {
                            internalT[0] = t;
                            LOG.error((Object)t.getMessage(), t);
                            Assert.fail((String)"Unexpected exception is thrown");
                        }
                    }
                    internalT[0] = t;
                    LOG.error((Object)t.getMessage(), t);
                    Assert.fail((String)"Unexpected exception is thrown");
                }
            }
        });
        Thread initApp = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long appTimestamp = System.currentTimeMillis();
                ApplicationId appId = ApplicationId.newInstance((long)appTimestamp, (int)12345);
                ApplicationInitializationContext appContext = new ApplicationInitializationContext("myuser", appId, null);
                JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
                String jobIdStr = jobId.toString();
                try {
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.OUTPUT_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.OUTPUT_U_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.OUTPUT_U_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.SPILL_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_FID_JOB);
                    Mockito.when((Object)LocalVolumeAuxServiceTest.this.fs.mkdirsFid(LocalVolumeAuxServiceTest.SPILL_U_FID, jobIdStr)).thenReturn((Object)LocalVolumeAuxServiceTest.SPILL_U_FID_JOB);
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.OUTPUT_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.OUTPUT_U_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.SPILL_FID_JOB, "myuser", "myuser");
                    ((MapRFileSystem)Mockito.doNothing().when((Object)LocalVolumeAuxServiceTest.this.fs)).setOwnerFid(LocalVolumeAuxServiceTest.SPILL_U_FID_JOB, "myuser", "myuser");
                    int[] nArray = switchFlag;
                    synchronized (switchFlag) {
                        while (switchFlag[0] == 0) {
                            try {
                                switchFlag.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        Assert.assertEquals((long)1L, (long)switchFlag[0]);
                        // ** MonitorExit[var7_6] (shouldn't be in output)
                        long time = System.currentTimeMillis();
                        LocalVolumeAuxServiceTest.this.lvService.initializeApplication(appContext);
                        long timeDiff = System.currentTimeMillis() - time;
                        LOG.info((Object)("TimeDiff: " + timeDiff));
                        Assert.assertTrue((timeDiff > 4000L ? 1 : 0) != 0);
                        MapRDirectShuffleMetaData data = (MapRDirectShuffleMetaData)((LocalVolumeAuxServiceTest)LocalVolumeAuxServiceTest.this).lvService.jobMetaData.get(jobIdStr);
                        Assert.assertNotNull((Object)data);
                        Assert.assertEquals((long)5L, (long)data.getMapReduceDirsPathIds().size());
                        LOG.info((Object)data.getMapReduceDirsPathIds());
                        PathId root = (PathId)data.getMapReduceDirsPathIds().get(".");
                        Assert.assertNotNull((Object)root);
                        Assert.assertEquals((Object)LocalVolumeAuxServiceTest.ROOT_FID, (Object)root.getFid());
                        PathId output = (PathId)data.getMapReduceDirsPathIds().get("output");
                        Assert.assertNotNull((Object)output);
                        Assert.assertEquals((Object)LocalVolumeAuxServiceTest.OUTPUT_FID_JOB, (Object)output.getFid());
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)t.getMessage(), t);
                    internalT[1] = t;
                    Assert.fail((String)("Should not throw" + t.getMessage()));
                }
            }
        });
        maprDirsInit.setDaemon(true);
        initApp.setDaemon(true);
        maprDirsInit.start();
        Thread.sleep(1000L);
        initApp.start();
        maprDirsInit.join();
        initApp.join();
        if (internalT[0] != null) {
            Assert.fail((String)("Exception Was thrown: " + internalT[0].getMessage()));
        }
        if (internalT[1] != null) {
            Assert.fail((String)("Exception Was thrown: " + internalT[1].getMessage()));
        }
    }

    static {
        BaseUtilsHelper.setMapRHostName((String)TEST_HOST_NAME);
        LOG = LogFactory.getLog(LocalVolumeAuxServiceTest.class);
    }
}

