/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.resourcemanager;

import com.mapr.hadoop.yarn.util.YarnAppUtil;
import com.mapr.security.Security;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class MapRTicketGenerator {
    private static final Log LOG = LogFactory.getLog(MapRTicketGenerator.class);

    public void generateToken(ApplicationSubmissionContext appCtx, String username, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        ApplicationId appId = appCtx.getApplicationId();
        try {
            this.generateMapRLoginTicket(appId, username, conf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeToken(ApplicationId appId, Configuration conf) {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path path = YarnAppUtil.getRMSystemDir(appId.toString(), fs, conf);
            fs.delete(path, true);
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Removed system ticket dir from MFS: " + path));
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    private void generateMapRLoginTicket(ApplicationId appId, String username, Configuration conf) throws IOException {
        String appIdStr = appId.toString();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path appStagingDir = YarnAppUtil.getRMStagingDir(appIdStr, fs, conf);
        Path existingTicketPath = YarnAppUtil.getMapRTicketPath(appStagingDir);
        FSDataInputStream fsin = null;
        if (fs.isFile(existingTicketPath)) {
            fsin = fs.open(existingTicketPath);
        }
        Path appSystemDir = YarnAppUtil.getRMSystemDir(appIdStr, fs, conf);
        FileSystem.mkdirs((FileSystem)fs, (Path)appSystemDir, (FsPermission)YarnAppUtil.APP_DIR_PERMISSION);
        Path ticketPath = YarnAppUtil.getMapRTicketPath(appSystemDir);
        FSDataOutputStream outTicket = FileSystem.create((FileSystem)fs, (Path)ticketPath, (FsPermission)new FsPermission(YarnAppUtil.APP_FILE_PERMISSION));
        long expiration = System.currentTimeMillis() + Long.parseLong(conf.get("yarn.mapr.ticket.expiration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating MapR ticket for app: " + appId + " user: " + username + " at " + ticketPath));
        }
        try {
            Security.MergeAndGenerateTicketFile((DataInputStream)fsin, (String)username, (long)expiration, (DataOutputStream)outTicket);
        }
        catch (Throwable t) {
            throw new IOException("Security Ticket for app: " + appId + " and user: " + username + " failed", t);
        }
        finally {
            if (fsin != null) {
                fsin.close();
            }
            outTicket.close();
            fs.delete(appStagingDir, true);
            if (LOG.isDebugEnabled()) {
                LOG.error((Object)("Removed staged ticket dir from MFS: " + appStagingDir));
            }
        }
    }
}

