/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.fs.gateway.external.GatewaySink;
import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;

public class ExternalJsonRecordWriter
extends RecordWriter<ByteBufWritableComparable, Document> {
    private GatewaySink sink;
    private boolean isCompare = false;

    public ExternalJsonRecordWriter(GatewaySink sink, boolean isCompare) throws IOException {
        this.sink = sink;
        this.isCompare = isCompare;
    }

    public void close(TaskAttemptContext job) throws IOException {
        if (this.sink.CloseStream() != 0) {
            throw new IOException("Failed to close GatewaySink");
        }
    }

    public void write(ByteBufWritableComparable key, Document value) throws IOException {
        if (this.isCompare) {
            boolean compareRet = false;
            try {
                compareRet = this.sink.CompareStream(value);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Exception while comparing stream: " + e.getMessage());
            }
            if (!compareRet) {
                throw new IOException("Tables do not match");
            }
        } else if (this.sink.AppendStream(value) != 0) {
            throw new IOException("Failed to append to GatewaySink stream");
        }
    }
}

