/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.gateway.external.tools.ExternalJsonRecordWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalJsonOutputFormat
extends FileOutputFormat<ByteBufWritableComparable, Document>
implements Configurable {
    static final Logger LOG = LoggerFactory.getLogger(ExternalJsonOutputFormat.class);
    public static final String PROP_EXT_DST_TABLE = "maprdb.external.outputtable";
    public static final String PROP_IS_COMPARE = "maprdb.external.is_comapre";
    private Configuration conf;
    private GatewaySink sink;
    private boolean isCompare = false;

    ExternalJsonOutputFormat() {
    }

    public RecordWriter<ByteBufWritableComparable, Document> getRecordWriter(TaskAttemptContext job) throws IOException {
        return new ExternalJsonRecordWriter(this.sink, this.isCompare);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String dstTable = conf.get(PROP_EXT_DST_TABLE);
        this.sink = new GatewaySink();
        if (this.sink.OpenStream(dstTable, true) != 0) {
            LOG.error("Failed to open GatewaySink to " + dstTable);
            throw new RuntimeException("Failed to open GatewaySink to " + dstTable);
        }
        this.isCompare = conf.getBoolean(PROP_IS_COMPARE, false);
    }
}

