/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.gateway.external.tools.ExternalOutputFormat;
import com.mapr.fs.gateway.external.tools.ExternalTableMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.yaml.snakeyaml.Yaml;

public class CmpTablesExt
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(CmpTablesExt.class);
    private static final String EXT_ELASTICSEARCH = ".es";
    private static final String ES_REPLICAS = File.separator + "opt" + File.separator + "external" + File.separator + "elasticsearch" + File.separator + "replicas";
    private static final String ES_CONFIG_FILE = "config.es";
    static final String NAME = "CmpTablesExt";
    String srcTableName;
    String dstTableName;
    String columnSpec;
    int maxVersions = Integer.MAX_VALUE;
    long startTime = 0L;
    long endTime = Long.MAX_VALUE;

    private void usage() {
        System.err.println("Usage: CmpTablesExt -src srcTable -dst dstTable | -target esTarget -index esIndex -type esType [-columns <cf1[:col1],...>] [-maxversions <max number of versions to compare>] [-starttime <time>]  [-endtime <time>] ");
        System.exit(1);
    }

    private String getTableFid(String tableName) throws IOException {
        MapRFileSystem mfs;
        Configuration c = new Configuration();
        c.set("fs.defaultFS", "maprfs:///");
        c.set("fs.mapr.disable.namecache", "true");
        try {
            mfs = new MapRFileSystem();
            URI uri = new URI(c.get("fs.defaultFS"));
            mfs.initialize(uri, c);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize MapRFileSystem " + e);
        }
        MapRHTable htable = new MapRHTable();
        htable.init(mfs.getConf(), new Path(tableName));
        return mfs.openTable(new Path(tableName), htable).attrs().toString();
    }

    private String getDestDir(String srcTableName, String targetName, String indexName, String typeName) throws IOException {
        String fid = this.getTableFid(srcTableName);
        Path result = new Path(fid, targetName);
        result = new Path(result, indexName);
        result = new Path(result, typeName);
        return result.toString();
    }

    private void parseArgs(String[] args) throws Exception {
        String esTarget = null;
        String esIndex = null;
        String esType = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                this.srcTableName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                this.dstTableName = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-target")) {
                esTarget = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-index")) {
                esIndex = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-type")) {
                esType = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                this.columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxversions")) {
                this.maxVersions = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-starttime")) {
                String startTimeStr;
                this.startTime = (startTimeStr = args[++i]).equals("-INF") ? 0L : Long.parseLong(startTimeStr);
                continue;
            }
            if (args[i].equalsIgnoreCase("-endtime")) {
                String endTimeStr;
                this.endTime = (endTimeStr = args[++i]).equals("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                continue;
            }
            System.out.println("Unrecognized argument: " + args[i]);
            this.usage();
        }
        if (this.dstTableName == null) {
            if (esTarget == null || esIndex == null || esType == null) {
                this.usage();
            }
            Path dstPath = new Path(ES_REPLICAS, this.getDestDir(this.srcTableName, esTarget, esIndex, esType));
            this.dstTableName = new Path(dstPath, ES_CONFIG_FILE).toString();
        } else if (esTarget != null || esIndex != null || esType != null) {
            this.usage();
        }
        if (this.srcTableName == null || this.dstTableName == null) {
            this.usage();
        }
    }

    private void setScanColumns(Scan scan) {
        if (this.columnSpec != null) {
            String[] cols;
            for (String col : cols = this.columnSpec.split(",")) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    scan.addColumn(Bytes.toBytes((String)names[0]), Bytes.toBytes((String)names[1]));
                    continue;
                }
                scan.addFamily(Bytes.toBytes((String)col));
            }
        }
    }

    public int run(String[] args) throws Exception {
        int ret;
        this.parseArgs(args);
        if (!this.dstTableName.endsWith(EXT_ELASTICSEARCH)) {
            throw new IllegalArgumentException("Destination " + this.dstTableName + " is not a supported external destination");
        }
        Job job = new Job(this.getConf(), "CmpTablesExt_" + this.dstTableName);
        Configuration conf = job.getConfiguration();
        job.setJarByClass(CmpTablesExt.class);
        Scan scan = new Scan();
        scan.setMaxVersions();
        this.setScanColumns(scan);
        scan.setMaxVersions(this.maxVersions);
        scan.setTimeRange(this.startTime, this.endTime);
        TableMapReduceUtil.initTableMapperJob((String)this.srcTableName, (Scan)scan, ExternalTableMapper.class, ImmutableBytesWritable.class, Result.class, (Job)job);
        String uuid = UUID.randomUUID().toString();
        job.setNumReduceTasks(0);
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{Yaml.class, GatewaySink.class});
        Path outputPath = new Path(conf.get("hadoop.tmp.dir"), "output_" + uuid);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Result.class);
        job.setOutputFormatClass(ExternalOutputFormat.class);
        ExternalOutputFormat.setDestinationTable(job, this.dstTableName);
        ExternalOutputFormat.setIsCompare(job, true);
        job.submit();
        System.out.println("job_id: " + job.getJobID().toString());
        int n = ret = job.waitForCompletion(true) ? 0 : 1;
        if (ret == 0) {
            FileSystem fs = outputPath.getFileSystem(conf);
            fs.delete(outputPath, true);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CmpTablesExt(), (String[])args);
            if (ret == 0) {
                System.out.println("Tables match");
            } else {
                System.out.println("Tables do not match");
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred during table comparison: " + e.getMessage());
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }
}

