/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.gateway.GatewayServer;
import com.mapr.fs.gateway.GatewayServerHolder;
import com.mapr.fs.gateway.conf.GatewayConfiguration;
import com.mapr.fs.gateway.conf.GatewayConfigurationHolder;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Gateway {
    GatewayServer server;
    static GatewayConfiguration conf;
    static String buildVersion;
    public static final Log LOG;

    Gateway(Properties prop) throws Exception {
        int port = conf.getGatewayPort();
        int numWorkerThreads = conf.getNumReceiveThreads();
        long memory = conf.getPutMemMb();
        buildVersion = Gateway.class.getPackage().getImplementationVersion();
        if (buildVersion == null || buildVersion.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"MapR BuildVersion not set");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)("MapR BuildVersion: " + buildVersion));
        }
        this.server = GatewayServerHolder.getInstance(this, numWorkerThreads);
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            List<String> inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String argStr : inputArgs) {
                if (!argStr.startsWith("-X")) continue;
                sb.append(argStr).append(" ");
            }
            LOG.info((Object)("GatewayInit: Starting GatewayServer on port " + port + " with num thread " + numWorkerThreads + ", heap size of " + memory + " MB and with startup options " + sb.toString()));
        }
        this.server.start();
    }

    public synchronized void shutdown(String msg, Throwable e) {
        if (LOG.isFatalEnabled()) {
            LOG.fatal((Object)("GatewayShutdown: " + msg));
        }
        if (e != null && LOG.isFatalEnabled()) {
            LOG.fatal((Object)"Gateway Exception", e);
        }
        if (LOG.isErrorEnabled()) {
            Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
            try {
                for (Thread t : stacks.keySet()) {
                    StackTraceElement[] stes = stacks.get(t);
                    LOG.error((Object)("Thread: " + t.getName() + " ID: " + t.getId()));
                    for (StackTraceElement ste : stes) {
                        LOG.error((Object)ste.toString());
                    }
                }
            }
            catch (Throwable e1) {
                LOG.error((Object)"Exception while printing stacktrace", e1);
            }
        }
        if (this.server != null) {
            this.server.setShutdownInProg();
            this.server.stop();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Shutting down Gateway");
        }
        System.exit(-1);
    }

    public static String getBuildVersion() {
        return buildVersion;
    }

    public GatewayServer getGatewayServer() {
        return this.server;
    }

    static void daemonize() {
        System.out.close();
        System.err.close();
    }

    void addShutdownHook() {
        Runtime rt = Runtime.getRuntime();
        rt.addShutdownHook(new ShutDownThread());
    }

    static void logGatewayInfo(Properties properties, String[] args) {
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                sb.append(key.toString());
                sb.append("=");
                sb.append(value.toString());
            }
            LOG.info((Object)("Gateway Properties from configuration file: " + sb.toString()));
            sb.delete(0, sb.length());
            if (args.length > 0) {
                for (String arg : args) {
                    sb.append(arg);
                    sb.append(" ");
                }
                LOG.info((Object)("Gateway Command line args: " + sb.toString()));
            }
        }
    }

    public static void gcLogger(int i) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("GCMonitor detected a GC pause of " + i + " seconds."));
        }
    }

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        Gateway gateway = null;
        try {
            CLDBRpcCommonUtils.getInstance();
            if (args.length == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Initializing Gateway with default, no config file specified");
                }
                conf = GatewayConfigurationHolder.getInstance(properties);
            } else {
                String confFile = args[0];
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Loading properties file : " + confFile));
                }
                try {
                    properties.load(new FileInputStream(confFile));
                }
                catch (IOException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)e.getLocalizedMessage());
                    }
                    throw new IOException("GatewayInit: Could not load properties file : " + confFile);
                }
                conf = GatewayConfigurationHolder.getInstance(properties);
                conf.setConfFile(confFile);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("GatewayInit: Using hostname file " + conf.getMapRHostNameFile() + " and hostid file " + conf.getMapRHostId()));
                }
            }
            if (conf.getBooleanProperty("gateway.as.daemon", false)) {
                Gateway.daemonize();
            }
            Gateway.logGatewayInfo(properties, args);
            gateway = new Gateway(properties);
            gateway.addShutdownHook();
        }
        catch (Exception e) {
            String msg = "GatewayInit: Error starting Gateway";
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)msg, (Throwable)e);
            }
            if (gateway != null) {
                gateway.shutdown(msg, e);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Shutting down Gateway");
            }
            System.exit(-1);
        }
        if (gateway != null) {
            gateway.server.join();
        }
    }

    static {
        ShimLoader.load();
        LOG = LogFactory.getLog(Gateway.class);
    }

    private class ShutDownThread
    extends Thread {
        private ShutDownThread() {
        }

        @Override
        public void run() {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Gateway ShutDown Hook called");
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Gateway shutdown");
            }
            GatewayServer.flushLogBuffer();
        }
    }
}

