/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external.tools;

import com.mapr.db.JsonTable;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.gateway.external.GatewaySink;
import com.mapr.fs.gateway.external.tools.ExternalJsonOutputFormat;
import com.mapr.fs.gateway.external.tools.ExternalJsonTableMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class CopyTableJsonExt
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyTableJsonExt.class);
    private static final String NAME = "CopyTableJsonExt";
    private static final String ES_REPLICAS = File.separator + "opt" + File.separator + "external" + File.separator + "elasticsearch" + File.separator + "replicas";
    private static final String ES_CONFIG_FILE = "config.es";
    private static final String EXT_ELASTICSEARCH = ".es";
    public static final String TABLE_NAME = "import.table.name";
    private static String srcPath;
    private static String dstPath;
    private static boolean mapreduce;
    private static boolean isSuccess;
    private static boolean preserveTimestamps;
    private static String columnSpec;
    private static String startRow;
    private static String stopRow;
    private int numThreads = 16;

    private Job createSubmittableJob(String[] otherArgs) throws IOException {
        Job job = new Job(this.getConf(), "CopyTableJsonExt_" + srcPath);
        job.setJarByClass(CopyTableJsonExt.class);
        Configuration conf = job.getConfiguration();
        conf.set("maprdb.mapreduce.inputtable", srcPath);
        conf.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        conf.setBoolean("maprdb.table.impl.get_deletes", false);
        conf.setBoolean("BUFFERWRITE", false);
        if (startRow != null) {
            conf.set("maprdb.mapreduce.getall.startrow", startRow);
        }
        if (stopRow != null) {
            conf.set("maprdb.mapreduce.getall.stoprow", stopRow);
        }
        if (columnSpec != null) {
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
        }
        job.setInputFormatClass(TableInputFormat.class);
        conf.set(TABLE_NAME, dstPath);
        job.setMapperClass(ExternalJsonTableMapper.class);
        MapReduceUtilMethods.setStartStopRow((Configuration)conf);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(DBDocumentImpl.class);
        job.setOutputFormatClass(ExternalJsonOutputFormat.class);
        conf.set("maprdb.external.outputtable", dstPath);
        conf.setBoolean("maprdb.external.is_comapre", false);
        String uuid = UUID.randomUUID().toString();
        Path outputPath = new Path(conf.get("hadoop.tmp.dir"), "output_" + uuid);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        TableMapReduceUtil.addDependencyJars((Configuration)conf, (Class[])new Class[]{Yaml.class, GatewaySink.class});
        job.setNumReduceTasks(0);
        return job;
    }

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: CopyTableJsonExt [Options] -src <source table path> -dst <destination table path>\nOptions:\n[-startRow <start key>]\n[-stopRow <end key>]\n[-columns cf1[:col1],...]\n[-mapreduce <true|false> (default: true)]\n[-numthreads <number of threads> (default: 16)");
        System.exit(1);
    }

    private String getTableFid(String tableName) throws IOException {
        MapRFileSystem mfs;
        Configuration c = new Configuration();
        c.set("fs.defaultFS", "maprfs:///");
        c.set("fs.mapr.disable.namecache", "true");
        try {
            mfs = new MapRFileSystem();
            URI uri = new URI(c.get("fs.defaultFS"));
            mfs.initialize(uri, c);
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize MapRFileSystem " + e);
        }
        MapRHTable htable = new MapRHTable();
        htable.init(mfs.getConf(), new Path(tableName));
        return mfs.openTable(new Path(tableName), htable).attrs().toString();
    }

    private String getDestDir(String srcTableName, String targetName, String indexName, String typeName) throws IOException {
        String fid = this.getTableFid(srcTableName);
        Path result = new Path(fid, targetName);
        result = new Path(result, indexName);
        result = new Path(result, typeName);
        return result.toString();
    }

    private void ParseArgs(String[] args) throws Exception {
        String esTarget = null;
        String esIndex = null;
        String esType = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                srcPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                dstPath = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-target")) {
                esTarget = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-index")) {
                esIndex = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-type")) {
                esType = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-startRow")) {
                startRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-stopRow")) {
                stopRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            this.Usage(null);
        }
        if (dstPath == null) {
            if (esTarget == null || esIndex == null || esType == null) {
                this.Usage("No destination specified");
            }
            Path dst = new Path(ES_REPLICAS, this.getDestDir(srcPath, esTarget, esIndex, esType));
            dstPath = new Path(dst, ES_CONFIG_FILE).toString();
        } else if (esTarget != null || esIndex != null || esType != null) {
            this.Usage("Cannot provide both dst and target/index/type");
        }
        if (srcPath == null || dstPath == null) {
            this.Usage("missing -src or -dst.");
        }
        if (startRow != null && stopRow != null && startRow.compareTo(stopRow) < 0) {
            this.Usage("stopRow is smaller than startRow.");
        }
    }

    private int run_NoMR(String[] args) throws IOException, Exception {
        Configuration config = this.getConf();
        config.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        config.setBoolean("BUFFERWRITE", false);
        JsonTable srcTable = MapRDBImpl.getTable((String)srcPath);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        int numSplits = tabletInfos.length;
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        for (int i = 0; i < numSplits; ++i) {
            executor.execute(new LoaderThread(i, tabletInfos[i], config));
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (!isSuccess) {
            return 1;
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs.length < 2) {
            this.Usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        this.ParseArgs(otherArgs);
        if (!dstPath.endsWith(EXT_ELASTICSEARCH)) {
            throw new IllegalArgumentException("Destination " + dstPath + " is not a supported external destination");
        }
        if (!mapreduce) {
            return this.run_NoMR(otherArgs);
        }
        Job job = this.createSubmittableJob(otherArgs);
        if (!job.waitForCompletion(true)) {
            LOG.error("CopyTableJsonExt MapReduce job failed !!");
            return 1;
        }
        return 0;
    }

    public static boolean copy(final String[] args, String user, boolean isMapReduce) throws Exception {
        UserGroupInformation ugi = CopyTableJsonExt.createUser(user);
        LOG.info("Running copytable job " + mapreduce + " as user: " + user);
        if (!isMapReduce) {
            System.out.println("No map-reduce");
        }
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableJsonExt(), (String[])args);
                    if (status == 0) {
                        CopyTableJsonExt.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while running copytable job: " + e);
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTableJsonExt(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    static {
        mapreduce = true;
        isSuccess = false;
        preserveTimestamps = true;
        columnSpec = null;
        startRow = null;
        stopRow = null;
    }

    class LoaderThread
    extends BaseLoaderThread {
        LoaderThread(int id, TabletInfo t, Configuration config) {
            super(id, t, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueryCondition c = this.tabletInfo.getCondition();
            GatewaySink sink = null;
            MapRDBTableImpl srcTable = null;
            try {
                sink = new GatewaySink();
                if (sink.OpenStream(dstPath, true) != 0) {
                    throw new IOException("Failed to open GatewaySink");
                }
                srcTable = (MapRDBTableImpl)MapRDBImpl.getTable((Configuration)this.config, (Path)new Path(srcPath));
                DocumentStream documentStream = columnSpec != null ? srcTable.find(c, columnSpec.split(",")) : srcTable.find(c);
                for (Document doc : documentStream) {
                    if (sink.AppendStream(doc) == 0) continue;
                    throw new IOException("Failed to append to GatewaySink stream");
                }
                if (sink.FlushStream() != 0) {
                    throw new IOException("Failed to flush GatewaySink stream");
                }
                CopyTableJsonExt.setJobSuccessful();
            }
            catch (Exception e) {
                LOG.error("CopyTableJsonExt encountered an exception: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (srcTable != null) {
                        srcTable.close();
                    }
                    if (sink != null && sink.CloseStream() != 0) {
                        LOG.error("CopyTableJsonExt failed to close GatewaySink");
                    }
                }
                catch (Exception e) {
                    LOG.error("CopyTableJsonExt encountered an exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    abstract class BaseLoaderThread
    implements Runnable {
        protected TabletInfo tabletInfo;
        protected int myid;
        protected Configuration config;

        protected BaseLoaderThread(int id, TabletInfo t, Configuration config) {
            this.myid = id;
            this.tabletInfo = t;
            this.config = config;
        }
    }
}

