/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.fs.gateway.external.GatewayClassLoader;
import com.mapr.fs.gateway.external.MapRBaseExternalSink;
import com.mapr.fs.gateway.external.MapRExternalSink;
import com.mapr.fs.gateway.external.MapRExternalSinkException;
import com.mapr.fs.gateway.external.MapRImplExternalSink;
import com.mapr.fs.gateway.external.MapRJsonExternalSink;
import com.mapr.fs.hbase.ResultConverter;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.ParsedRow;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Result;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.yaml.snakeyaml.Yaml;

public class GatewaySink {
    static final Log LOG = LogFactory.getLog(GatewaySink.class);
    static Configuration conf;
    static FileSystem fs;
    static GatewayClassLoader cloader;
    static final String EXT_ELASTICSEARCH = ".es";
    private Map<Integer, String> familyIdMap;
    private Map<FieldPath, Integer> jsonPathMap;
    private MapRBaseExternalSink client = null;
    private String sinkConfigFile = null;
    private boolean maprClient = false;
    private boolean isJson = false;

    public static void init() {
        try {
            conf = new Configuration();
            fs = FileSystem.get((Configuration)conf);
            Class<GatewaySink> cls = GatewaySink.class;
            ClassLoader parentClassLoader = cls.getClassLoader();
            cloader = new GatewayClassLoader(parentClassLoader);
            cloader.setLocalPath("/opt/mapr/lib/external");
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading the gatewaySink Class");
            LOG.error((Object)e);
        }
    }

    private static Map getReplicaConfMap(String dstPath) throws IOException {
        FSDataInputStream sinkConfStream = fs.open(new Path(dstPath));
        Yaml yaml = new Yaml();
        Map sinkConfMap = (Map)yaml.load((InputStream)sinkConfStream);
        sinkConfStream.close();
        return sinkConfMap;
    }

    private static String getReplicaClassName(String dstPath, Map sinkConfMap) {
        String replicaClassName = null;
        replicaClassName = (String)sinkConfMap.get("sink.class.name");
        if (replicaClassName == null && dstPath.endsWith(EXT_ELASTICSEARCH)) {
            replicaClassName = "com.mapr.fs.external.es.ESSink";
        }
        return replicaClassName;
    }

    public static String verifyDstSanity(String dstPath) throws IOException {
        Map replicaConfMap = GatewaySink.getReplicaConfMap(dstPath);
        String replicaClassName = GatewaySink.getReplicaClassName(dstPath, replicaConfMap);
        String replicaClassPath = (String)replicaConfMap.get("sink.class.path");
        if (replicaClassName == null) {
            throw new IOException("sink.class.name NOT FOUND in external replica config file or unknown file extension");
        }
        if (replicaClassPath == null) {
            throw new IOException("sink.class.path NOT FOUND in external replica config file " + dstPath);
        }
        try {
            Class<?> sinkClass = cloader.loadClass(replicaClassPath, replicaClassName);
            MapRBaseExternalSink temp_client = (MapRBaseExternalSink)sinkClass.newInstance();
            temp_client.verifyConfigMapSanity(replicaConfMap);
        }
        catch (Exception e) {
            throw new IOException("Can not load the external sink for replica: " + dstPath + " Exception: " + e);
        }
        return replicaClassName;
    }

    public static String getDestinationName(String dstPath) throws IOException {
        Map replicaConfMap = GatewaySink.getReplicaConfMap(dstPath);
        String replicaClassName = GatewaySink.getReplicaClassName(dstPath, replicaConfMap);
        String replicaClassPath = (String)replicaConfMap.get("sink.class.path");
        String destName = null;
        try {
            Class<?> sinkClass = cloader.loadClass(replicaClassPath, replicaClassName);
            MapRBaseExternalSink temp_client = (MapRBaseExternalSink)sinkClass.newInstance();
            destName = temp_client.getDestinationName(replicaConfMap);
        }
        catch (Exception e) {
            throw new IOException("Can not load the external sink for replica: " + dstPath + " Exception: " + e);
        }
        return destName;
    }

    public static String getDestinationType(String dstPath) throws IOException {
        Map replicaConfMap = GatewaySink.getReplicaConfMap(dstPath);
        String replicaClassName = GatewaySink.getReplicaClassName(dstPath, replicaConfMap);
        String replicaClassPath = (String)replicaConfMap.get("sink.class.path");
        String destType = null;
        try {
            Class<?> sinkClass = cloader.loadClass(replicaClassPath, replicaClassName);
            MapRBaseExternalSink temp_client = (MapRBaseExternalSink)sinkClass.newInstance();
            destType = temp_client.getDestinationType(replicaConfMap);
        }
        catch (Exception e) {
            throw new IOException("Can not load the external sink for replica: " + dstPath + " Exception: " + e);
        }
        return destType;
    }

    public int OpenStream(String sConfigFile) {
        return this.OpenStream(sConfigFile, null, null, null, null, false);
    }

    public int OpenStream(String sConfigFile, boolean isJson) {
        return this.OpenStream(sConfigFile, null, null, null, null, isJson);
    }

    public int OpenStream(String sConfigFile, String gatewayConfigFile, int[] familyIds, String[] familyNames) {
        return this.OpenStream(sConfigFile, gatewayConfigFile, familyIds, familyNames, null, false);
    }

    public int OpenStream(String sConfigFile, String gatewayConfigFile, int[] familyIds, String[] familyNames, String[] jsonPaths, boolean isJson) {
        this.sinkConfigFile = sConfigFile;
        LOG.info((Object)(">OpenStream for(" + (isJson ? "json" : "binary") + ") " + this.sinkConfigFile));
        this.isJson = isJson;
        if (familyIds != null) {
            this.familyIdMap = new HashMap<Integer, String>();
            this.jsonPathMap = new HashMap<FieldPath, Integer>();
            for (int i = 0; i < familyIds.length; ++i) {
                this.familyIdMap.put(familyIds[i], familyNames[i]);
                if (jsonPaths[i] == null) continue;
                this.jsonPathMap.put(FieldPath.parseFrom((String)jsonPaths[i]), familyIds[i]);
            }
        }
        try {
            FSDataInputStream sinkConfStream = fs.open(new Path(this.sinkConfigFile));
            Yaml yaml = new Yaml();
            Map sinkConfMap = (Map)yaml.load((InputStream)sinkConfStream);
            sinkConfStream.close();
            String sinkJarPath = (String)sinkConfMap.get("sink.class.path");
            String sinkClassName = (String)sinkConfMap.get("sink.class.name");
            if (sinkClassName == null) {
                sinkClassName = "com.mapr.fs.external.es.ESSink";
            }
            Class<?> sinkClass = cloader.loadClass(sinkJarPath, sinkClassName);
            this.client = (MapRBaseExternalSink)sinkClass.newInstance();
            if (gatewayConfigFile != null) {
                this.client.loadConfig(gatewayConfigFile);
            }
            if (this.client instanceof MapRImplExternalSink) {
                ((MapRImplExternalSink)this.client).connect(this.sinkConfigFile, this.familyIdMap);
            } else {
                this.client.connect(this.sinkConfigFile);
            }
            if (this.client instanceof MapRImplExternalSink && ((MapRImplExternalSink)this.client).useMapRResult()) {
                this.maprClient = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("<OpenStream returning with error for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.debug((Object)("<OpenStream for " + this.sinkConfigFile));
        return 0;
    }

    synchronized void printMapRResult(MapRResult result) {
        LOG.info((Object)String.format("buf size %d, key size %d, is_delete %b", result.getBufSize(), result.getKeyLength(), result.getIsDelete()));
        LOG.info((Object)("Family offsets: " + Arrays.toString(result.familyOffsets)));
        LOG.info((Object)("Column offsets: " + Arrays.toString(result.getColumnOffsets())));
        LOG.info((Object)("Column lengths: " + Arrays.toString(result.getColumnLengths())));
        LOG.info((Object)("Value offsets: " + Arrays.toString(result.getValueOffsets())));
        LOG.info((Object)("Value lengths: " + Arrays.toString(result.getValueLengths())));
        LOG.info((Object)("Col delete: " + Arrays.toString(result.getIsColDelete())));
        LOG.info((Object)("Col delete exact: " + Arrays.toString(result.getIsColDeleteExact())));
        LOG.info((Object)("Timestamps: " + Arrays.toString(result.getTimeStamps())));
        LOG.info((Object)("CF Ids: " + Arrays.toString(result.getCfids())));
        LOG.info((Object)("Cells per family: " + Arrays.toString(result.getCellsPerFamily())));
        LOG.info((Object)("versions: " + Arrays.toString(result.versions())));
    }

    private void AppendDeleteColumn(MapRResult result) throws IOException {
        byte[] key = new byte[result.keyLength];
        System.arraycopy(result.bufBytes, 0, key, 0, result.keyLength);
        String keyStr = new String(key, "UTF-8");
        int cellPos = 0;
        int colPos = 0;
        for (int famPos = 0; famPos < result.cfIds.length; ++famPos) {
            String fam = this.familyIdMap.get(result.cfIds[famPos]);
            for (int c = 0; c < result.cellsPerFamily[famPos]; ++c) {
                byte[] column = new byte[result.getColumnLengths()[colPos]];
                System.arraycopy(result.bufBytes, result.getColumnOffsets()[colPos], column, 0, result.getColumnLengths()[colPos]);
                if (result.getColumnOffsets()[colPos] == 0) {
                    this.client.deleteColumnFamily(keyStr, fam);
                } else if (result.getIsColDelete()[cellPos] == 1 || result.getIsColDeleteExact()[cellPos] == 1) {
                    this.client.deleteColumn(keyStr, fam, new String(column, "UTF-8"));
                }
                cellPos += result.versions()[colPos];
                ++colPos;
            }
        }
    }

    public int AppendStream(MapRResult[] results) {
        int res = 0;
        LOG.debug((Object)(">AppendStream for " + this.sinkConfigFile + " nRows:" + results.length));
        if (this.isJson) {
            return this.AppendStreamJson(results);
        }
        try {
            ParsedRow prow = new ParsedRow();
            for (MapRResult result : results) {
                result.DecodeByteBuf(prow);
                byte[] key = new byte[result.keyLength];
                System.arraycopy(result.bufBytes, 0, key, 0, result.keyLength);
                if (result.getIsDelete()) continue;
                if (this.maprClient) {
                    ((MapRImplExternalSink)this.client).update(result);
                    continue;
                }
                ((MapRExternalSink)this.client).update(ResultConverter.toHBaseResult((MapRResult)result, null, this.familyIdMap));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("<AppendStream returning with error: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            res = 1;
        }
        try {
            this.client.flush();
        }
        catch (Exception e) {
            LOG.error((Object)("AppendStream flush exception: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            res = 1;
        }
        LOG.debug((Object)("<AppendStream for " + this.sinkConfigFile + " nRows:" + results.length));
        return res;
    }

    void printByteBuffers(Map<Integer, ByteBuffer> bufMap) {
        for (Map.Entry<Integer, ByteBuffer> entry : bufMap.entrySet()) {
            byte[] bytes = new byte[entry.getValue().capacity()];
            entry.getValue().get(bytes);
            LOG.error((Object)("Buffer " + entry.getKey() + ": " + DatatypeConverter.printHexBinary((byte[])bytes)));
        }
    }

    String buildFieldString(List<String> components) {
        StringBuilder builder = new StringBuilder();
        for (String component : components) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(component);
        }
        return builder.toString();
    }

    void AppendFieldDeletes(DBDocumentImpl result) throws MapRExternalSinkException {
        DocumentReader.EventType event;
        DBDocumentReaderBase reader = (DBDocumentReaderBase)result.asReader();
        LinkedList<String> fieldStack = new LinkedList<String>();
        LinkedList<String> deleteFields = new LinkedList<String>();
        int arrayLevel = 0;
        boolean skipPop = true;
        block8: while ((event = reader.next()) != null) {
            if (arrayLevel > 0 && event != DocumentReader.EventType.END_ARRAY && event != DocumentReader.EventType.START_ARRAY) continue;
            switch (event) {
                case START_MAP: {
                    skipPop = true;
                    continue block8;
                }
                case END_MAP: {
                    fieldStack.removeLast();
                    continue block8;
                }
                case START_ARRAY: {
                    ++arrayLevel;
                    continue block8;
                }
                case END_ARRAY: {
                    --arrayLevel;
                    continue block8;
                }
            }
            if (!reader.inMap() || reader.getFieldName() == null) continue;
            if (!(skipPop || fieldStack.size() == 0 && reader.getFieldName().compareTo("_id") == 0)) {
                fieldStack.removeLast();
            }
            skipPop = false;
            fieldStack.addLast(reader.getFieldName());
            if (!reader.getControlInfo().isDelete()) continue;
            deleteFields.add(this.buildFieldString(fieldStack));
        }
        if (deleteFields.size() > 0) {
            try {
                this.client.deleteFields(result.getIdAsString(), deleteFields);
            }
            catch (UnsupportedOperationException e) {
                for (String field : deleteFields) {
                    this.client.deleteColumnFamily(result.getIdAsString(), field);
                }
            }
        }
    }

    public int AppendStreamJson(MapRResult[] results) {
        try {
            LOG.info((Object)("Appending " + results.length + " JSON rows for " + this.sinkConfigFile));
            for (MapRResult result : results) {
                if (result.getIsDelete()) {
                    String key = IdCodec.decodeString((ByteBuffer)result.getKey());
                    this.client.delete(key);
                    continue;
                }
                ByteBuffer rowKey = result.getKey();
                Map bufMap = result.getJsonByteBufs();
                if (rowKey == null) {
                    throw new IOException("No row key found");
                }
                if (this.jsonPathMap == null || this.jsonPathMap.size() == 0) {
                    throw new IOException("Missing JSON path map");
                }
                DBDocumentImpl jsonResult = RowcolCodec.decode((Map)bufMap, this.jsonPathMap, this.familyIdMap, (ByteBuffer)rowKey, (boolean)false, (boolean)false, (boolean)false, (boolean)true, null, null);
                int size = jsonResult.size();
                this.AppendFieldDeletes(jsonResult);
                ((MapRJsonExternalSink)this.client).update((Document)jsonResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error((Object)("<AppendStreamJson returning with error: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.error((Object)("<AppendStreamJson for " + this.sinkConfigFile + " nRows:" + results.length));
        return 0;
    }

    public int AppendStream(Result result) {
        try {
            ((MapRExternalSink)this.client).update(result);
        }
        catch (Exception e) {
            LOG.error((Object)("AppendStream failed: " + e.getMessage()));
            LOG.error((Object)e);
            return 1;
        }
        return 0;
    }

    public int AppendStream(Document result) {
        try {
            String strResult = result.toString();
            ((MapRJsonExternalSink)this.client).update(result);
        }
        catch (Exception e) {
            LOG.error((Object)("AppendStream failed: " + e.getMessage()));
            return 1;
        }
        return 0;
    }

    public boolean CompareStream(Result result) throws IOException {
        return ((MapRExternalSink)this.client).compare(result);
    }

    public boolean CompareStream(Document result) throws IOException {
        return ((MapRJsonExternalSink)this.client).compare(result);
    }

    public int FlushStream() {
        LOG.debug((Object)(">FlushStream for " + this.sinkConfigFile));
        try {
            this.client.flush();
        }
        catch (Exception e) {
            LOG.error((Object)("<FlushStream failed: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.debug((Object)("<FlushStream for " + this.sinkConfigFile));
        return 0;
    }

    public int CloseStream() {
        LOG.debug((Object)(">CloseStream for " + this.sinkConfigFile));
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.error((Object)("<CloseStream failed: " + e.getMessage() + " for " + this.sinkConfigFile));
            LOG.error((Object)e);
            return 1;
        }
        LOG.debug((Object)("<CloseStream for " + this.sinkConfigFile));
        return 0;
    }

    static {
        GatewaySink.init();
    }
}

