/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.external;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChildFirstURLClassLoader
extends URLClassLoader {
    static final Log LOG = LogFactory.getLog(ChildFirstURLClassLoader.class);
    static final String[] CNAMEPREFIXS = new String[]{"org.apache.log4j"};
    private ClassLoader system = ChildFirstURLClassLoader.getSystemClassLoader();

    public ChildFirstURLClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    protected boolean loadParentFirst(String name) {
        for (String pre : CNAMEPREFIXS) {
            if (!name.startsWith(pre)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block9: {
            block10: {
                c = null;
                c = this.findLoadedClass(name);
                if (c != null) break block10;
                if (this.loadParentFirst(name)) {
                    c = super.loadClass(name, resolve);
                    LOG.debug((Object)("class " + name + " loaded through parent from " + this.getResource(name)));
                    break block9;
                } else {
                    try {
                        c = this.findClass(name);
                        LOG.debug((Object)("class " + name + " loaded local from " + this.getResource(name)));
                    }
                    catch (ClassNotFoundException e) {
                        if (this.system != null) {
                            try {
                                c = this.system.loadClass(name);
                                LOG.debug((Object)("class " + name + " loaded through system classloader."));
                            }
                            catch (ClassNotFoundException ignored) {
                                LOG.debug((Object)("system classloader failed to load class " + name));
                            }
                        }
                        if (c == null) {
                            c = super.loadClass(name, resolve);
                            LOG.debug((Object)(" class " + name + " loaded through parent from" + this.getResource(name)));
                        }
                        break block9;
                    }
                }
            }
            LOG.debug((Object)("class " + name + " has been loaded "));
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (!this.loadParentFirst(name)) {
            url = super.getResource(name);
        } else {
            url = this.findResource(name);
            if (url == null) {
                if (this.system != null) {
                    url = this.system.getResource(name);
                }
                if (url == null) {
                    url = super.getResource(name);
                }
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.loadParentFirst(name)) {
            return super.getResources(name);
        }
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> systemUrls = null;
        if (this.system != null) {
            systemUrls = this.system.getResources(name);
        }
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (systemUrls != null) {
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

