/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.gateway.conf;

import com.mapr.fs.gateway.conf.GatewayConstants;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GatewayConfiguration
extends GatewayConstants {
    Properties props;
    Properties startupProps;
    String confFileName;
    public AtomicBoolean updateFSProperties = new AtomicBoolean();
    public AtomicBoolean allowUpdates = new AtomicBoolean();
    String maprInstallDir = null;
    private static final Log LOG = LogFactory.getLog(GatewayConfiguration.class);

    public GatewayConfiguration(Properties startupProps) throws IOException {
        this.props = new Properties(startupProps);
        this.startupProps = startupProps;
        this.confFileName = null;
        this.updateFSProperties.set(false);
        this.allowUpdates.set(false);
        this.initImmutableProperties();
        this.setInstallDir();
        this.readHostNameAndIdFromFile();
    }

    private void setInstallDir() {
        this.maprInstallDir = System.getProperty("mapr.home.dir");
        if (this.maprInstallDir == null) {
            this.maprInstallDir = System.getenv("MAPR_HOME");
            if (this.maprInstallDir == null) {
                this.maprInstallDir = "/opt/mapr";
            }
        }
    }

    public String getMapRInstallDir() {
        return this.maprInstallDir;
    }

    public String getServerTicketFileLocation() {
        String serverTicketFileLocation = System.getenv("MAPR_SERVER_TICKETFILE_LOCATION");
        if (serverTicketFileLocation != null) {
            return serverTicketFileLocation;
        }
        return this.maprInstallDir + "/conf/maprserverticket";
    }

    public String getLogFilePath() {
        return this.maprInstallDir + "/logs/gateway.log";
    }

    public String getMapRClusterConfFile() {
        return this.maprInstallDir + "/conf/mapr-clusters.conf";
    }

    public String getMapRHostNameFile() {
        String hostNameFile = System.getenv("MAPR_HOSTNAME_FILE");
        return hostNameFile == null ? this.maprInstallDir + "/hostname" : hostNameFile;
    }

    public String getMapRHostId() {
        String hostIdFile = System.getenv("MAPR_HOSTID_FILE");
        return hostIdFile == null ? this.maprInstallDir + "/hostid" : hostIdFile;
    }

    void initImmutableProperties() {
        this.GATEWAY_RPC_PORT = Integer.parseInt(this.startupProps.getProperty("gateway.port", "7660"));
        this.GATEWAY_NUM_RECEIVE_THREADS = Integer.parseInt(this.startupProps.getProperty("gateway.receive.numthreads", "128"));
        this.GATEWAY_NUM_FLUSH_THREADS = Integer.parseInt(this.startupProps.getProperty("gateway.flush.numthreads", "128"));
        this.GATEWAY_PUT_MEM_MB = Integer.parseInt(this.startupProps.getProperty("gateway.put.mem.mb", "128"));
        this.GATEWAY_LOG_FILE_SIZE_MB = Integer.parseInt(this.startupProps.getProperty("gateway.logfile.size.mb", "1024"));
        this.GATEWAY_LOG_LEVEL = this.startupProps.getProperty("gateway.log.level", "INFO");
        this.GATEWAY_MARLIN_LOG_COMPACTION_STATS_UPDATE_INTERVAL_MS = Long.parseLong(this.startupProps.getProperty("gateway.es.logcompaction.statsupdate.interval.ms", "3600000"));
        this.GATEWAY_MARLIN_LOG_COMPACTION_TOPIC_REFRESH_INTERVAL_MS = Long.parseLong(this.startupProps.getProperty("gateway.es.logcompaction.topicrefresh.interval.ms", "300000"));
        this.GATEWAY_MARLIN_LOG_COMPACTION_PERCENTAGE_TOPIC_INCREASE = Integer.parseInt(this.startupProps.getProperty("gateway.es.logcompaction.percentage.topic.increase", "30"));
        this.GATEWAY_MARLIN_LOG_COMPACTION_WAIT_UPPER_BOUND_MS = Long.parseLong(this.startupProps.getProperty("gateway.es.logcompaction.wait.upper.bound.ms", "86400000"));
    }

    public void setConfFile(String confFileName) {
        this.confFileName = confFileName;
    }

    public String getConfFileName() {
        return this.confFileName;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String defaultValueS = defaultValue ? "true" : "false";
        String value = this.props.getProperty(key, defaultValueS);
        return value.equalsIgnoreCase("true");
    }

    public void setBooleanProperty(String key, boolean value) {
        String valueS = value ? "true" : "false";
        this.setProperty(key, valueS);
    }

    public long getLongProperty(String key, long defaultValue) {
        String valueS = this.props.getProperty(key, String.valueOf(defaultValue));
        return Long.parseLong(valueS);
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String valueS = this.props.getProperty(key, String.valueOf(defaultValue));
        return Integer.parseInt(valueS);
    }

    public void setIntegerProperty(String key, int value) {
        String valueS = String.valueOf(value);
        this.setProperty(key, valueS);
    }

    public int getGatewayPort() {
        return this.GATEWAY_RPC_PORT;
    }

    public int getMfsPortOffset() {
        return this.GATEWAY_ALTENATE_MFS_PORT_OFFSET;
    }

    public int getNumReceiveThreads() {
        return this.GATEWAY_NUM_RECEIVE_THREADS;
    }

    public int getNumFlushThreads() {
        return this.GATEWAY_NUM_FLUSH_THREADS;
    }

    public int getPutMemMb() {
        return this.GATEWAY_PUT_MEM_MB;
    }

    public int getLogSizeMb() {
        return this.GATEWAY_LOG_FILE_SIZE_MB;
    }

    public String getLogLevel() {
        return this.GATEWAY_LOG_LEVEL;
    }

    public long getMarlinLcTopicRefreshIntervalMs() {
        return this.GATEWAY_MARLIN_LOG_COMPACTION_TOPIC_REFRESH_INTERVAL_MS;
    }

    public long getMarlinLcStatsUpdateIntervalMs() {
        return this.GATEWAY_MARLIN_LOG_COMPACTION_STATS_UPDATE_INTERVAL_MS;
    }

    public int getMarlinLcPercentageTopicIncrease() {
        return this.GATEWAY_MARLIN_LOG_COMPACTION_PERCENTAGE_TOPIC_INCREASE;
    }

    public long getMarlinLcWaitUpperBoundMs() {
        return this.GATEWAY_MARLIN_LOG_COMPACTION_WAIT_UPPER_BOUND_MS;
    }

    public void store(FileOutputStream fileOutputStream, String comment) throws IOException {
        this.props.store(fileOutputStream, comment);
    }

    public String getServerId() {
        return this.serverId;
    }

    void setServerId(String nodeId) throws IOException {
        try {
            this.serverId = nodeId;
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid nodeID specified in " + this.getMapRHostNameFile() + e);
        }
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setHostName(String hostName) {
        this.hostname = hostName;
    }

    public void readHostNameAndIdFromFile() throws IOException {
        BufferedReader b;
        String nodeId;
        BufferedReader b2;
        String line;
        FileReader fr = new FileReader(this.getMapRHostNameFile());
        if (fr != null && (line = (b2 = new BufferedReader(fr)).readLine()) != null && !line.isEmpty()) {
            this.setHostName(line);
        }
        fr.close();
        FileReader frID = new FileReader(this.getMapRHostId());
        if (frID != null && (nodeId = (b = new BufferedReader(frID)).readLine()) != null && !nodeId.isEmpty()) {
            this.setServerId(nodeId);
        }
        frID.close();
    }

    public String getGatewayIdentifierString() {
        return "ServerID: " + this.getServerId() + " HostName: " + this.getHostName();
    }
}

