/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.fs.ShimLoader;
import com.mapr.security.UserInformation;

public class UnixUserGroupHelper
implements UserInformation {
    @Override
    public native int getUserId(String var1) throws SecurityException;

    @Override
    public native int[] getGroups(String var1) throws SecurityException;

    @Override
    public native int getGroupId(String var1) throws SecurityException;

    @Override
    public native String getUsername(int var1) throws SecurityException;

    @Override
    public native String getGroupname(int var1) throws SecurityException;

    @Override
    public native void setUID(String var1) throws SecurityException;

    @Override
    public native String getLoggedinUsername() throws SecurityException;

    public static void main(String[] args) {
        UnixUserGroupHelper uugh = new UnixUserGroupHelper();
        try {
            int maprUid = uugh.getUserId("mapr");
            int sudoGid = uugh.getGroupId("sudo");
            System.out.println("uid for mapr is " + maprUid);
            System.out.println("gid for groupname sudo is " + sudoGid);
            String maprUserName = uugh.getUsername(maprUid);
            if (maprUserName.matches("mapr")) {
                System.out.println("uid->username for mapr's uid returned " + maprUserName);
            } else {
                System.out.println("FAIL: uid->username for mapr's uid returned " + maprUserName);
                System.exit(-1);
            }
            String sudoGroupName = uugh.getGroupname(sudoGid);
            if (sudoGroupName.matches("sudo")) {
                System.out.println("gid->groupname for sudo's gid returned " + sudoGroupName);
            } else {
                System.out.println("FAIL: gid->groupname for sudo's gid returned " + sudoGroupName);
                System.exit(-1);
            }
            int[] groups = uugh.getGroups("mapr");
            int i = 0;
            for (i = 0; i < groups.length; ++i) {
                System.out.println("Found group id for mapr: " + groups[i]);
            }
        }
        catch (SecurityException se) {
            System.out.println("Test failed: got unexpected exception");
            se.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            System.out.println("FAIL: Unexpected exception");
            e.printStackTrace();
            System.exit(-1);
        }
        boolean unknownUser = false;
        try {
            System.out.println("uid for unknownUser is " + uugh.getUserId("unknownUser"));
        }
        catch (SecurityException se) {
            unknownUser = true;
        }
        catch (Exception e) {
            System.out.println("FAIL: Unexpected exception");
            e.printStackTrace();
            System.exit(-1);
        }
        if (!unknownUser) {
            System.out.println("FAIL: Expected unknownUser to be an invalid username");
            System.exit(-1);
        }
        System.out.println("All tests passed");
    }

    static {
        ShimLoader.load();
    }
}

