/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin.listener;

import com.mapr.fs.jni.Errno;
import com.mapr.fs.marlin.listener.ListenerRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.common.TopicPartition;

public class NativeData {
    public long[] long_data;
    public byte[] byte_data;
    public int err;
    private int longArrIndex = 0;
    private int byteArrIndex = 0;

    public int length() {
        return this.long_data.length;
    }

    public long[] long_data() {
        return this.long_data;
    }

    public byte[] byte_data() {
        return this.byte_data;
    }

    public int error() {
        return this.err;
    }

    public void startParser() {
        this.longArrIndex = 0;
        this.byteArrIndex = 0;
    }

    public boolean HasData() {
        return this.longArrIndex < this.length();
    }

    public TopicPartition getNextTopicPartition() {
        int size = (int)this.long_data[this.longArrIndex++];
        int offset = (int)this.long_data[this.longArrIndex++];
        String stream = new String(this.byte_data, offset, size);
        size = (int)this.long_data[this.longArrIndex++];
        offset = (int)this.long_data[this.longArrIndex++];
        String topic = new String(this.byte_data, offset, size);
        int partition = (int)this.long_data[this.longArrIndex++];
        return new TopicPartition(stream + ":" + topic, partition);
    }

    public Map<TopicPartition, List<ListenerRecord>> parseListenerRecords() throws NoOffsetForPartitionException {
        HashMap<TopicPartition, List<ListenerRecord>> result = new HashMap<TopicPartition, List<ListenerRecord>>();
        this.startParser();
        while (this.HasData()) {
            int error;
            TopicPartition p = this.getNextTopicPartition();
            if ((error = (int)this.long_data[this.longArrIndex++]) != 0) {
                throw new NoOffsetForPartitionException("Error: " + Errno.toString((int)error) + "(" + error + ") for topicpartition " + p);
            }
            long numMsgs = this.long_data[this.longArrIndex++];
            ArrayList<ListenerRecord> recs = new ArrayList<ListenerRecord>();
            int i = 0;
            while ((long)i < numMsgs) {
                long msgSeq = this.long_data[this.longArrIndex++];
                int keySz = (int)this.long_data[this.longArrIndex++];
                int keyOff = (int)this.long_data[this.longArrIndex++];
                int valSz = (int)this.long_data[this.longArrIndex++];
                int valOff = (int)this.long_data[this.longArrIndex++];
                byte[] key = null;
                byte[] value = null;
                if (keySz > 0) {
                    key = new byte[keySz];
                    System.arraycopy(this.byte_data, keyOff, key, 0, keySz);
                }
                if (valSz > 0) {
                    value = new byte[valSz];
                    System.arraycopy(this.byte_data, valOff, value, 0, valSz);
                }
                recs.add(new ListenerRecord(p.topic(), p.partition(), msgSeq, key, value));
                ++i;
            }
            result.put(p, recs);
        }
        return result;
    }
}

