/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.marlin;

import com.mapr.db.DBDocument;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.proto.Marlinserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinRecord
extends DBDocumentImpl {
    static final Logger LOG = LoggerFactory.getLogger(MarlinRecord.class);
    private Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
    private DBDocument maprRecord;
    public static String PARTITION = "partition";
    public static String TOPIC = "topic";
    public static String SEQUENCE_NUMBER = "sequenceNumber";
    public static String PRODUCER = "producer";
    public static String KEY = "key";
    public static String VALUE = "value";
    public static String TIMESTAMP = "timestamp";
    public static String TOPIC_UNIQ = "topicUniq";
    public static String LISTENER_GROUP = "listenerGroup";

    public MarlinRecord(DBDocument rowKeyDoc, DBDocument rowMsgDoc, int indexInRow) {
        String fieldName;
        LOG.debug("Topic: " + rowKeyDoc.getString(TOPIC) + "Partition: " + rowKeyDoc.getInt(PARTITION) + "BaseSequenceNumber: " + rowKeyDoc.getLong(SEQUENCE_NUMBER) + "IndexInRow: " + indexInRow);
        this.set(PARTITION, rowKeyDoc.getInt(PARTITION));
        this.set(TOPIC, rowKeyDoc.getString(TOPIC));
        long seqNumber = rowKeyDoc.getLong(SEQUENCE_NUMBER) + (long)indexInRow;
        this.set(SEQUENCE_NUMBER, seqNumber);
        if (rowKeyDoc.getString(PRODUCER) != null) {
            this.set(PRODUCER, rowKeyDoc.getString(PRODUCER));
        }
        if (rowMsgDoc.getBinary(fieldName = this.mdef.getFMsgsKey()) != null) {
            this.set(KEY, rowMsgDoc.getBinary(fieldName));
        }
        fieldName = this.mdef.getFMsgsValue();
        this.set(VALUE, rowMsgDoc.getBinary(fieldName));
    }
}

