/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestBinarySecurityPolicyEnforcement
extends BaseTest {
    private static String VOLUME_TAGGED_OK;
    private static String VOLUME_TAGGED_NOACCESS;
    private static String VOLUME_TAGGED_OK_PATH;
    private static String VOLUME_TAGGED_NOACCESS_PATH;
    private static String SECURITY_POLICY_ENFORCE_OK;
    private static String SECURITY_POLICY_ENFORCE_NOTALLOWED;
    private static final byte[] COLUMN_FAMILY_NAME;
    private static final byte[] COLUMN1_NAME;
    private static final byte[] COLUMN2_NAME;
    private static final String ROW1 = "rowKey1";
    private static final String ROW2 = "rowKey2";
    private static final Logger _logger;
    private static boolean policyServiceMasterStatusSet;

    @BeforeClass
    public static void prep() throws Exception {
        int exitCode = 0;
        SECURITY_POLICY_ENFORCE_OK = "spenforceok";
        SECURITY_POLICY_ENFORCE_NOTALLOWED = "spenforcenotallowed";
        VOLUME_TAGGED_OK = "voltaggedok";
        VOLUME_TAGGED_NOACCESS = "voltaggednoaccess";
        VOLUME_TAGGED_OK_PATH = "/" + VOLUME_TAGGED_OK;
        VOLUME_TAGGED_NOACCESS_PATH = "/" + VOLUME_TAGGED_NOACCESS;
        _logger.info("Setting CLDB to global PBS master");
        _logger.info("Checking if security policy " + SECURITY_POLICY_ENFORCE_OK + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli security policy info -columns policyname -name " + SECURITY_POLICY_ENFORCE_OK)).getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_OK + " does not exist, creating");
            TestCluster.runCommand((String)("maprcli security policy create -name " + SECURITY_POLICY_ENFORCE_OK + " -allowtagging true -accesscontrol Armed -readaces 'u:root' -writeaces 'u:root'"));
        } else {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_OK + " exists, setting allowtagging=true, accesscontrol=Armed, readaces|writeaces=u:root");
            TestCluster.runCommand((String)("maprcli security policy modify -name " + SECURITY_POLICY_ENFORCE_OK + " -wiresecurityenabled true -allowtagging true -accesscontrol Armed  -readaces 'u:root' -writeaces 'u:root'"));
        }
        _logger.info("Checking if security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli security policy info -columns policyname -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED)).getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " does not exist, creating");
            TestCluster.runCommand((String)("maprcli security policy create -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -allowtagging true -accesscontrol Armed -readaces '!u:root' -writeaces '!u:root'"));
        } else {
            _logger.info("Security policy " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " already exists, setting allowtagging=true, accesscontrol=Armed, readaces|writeaces=!u=root");
            TestCluster.runCommand((String)("maprcli security policy modify -name " + SECURITY_POLICY_ENFORCE_NOTALLOWED + " -allowtagging true -accesscontrol Armed -readaces '!u:root'  -writeaces '!u:root'"));
        }
        Thread.sleep(45000L);
        TestBinarySecurityPolicyEnforcement.createTaggedVolume(VOLUME_TAGGED_OK, VOLUME_TAGGED_OK_PATH, SECURITY_POLICY_ENFORCE_OK);
        TestBinarySecurityPolicyEnforcement.createTaggedVolume(VOLUME_TAGGED_NOACCESS, VOLUME_TAGGED_NOACCESS_PATH, SECURITY_POLICY_ENFORCE_NOTALLOWED);
        Thread.sleep(45000L);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        TestBinarySecurityPolicyEnforcement.removeVolume(VOLUME_TAGGED_OK);
        TestBinarySecurityPolicyEnforcement.removeVolume(VOLUME_TAGGED_NOACCESS);
    }

    @Test
    public void testVolBinaryOK() throws Exception {
        long num;
        String TABLE_NAME = "testtable1";
        String COLUMN_FAMILY_NAME_STRING = "address";
        byte[] COLUMN_FAMILY_NAME = Bytes.toBytes((String)COLUMN_FAMILY_NAME_STRING);
        int exitCode = 0;
        String city = "";
        String TABLE_PATH_OK = VOLUME_TAGGED_OK_PATH + "/" + TABLE_NAME;
        Configuration conf = HBaseConfiguration.create();
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        TableName tname = TableName.valueOf((byte[])Bytes.toBytes((String)TABLE_PATH_OK));
        HTableDescriptor tableDescriptor = new HTableDescriptor(tname);
        tableDescriptor.addFamily(new HColumnDescriptor(COLUMN_FAMILY_NAME));
        admin.createTable(tableDescriptor);
        Table table = connection.getTable(TableName.valueOf((byte[])Bytes.toBytes((String)TABLE_PATH_OK)));
        _logger.info("Created table " + table.getName() + " with CF " + COLUMN_FAMILY_NAME_STRING);
        _logger.info("Adding data to table " + TABLE_PATH_OK + " using PUT");
        Put put1 = new Put(Bytes.toBytes((String)ROW1));
        long num1 = 1L;
        put1.addColumn(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)"Sunnyvale"));
        put1.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num1));
        table.put(put1);
        _logger.info("Verifying data exists in table " + TABLE_PATH_OK + ", column " + COLUMN1_NAME + " using checkAndPut");
        boolean isSuccessful = false;
        try {
            isSuccessful = table.checkAndPut(Bytes.toBytes((String)ROW1), COLUMN_FAMILY_NAME, COLUMN1_NAME, null, put1);
            if (isSuccessful) {
                _logger.info("ERROR: CheckAndPut for rowKey1 succeeded, should have failed");
            } else {
                _logger.info("SUCCESS: CheckAndPut for rowKey1 failed, data already exists, as expected");
            }
            Assert.assertEquals((Object)isSuccessful, (Object)false);
            exitCode = 0;
        }
        catch (Exception e) {
            exitCode = 1;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Verifying data does not exist in table " + TABLE_PATH_OK + ", column " + COLUMN2_NAME + " using checkAndPut");
        Put put2 = new Put(Bytes.toBytes((String)ROW2));
        long num2 = 2L;
        put2.addColumn(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)"San Jose"));
        put2.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num2));
        try {
            isSuccessful = table.checkAndPut(Bytes.toBytes((String)ROW2), COLUMN_FAMILY_NAME, COLUMN1_NAME, null, put2);
            if (isSuccessful) {
                _logger.info("SUCCESS: OK: CheckAndPut for rowKey2 succeeded");
            } else {
                _logger.info("ERROR: CheckAndPut for rowKey2 failed, data already exists");
            }
            Assert.assertEquals((Object)isSuccessful, (Object)true);
            exitCode = 0;
        }
        catch (Exception e) {
            exitCode = 1;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        try {
            _logger.info("Performing a GET on table " + TABLE_PATH_OK);
            Result getResult = table.get(new Get(Bytes.toBytes((String)ROW1)));
            city = Bytes.toString((byte[])getResult.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
            num = Bytes.toLong((byte[])getResult.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
            _logger.info("Get a single row by row key before increment");
            _logger.info("rowKey1:City:" + city + ", Num:" + num);
            Assert.assertEquals((Object)city, (Object)"Sunnyvale");
            Assert.assertEquals((long)num, (long)1L);
            exitCode = 0;
        }
        catch (Exception e) {
            exitCode = 1;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Scan for all cities and house numbers:");
        try {
            Scan scan = new Scan();
            ResultScanner scanner = table.getScanner(scan);
            for (Result row : scanner) {
                String key = Bytes.toString((byte[])row.getRow());
                byte[] valueBytes = row.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME);
                byte[] numBytes = row.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME);
                _logger.info("Key:" + key + ", City:" + Bytes.toString((byte[])valueBytes) + ", Num:" + Bytes.toLong((byte[])numBytes));
                if (key.equals(ROW1)) {
                    Assert.assertEquals((Object)Bytes.toString((byte[])valueBytes), (Object)"Sunnyvale");
                    Assert.assertEquals((long)Bytes.toLong((byte[])numBytes), (long)1L);
                    continue;
                }
                if (key.equals(ROW2)) {
                    Assert.assertEquals((Object)Bytes.toString((byte[])valueBytes), (Object)"San Jose");
                    Assert.assertEquals((long)Bytes.toLong((byte[])numBytes), (long)2L);
                    continue;
                }
                Assert.assertFalse((boolean)true);
            }
            exitCode = 0;
        }
        catch (Exception e) {
            exitCode = 1;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        Increment increment = new Increment(Bytes.toBytes((String)ROW1));
        increment.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, 1L);
        table.increment(increment);
        Result getResult2 = table.get(new Get(Bytes.toBytes((String)ROW1)));
        city = Bytes.toString((byte[])getResult2.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
        num = Bytes.toLong((byte[])getResult2.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
        _logger.info("Get a single row by row key after increment");
        _logger.info("rowKey1:City:" + city + ", Num:" + num);
        Assert.assertEquals((Object)city, (Object)"Sunnyvale");
        Assert.assertEquals((long)num, (long)2L);
        Append append = new Append(Bytes.toBytes((String)ROW1));
        append.add(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)" City"));
        append.add(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num));
        Result appendResult = table.append(append);
        city = Bytes.toString((byte[])appendResult.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
        num = Bytes.toLong((byte[])appendResult.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
        _logger.info("Get a single row by row key after appending to rowKey1");
        _logger.info("rowKey1:City:" + city + ", Num:" + num);
        Assert.assertEquals((Object)city, (Object)"Sunnyvale City");
        Assert.assertEquals((long)num, (long)2L);
        _logger.info("Deleting table " + TABLE_PATH_OK);
        admin.disableTable(table.getName());
        admin.deleteTable(table.getName());
        table.close();
        connection.close();
    }

    @Test
    public void testPutVolBinaryDenied() throws Exception {
        String TABLE_NAME = "testtable2";
        String COLUMN_FAMILY_NAME_STRING = "address";
        byte[] COLUMN_FAMILY_NAME = Bytes.toBytes((String)COLUMN_FAMILY_NAME_STRING);
        int exitCode = 0;
        String TABLE_PATH_NOACCESS = VOLUME_TAGGED_NOACCESS_PATH + "/" + TABLE_NAME;
        Configuration conf = HBaseConfiguration.create();
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        TableName tname = TableName.valueOf((byte[])Bytes.toBytes((String)TABLE_PATH_NOACCESS));
        HTableDescriptor tableDescriptor = new HTableDescriptor(tname);
        tableDescriptor.addFamily(new HColumnDescriptor(COLUMN_FAMILY_NAME));
        admin.createTable(tableDescriptor);
        Table table = connection.getTable(TableName.valueOf((byte[])Bytes.toBytes((String)TABLE_PATH_NOACCESS)));
        _logger.info("Created table " + table.getName() + " with CF " + COLUMN_FAMILY_NAME_STRING);
        _logger.info("Adding data to table " + TABLE_PATH_NOACCESS + " using PUT");
        Put put1 = new Put(Bytes.toBytes((String)ROW1));
        long num1 = 1L;
        put1.addColumn(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)"Sunnyvale"));
        put1.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num1));
        exitCode = 0;
        try {
            table.put(put1);
            exitCode = 1;
            _logger.info("PUT unexpectedly succeeds when it should fail");
        }
        catch (InterruptedIOException e) {
            exitCode = 0;
            _logger.info("PUT fails as expected with InterruptedIOException: " + e.getMessage());
        }
        Assert.assertEquals((long)exitCode, (long)0L);
        try {
            _logger.info("Performing a GET on table " + TABLE_PATH_NOACCESS);
            Result getResult = table.get(new Get(Bytes.toBytes((String)ROW1)));
            exitCode = 1;
        }
        catch (IOException e) {
            exitCode = 0;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Scan for all cities and house numbers:");
        try {
            Scan scan = new Scan();
            ResultScanner scanner = table.getScanner(scan);
            for (Result row : scanner) {
                String key = Bytes.toString((byte[])row.getRow());
                _logger.info("SCAN on denied table obtained key " + key);
            }
            exitCode = 1;
        }
        catch (Exception e) {
            exitCode = 0;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        Increment increment = new Increment(Bytes.toBytes((String)ROW1));
        increment.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, 1L);
        try {
            table.increment(increment);
            exitCode = 1;
        }
        catch (Exception e) {
            exitCode = 0;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        long num = 1L;
        Append append = new Append(Bytes.toBytes((String)ROW1));
        append.add(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)" City"));
        append.add(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num));
        try {
            Result appendResult = table.append(append);
            exitCode = 1;
        }
        catch (Exception e) {
            exitCode = 0;
        }
        Assert.assertEquals((long)0L, (long)exitCode);
        _logger.info("Deleting table " + TABLE_PATH_NOACCESS);
        admin.disableTable(table.getName());
        admin.deleteTable(table.getName());
        table.close();
        connection.close();
    }

    private static void createTaggedVolume(String volumeName, String volumePath, String securityPolicy) throws Exception {
        int exitCode = 0;
        _logger.info("Checking if volume " + volumeName + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli volume info -name " + volumeName)).getExitCode();
        if (exitCode == 0) {
            _logger.info("Volume " + volumeName + " exists, deleting first");
            TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
        }
        exitCode = TestCluster.runCommand((String)("maprcli volume create -name " + volumeName + " -path " + volumePath + " -securitypolicy " + securityPolicy)).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private static void createUntaggedVolume(String volumeName, String volumePath) throws Exception {
        int exitCode = 0;
        _logger.info("Checking if volume " + volumeName + " exists");
        exitCode = TestCluster.runCommand((String)("maprcli volume info -name " + volumeName)).getExitCode();
        if (exitCode == 0) {
            _logger.info("Volume " + volumeName + " exists, deleting first");
            TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
        }
        exitCode = TestCluster.runCommand((String)("maprcli volume create -name " + volumeName + " -path " + volumePath)).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private static void removeVolume(String volumeName) throws Exception {
        TestCluster.runCommand((String)("maprcli volume remove -name " + volumeName));
    }

    private static void deleteTable(String strTablePath) throws Exception {
        int exitCode = 0;
        String tableDeleteCommand = "maprcli table delete -path " + strTablePath;
        _logger.info("Running command " + tableDeleteCommand);
        exitCode = TestCluster.runCommand((String)tableDeleteCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    public static void updatePolicyServiceMasterStatus() throws Exception {
        String enablePolicyCreation = "maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}";
        RunCommand enablePolicyCreationRC = TestCluster.runCommand((String)"maprcli config save -values {\"cldb.pbs.global.master\":\"1\"}");
        if (enablePolicyCreationRC.getExitCode() != 0) {
            _logger.error(enablePolicyCreationRC.getStdOut());
            Assert.fail((String)("Unable to Set the current cluster as Global Master: " + enablePolicyCreationRC.getStdOut()));
        }
        policyServiceMasterStatusSet = true;
    }

    static {
        COLUMN_FAMILY_NAME = Bytes.toBytes((String)"address");
        COLUMN1_NAME = Bytes.toBytes((String)"city");
        COLUMN2_NAME = Bytes.toBytes((String)"number");
        _logger = LoggerFactory.getLogger(TestBinarySecurityPolicyEnforcement.class);
        policyServiceMasterStatusSet = false;
    }
}

