/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import java.lang.invoke.CallSite;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;

public class BMCallable
implements Callable<Boolean> {
    final BufferedMutator bm_;
    final BufferedMutator.ExceptionListener listener_;
    final MapRHTable mTable_;
    final LinkedList<Object> requests_;
    final LinkedList<Object> responses_;
    private static final Log LOG = LogFactory.getLog(BMCallable.class);

    public BMCallable(BufferedMutator bm, BufferedMutator.ExceptionListener listener, MapRHTable mTable, LinkedList<Object> requests, LinkedList<Object> responses) {
        this.bm_ = bm;
        this.listener_ = listener;
        this.mTable_ = mTable;
        this.requests_ = requests;
        this.responses_ = responses;
    }

    @Override
    public Boolean call() throws Exception {
        if (this.listener_ == null) {
            LOG.info((Object)("No Listener found in response for table  " + this.mTable_.getTablePath()));
            return Boolean.TRUE;
        }
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        LinkedList<Put> actions = new LinkedList<Put>();
        LinkedList<CallSite> filepath = new LinkedList<CallSite>();
        Boolean ret = Boolean.TRUE;
        for (Object e : this.requests_) {
            Object result = this.responses_.remove();
            try {
                if (e == null) {
                    LOG.warn((Object)"BufferedMutatorCallBackQueue receives a null put.");
                    continue;
                }
                if (e instanceof Put) {
                    Put hPut = (Put)e;
                    actions.add(hPut);
                    exceptions.add((Exception)result);
                    filepath.add((CallSite)((Object)("cluster:" + this.mTable_.getMapRFS().getUri() + ", path" + this.mTable_.getTablePath())));
                    continue;
                }
                LOG.warn((Object)("BufferedMutatorCallBackQueue receives a put of type " + e.getClass().getName()));
            }
            catch (Exception e2) {
                LOG.error((Object)("Fail to report a put error to BufferedMutator listeners, reason: " + e2.getStackTrace() + "\n The error to report is " + ((Exception)result).getStackTrace()));
                ret = Boolean.FALSE;
            }
        }
        RetriesExhaustedWithDetailsException exp = new RetriesExhaustedWithDetailsException(exceptions, actions, filepath);
        this.listener_.onException(exp, this.bm_);
        return ret;
    }
}

