/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import com.mapr.fs.hbase.HTableDescriptorProxy;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TestAtomicOpsWithNullValue {
    public static boolean creatTable(String tableName, String[] familys, Configuration conf) throws Exception {
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (admin.tableExists(tableName)) {
            System.out.println("table already exists!");
            return false;
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        for (int i = 0; i < familys.length; ++i) {
            HTableDescriptorProxy.addFamily((HTableDescriptor)tableDesc, (HColumnDescriptor)new HColumnDescriptor(familys[i]));
        }
        admin.createTable(tableDesc);
        System.out.println("create table " + tableName + " ok.");
        return true;
    }

    public static void printscan(HTable ht1, Scan scan) throws Exception {
        ArrayList<Result> ht1rs = new ArrayList<Result>();
        ResultScanner rs1 = ht1.getScanner(scan);
        System.out.println("--------" + ht1.getName() + " Scan Results---------");
        for (Result result : rs1) {
            System.out.println(SegKeyRangeUtil.resultToString((Result)result));
            ht1rs.add(result);
        }
        rs1.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("NULL Test for SingleColumnValueFilter. Usage:\n\t hbase com.mapr.fs.hbase.test.TestAtomicOpsWithNullValue tableName zkQuorumIP zkClientPort");
            return;
        }
        byte[] row0 = Bytes.toBytes((String)"r0");
        byte[] row1 = Bytes.toBytes((String)"r1");
        byte[] row2 = Bytes.toBytes((String)"r2");
        byte[] row3 = Bytes.toBytes((String)"r3");
        byte[] rowx = Bytes.toBytes((String)"rx");
        byte[] fam0 = Bytes.toBytes((String)"f0");
        byte[] fam1 = Bytes.toBytes((String)"f1");
        byte[] fam2 = Bytes.toBytes((String)"f2");
        byte[] famx = Bytes.toBytes((String)"fx");
        byte[] qual0 = Bytes.toBytes((String)"c0");
        byte[] qual1 = Bytes.toBytes((String)"c1");
        byte[] qual2 = Bytes.toBytes((String)"c2");
        byte[] qualx = Bytes.toBytes((String)"cx");
        byte[] r0val00 = Bytes.toBytes((String)"r0-v00");
        byte[] r0val01 = Bytes.toBytes((String)"r0-v01");
        byte[] r0val02 = Bytes.toBytes((String)"r0-v02");
        byte[] r0val10 = Bytes.toBytes((String)"r0-v10");
        byte[] r0val11 = Bytes.toBytes((String)"r0-v11");
        byte[] r0val12 = Bytes.toBytes((String)"r0-v12");
        byte[] r0val20 = Bytes.toBytes((String)"r0-v20");
        byte[] r0val21 = Bytes.toBytes((String)"r0-v21");
        byte[] r0val22 = Bytes.toBytes((String)"r0-v22");
        byte[] r1val00 = Bytes.toBytes((String)"r1-v00");
        byte[] r1val01 = Bytes.toBytes((String)"r1-v01");
        byte[] r1val02 = Bytes.toBytes((String)"r1-v02");
        byte[] r1val10 = Bytes.toBytes((String)"r1-v10");
        byte[] r1val11 = Bytes.toBytes((String)"r1-v11");
        byte[] r1val20 = Bytes.toBytes((String)"r1-v20");
        byte[] binval = new byte[]{10, 20, 30, 40, 50, 60, 70, 80, 90};
        byte[] valempty = Bytes.toBytes((String)"");
        byte[] chgr1val00 = Bytes.toBytes((String)"chg-r1-v00");
        byte[] chgr1val01 = Bytes.toBytes((String)"chg-r1-v01");
        byte[] chgr1val02 = Bytes.toBytes((String)"chg-r1-v02");
        String tableName1 = args[0];
        String quorum = "localhost";
        if (args.length > 1) {
            quorum = args[1];
        }
        String port = "5181";
        if (args.length > 2) {
            port = args[2];
        }
        Configuration conf = new Configuration();
        conf.set("hbase.zookeeper.quorum", quorum);
        conf.set("hbase.zookeeper.property.clientPort", port);
        System.out.println("hbase.zookeeper.quorum = " + conf.get("hbase.zookeeper.quorum") + "hbase.zookeeper.property.clientPort = " + conf.get("hbase.zookeeper.property.clientPort"));
        String[] familys = new String[]{new String(fam0), new String(fam1), new String(fam2)};
        boolean table1IsNew = TestAtomicOpsWithNullValue.creatTable(tableName1, familys, conf);
        HTable ht1 = new HTable(conf, tableName1);
        Scan simplescan = new Scan();
        if (!table1IsNew) {
            ResultScanner rs1 = ht1.getScanner(simplescan);
            for (Result result : rs1) {
                ht1.delete(new Delete(result.getRow()));
            }
            rs1.close();
        }
        Put put0 = new Put(row0);
        put0.add(fam0, qual0, r0val00);
        put0.add(fam0, qual1, r0val01);
        put0.add(fam0, qual2, r0val02);
        put0.add(fam1, qual0, r0val10);
        put0.add(fam1, qual1, r0val11);
        put0.add(fam1, qual2, r0val12);
        put0.add(fam2, qual0, r0val20);
        put0.add(fam2, qual1, r0val21);
        put0.add(fam2, qual2, r0val22);
        Put put1 = new Put(row1);
        put1.add(fam0, qual0, r1val00);
        put1.add(fam0, qual1, r1val01);
        put1.add(fam0, qual2, r1val02);
        put1.add(fam1, qual0, r1val10);
        put1.add(fam1, qual1, r1val11);
        put1.add(fam2, qual0, r1val20);
        Put put2 = new Put(row2);
        put2.add(fam0, qual0, binval);
        put2.add(fam0, qual1, valempty);
        ht1.put(put0);
        ht1.put(put1);
        ht1.put(put2);
        ht1.flushCommits();
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        System.out.println("After populated data to table " + tableName1);
        byte[] chgr1val12 = Bytes.toBytes((String)"chg-r1-v12: this should not be added");
        RowMutations rm112 = new RowMutations(row1);
        Put chgput112 = new Put(row1);
        chgput112.add(fam1, qual2, chgr1val12);
        rm112.add(chgput112);
        RowMutations rm100 = new RowMutations(row1);
        Put chgput100 = new Put(row1);
        chgput100.add(fam0, qual0, chgr1val00);
        rm100.add(chgput100);
        RowMutations rm101 = new RowMutations(row1);
        Put chgput101 = new Put(row1);
        chgput101.add(fam0, qual1, chgr1val01);
        rm101.add(chgput101);
        byte[] chgr1val01b = Bytes.toBytes((String)"This should not be added for row1:fam0:qual1");
        RowMutations rm101b = new RowMutations(row1);
        Put chgput101b = new Put(row1);
        chgput101b.add(fam0, qual1, chgr1val01b);
        rm101b.add(chgput101b);
        RowMutations rm102 = new RowMutations(row1);
        Put chgput102 = new Put(row1);
        chgput102.add(fam0, qual2, chgr1val02);
        rm102.add(chgput102);
        byte[] chgrxval00 = Bytes.toBytes((String)"This will be added then deleted");
        RowMutations rmx00 = new RowMutations(rowx);
        Put chgputx00 = new Put(rowx);
        chgputx00.add(fam0, qual0, chgrxval00);
        rmx00.add(chgputx00);
        RowMutations rmx00d = new RowMutations(rowx);
        Delete del00 = new Delete(rowx);
        rmx00d.add(del00);
        System.out.println("\n========Test1: checkandmutate with not-exist family ========");
        boolean ret1 = ht1.checkAndMutate(row1, famx, qual1, CompareFilter.CompareOp.EQUAL, null, rm100);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])famx) + ":" + Bytes.toStringBinary((byte[])qual1) + ") input family does not exist, this is an error case, should NOT apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val00) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (!ret1);
        System.out.println("\n========Test2: checkandmutate with exist family, qualifier and value ========");
        ret1 = ht1.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.EQUAL, null, rm100);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") has value " + Bytes.toStringBinary((byte[])r1val11) + ", input value is null, operator is EQUAL, should NOT apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val00) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (!ret1);
        System.out.println("\n========Test3: checkandmutate with exist family, qualifier and value ========");
        ret1 = ht1.checkAndMutate(row1, fam1, qual1, CompareFilter.CompareOp.NOT_EQUAL, null, rm100);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qual1) + ") has value " + Bytes.toStringBinary((byte[])r1val11) + ", input value is null, operator is NOT_EQUAL, should apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val00) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (ret1);
        System.out.println("\n========Test4: checkandmutate with not-exist qualifier ========");
        ret1 = ht1.checkAndMutate(row1, fam1, qualx, CompareFilter.CompareOp.EQUAL, null, rm101);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qualx) + ") input qualifier does not exist, should apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val01) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (ret1);
        System.out.println("\n========Test5: checkandmutate with not-exist qualifier ========");
        ret1 = ht1.checkAndMutate(row1, fam1, qualx, CompareFilter.CompareOp.NOT_EQUAL, null, rm101b);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])row1) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qualx) + ") input qualifier does not exist, the comparator is NOT_EQUAL, should NOT apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val01b) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (!ret1);
        System.out.println("\n========Test6: checkandmutate with not-exist row ========");
        ret1 = ht1.checkAndMutate(rowx, fam0, qualx, CompareFilter.CompareOp.EQUAL, null, rmx00);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])rowx) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + ") input row does not exist, should apply mutate put(" + Bytes.toStringBinary((byte[])chgrxval00) + "), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (ret1);
        System.out.println("\n========Test7: checkandmutate with not-exist row ========");
        ret1 = ht1.checkAndMutate(rowx, fam0, qualx, CompareFilter.CompareOp.EQUAL, null, rmx00d);
        System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])rowx) + ") fam:col(" + Bytes.toStringBinary((byte[])fam0) + ":" + Bytes.toStringBinary((byte[])qual0) + ") input qualifier does not exist, should apply mutate deletel), result=(" + ret1 + ")");
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (ret1);
        boolean throwerr = false;
        System.out.println("\n========Test8: checkandmutate on different row ========");
        try {
            ret1 = ht1.checkAndMutate(rowx, fam1, qualx, CompareFilter.CompareOp.EQUAL, null, rm101b);
        }
        catch (DoNotRetryIOException e) {
            throwerr = true;
            System.out.println("checkandmutate for key(" + Bytes.toStringBinary((byte[])rowx) + ") fam:col(" + Bytes.toStringBinary((byte[])fam1) + ":" + Bytes.toStringBinary((byte[])qualx) + ") input qualifier does not exist, the comparator is EQUAL,  however, the mutation is on key(" + Bytes.toStringBinary((byte[])row1) + "should NOT apply mutate put(" + Bytes.toStringBinary((byte[])chgr1val01b) + "), result=(" + ret1 + ")");
        }
        TestAtomicOpsWithNullValue.printscan(ht1, simplescan);
        assert (throwerr);
        ht1.close();
    }
}

