/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.CopyMetaHelper;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class TableUtil {
    public static void createTableForCopy(Configuration conf, String src, String dst, List<String> cfList, boolean useBulkLoad) throws IOException {
        Dbserver.TableAttr.Builder attrBuilder = Dbserver.TableAttr.newBuilder();
        attrBuilder.setBulkLoad(useBulkLoad);
        CopyMetaHelper.createTable(conf, src, dst, 15, attrBuilder.build(), cfList);
    }

    public static void clearBulkLoad(Configuration conf, String tableName) throws IOException {
        TableUtil.setBulkLoadAttr(conf, tableName, false);
    }

    private static void setBulkLoadAttr(Configuration conf, String tableName, boolean flag) throws IOException {
        Path tablePath = new Path(tableName);
        MapRFileSystem mfs = new MapRFileSystem();
        mfs.initialize(tablePath.toUri(), conf);
        Dbserver.TableAces aces = Dbserver.TableAces.newBuilder().build();
        Dbserver.TableAttr attr = Dbserver.TableAttr.newBuilder().setBulkLoad(flag).build();
        mfs.modifyTableAttr(tablePath, attr, aces);
        mfs.close();
    }

    public static List<String> getColumnFamiliesList(String columnSpec) {
        ArrayList<String> cfList = new ArrayList<String>();
        if (columnSpec != null) {
            String[] cols = columnSpec.split(",");
            String column = null;
            for (String col : cols) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    column = names[0];
                } else {
                    column = col;
                }
                if (cfList.contains(column)) continue;
                cfList.add(column);
            }
        }
        return cfList;
    }
}

