/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.tools.mapreduce.ClusterTablePath;
import com.mapr.fs.hbase.tools.mapreduce.RangeChecksumInputFormat;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class RangeChecksum
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(RangeChecksum.class);
    public static final String NAME = "ComputeChecksum";
    static String jobDisplayName = null;
    static long startTime = 0L;
    static long endTime = Long.MAX_VALUE;
    static String tableName = null;
    static String inputSplitKeyRangeFileName = null;
    static boolean needSplit = false;
    static String subKeyRangeFileName = null;
    static String includeKeyRangeFileName = null;
    static String columnSpec = null;
    static int maxVersions = Integer.MAX_VALUE;
    static String outputDir = "/difftablesOut";
    static boolean exit = false;
    static boolean diffChecksum = false;

    public static String getOutputPathName(String dir, String table) {
        return new String(dir + "/" + table.replace("/", "").replace(":", "") + ".checksum");
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, URISyntaxException {
        if (!RangeChecksum.doCommandLine(args)) {
            return null;
        }
        conf.set("ComputeChecksum.tableName", tableName);
        ClusterTablePath ctPath = ClusterTablePath.parse(tableName);
        if (ctPath.clusterName != null) {
            conf.set("fs.defaultFS", ctPath.getClusterUri().toString());
            String hsAddress = SegKeyRangeUtil.getServiceAddress(conf, ctPath.getClusterUri().toString(), "historyserver");
            String rmAddress = SegKeyRangeUtil.getServiceAddress(conf, ctPath.getClusterUri().toString(), "resourcemanager");
            if (rmAddress != null) {
                conf.set("yarn.resourcemanager.address", rmAddress);
            }
            if (hsAddress != null) {
                conf.set("mapreduce.jobhistory.address", hsAddress);
            }
            LOG.info((Object)("Job for table(" + tableName + ") will be submitted to cluster(" + ctPath.clusterName + ")"));
        } else {
            LOG.info((Object)("Job for table(" + tableName + ") will be submitted to local cluster."));
        }
        if (inputSplitKeyRangeFileName == null) {
            inputSplitKeyRangeFileName = outputDir + "/" + SegKeyRangeUtil.getTabletKeyFileName(tableName);
            SegKeyRangeUtil.writeTabletKeyRange(inputSplitKeyRangeFileName, tableName);
        }
        String segKeyDirName = outputDir + "/" + SegKeyRangeUtil.getSegKeyDirName(tableName);
        if (subKeyRangeFileName == null) {
            subKeyRangeFileName = outputDir + "/" + SegKeyRangeUtil.getSegKeyFileName(tableName);
            SegKeyRangeUtil.writeSegKeyRange(subKeyRangeFileName, tableName);
        }
        String outputSplitKeyRangeFileName = null;
        if (needSplit) {
            outputSplitKeyRangeFileName = outputDir + "/" + SegKeyRangeUtil.getReSplitedTabletKeyFileName(tableName);
            SegKeyRangeUtil.splitSubRegionKeysbyRegionKeys(inputSplitKeyRangeFileName, subKeyRangeFileName, outputSplitKeyRangeFileName, segKeyDirName);
        } else {
            outputSplitKeyRangeFileName = inputSplitKeyRangeFileName;
        }
        conf.set("KeyRangeDirName", segKeyDirName);
        conf.set("splitfilename", outputSplitKeyRangeFileName);
        if (includeKeyRangeFileName != null) {
            conf.set("includedregionfilename", includeKeyRangeFileName);
        }
        if (columnSpec != null) {
            conf.set("ComputeChecksum.columnSpec", columnSpec);
        }
        conf.setLong("ComputeChecksum.startTime", startTime);
        conf.setLong("ComputeChecksum.endTime", endTime);
        conf.setInt("ComputeChecksum.maxVersions", maxVersions);
        Job job = new Job(conf);
        if (jobDisplayName != null) {
            job.setJobName(jobDisplayName);
        } else {
            job.setJobName(NAME);
        }
        job.setJarByClass(RangeChecksum.class);
        Scan scan = SegKeyRangeUtil.buildScan(NAME, conf);
        TableMapReduceUtil.initTableMapperJob((String)tableName, (Scan)scan, RangeCheckSumMapper.class, ImmutableBytesWritable.class, LongWritable.class, (Job)job, (boolean)true, RangeChecksumInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(RangeChecksum.getOutputPathName(outputDir, tableName)));
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        job.setReducerClass(RangeCheckSumReducer.class);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setNumReduceTasks(1);
        return job;
    }

    static String[] convertFromDiffTablesArg(boolean useSrcTable, String splitKRFile, String subKRFile, String includeKRFile, String outChecksumDir, String inputJobDisplayName, String[] diffArgs) {
        if (diffArgs.length == 0 && splitKRFile == null && subKRFile == null && includeKRFile == null) {
            return new String[0];
        }
        if (subKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input sub key range file of checksum calculation is missing.");
        }
        if (includeKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input key range file of must-be-included regions is missing.");
        }
        boolean hasOutdir = false;
        ArrayList<String> rangeArgs = new ArrayList<String>();
        for (int i = 0; i < diffArgs.length; ++i) {
            String cmd = diffArgs[i];
            if (cmd.equalsIgnoreCase("-columns") || cmd.equalsIgnoreCase("-starttime") || cmd.equalsIgnoreCase("-endtime") || cmd.equalsIgnoreCase("-maxversions")) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add(cmd);
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("-src") && useSrcTable) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add("-table");
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (cmd.equalsIgnoreCase("-dst") && !useSrcTable) {
                if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
                rangeArgs.add("-table");
                rangeArgs.add(diffArgs[i + 1]);
                continue;
            }
            if (!cmd.equalsIgnoreCase("-outdir")) continue;
            if (!RangeChecksum.checkNextArg(diffArgs, i)) break;
            if (outChecksumDir != null) {
                rangeArgs.add(cmd);
                rangeArgs.add(outChecksumDir);
                hasOutdir = true;
                continue;
            }
            throw new IllegalArgumentException("Output directory " + diffArgs[i + 1] + " but not set in DiffTableWithCrc but not set in RangeChecksum");
        }
        if (splitKRFile != null) {
            rangeArgs.add("-split_keyrange");
            rangeArgs.add(splitKRFile);
        }
        if (includeKRFile != null) {
            rangeArgs.add("-keyrange_included");
            rangeArgs.add(includeKRFile);
        }
        if (subKRFile != null) {
            rangeArgs.add("-sub_keyrange");
            rangeArgs.add(subKRFile);
        }
        if (inputJobDisplayName != null) {
            rangeArgs.add("-job_name");
            rangeArgs.add(inputJobDisplayName);
        }
        if (outChecksumDir != null && !hasOutdir) {
            rangeArgs.add("-outdir");
            rangeArgs.add(outChecksumDir);
        }
        String[] retArr = new String[rangeArgs.size()];
        retArr = rangeArgs.toArray(retArr);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)rangeArgs.toString());
        }
        return retArr;
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length == 0) {
            return true;
        }
        if (args.length < 2) {
            RangeChecksum.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equalsIgnoreCase("-h") || cmd.startsWith("--h")) {
                    RangeChecksum.printUsage(null);
                    return false;
                }
                if (cmd.equalsIgnoreCase("-table")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    tableName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-split_keyrange")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    inputSplitKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-keyrange_included")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    includeKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-sub_keyrange")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    needSplit = true;
                    subKeyRangeFileName = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    columnSpec = args[i + 1];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-starttime")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    String startTimeStr = args[i + 1];
                    startTime = startTimeStr.equalsIgnoreCase("-INF") ? 0L : Long.parseLong(startTimeStr);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-endtime")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    String endTimeStr = args[i + 1];
                    endTime = endTimeStr.equalsIgnoreCase("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-maxversions")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    maxVersions = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-outdir")) {
                    if (!RangeChecksum.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[i + 1];
                    continue;
                }
                if (!cmd.equalsIgnoreCase("-job_name")) continue;
                if (!RangeChecksum.checkNextArg(args, i)) {
                    return false;
                }
                jobDisplayName = args[i + 1];
            }
            if (tableName == null) {
                RangeChecksum.printUsage(null);
                return false;
            }
            if (includeKeyRangeFileName != null && inputSplitKeyRangeFileName == null) {
                RangeChecksum.printUsage(null);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RangeChecksum.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length) {
            RangeChecksum.printUsage("Missing arguements after " + args[i]);
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hbase RangeChecksum -table tableName [options]. ");
        System.err.println("Notes: the output directory will contain the calculated checksum file.");
        System.err.println("Options:");
        System.err.println("  [-outdir <output_checksum_file_directory>] Chooses directory for \tChecksum output file. ");
        System.err.println("  [-split_keyrange <split_keyrange_file>] The key ranges that mapper task should be divided. If this is not provided, the program will use mapr tablets as the key ranges.");
        System.err.println("  [-keyrange_included <keyrange_included_file>] The key ranges that mapper task must run. The key ranges must be a subset of the key ranges in split_keyrange file.");
        System.err.println("[-columns cf1[:col1],...] compare list of columns.");
        System.err.println("[-starttime <starttime>, -endtime <endtime>] start & end are timestamps or dates in quotes. Only inspects rows & cols created during the given time interval. If end is missing, then its all time after start. If start is missing, then its all time before end.");
        System.err.println("[-maxversions] <max number of versions to generate checksum>");
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        Job job = RangeChecksum.createSubmittableJob(conf, args);
        int ret = 0;
        if (job != null) {
            ret = job.waitForCompletion(true) ? 0 : 1;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)conf, (Tool)new RangeChecksum(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    public static class RangeCheckSumReducer
    extends Reducer<ImmutableBytesWritable, LongWritable, ImmutableBytesWritable, LongWritable> {
        public void reduce(ImmutableBytesWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int i = 0;
            for (LongWritable val : values) {
                if (i == 0) {
                    context.write((Object)key, (Object)val);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("checksum for start key(" + Bytes.toStringBinary((byte[])key.get()) + "):(" + Long.toString(val.get()) + ")"));
                    }
                } else {
                    LOG.error((Object)("extra " + Integer.toString(i) + " checksum for start key(" + Bytes.toStringBinary((byte[])key.get()) + "):(" + Long.toString(val.get()) + ")"));
                }
                ++i;
            }
        }
    }

    public static class RangeCheckSumMapper
    extends TableMapper<ImmutableBytesWritable, LongWritable> {
        private boolean hasRows = false;
        private Checksum checksum = new PureJavaCrc32();
        private String keyRangeFileName = null;
        private String keyRangeDirName = null;
        private List<ImmutableBytesWritable> keysInThisMapper = null;
        private int cIdx = -1;
        private int nIdx = -1;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            TableSplit tableSplit = (TableSplit)context.getInputSplit();
            byte[] startRow = tableSplit.getStartRow();
            byte[] endRow = tableSplit.getEndRow();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Mapper Setup: startRow(" + Bytes.toStringBinary((byte[])startRow) + ") endRow(" + Bytes.toStringBinary((byte[])endRow) + ")"));
            }
            Configuration conf = context.getConfiguration();
            this.keyRangeDirName = conf.get("KeyRangeDirName", null);
            this.keyRangeFileName = startRow.length == 0 ? "neginf" : "k_" + Bytes.toStringBinary((byte[])startRow);
            this.keysInThisMapper = SegKeyRangeUtil.readKeyRange(conf, this.keyRangeDirName + "/" + this.keyRangeFileName);
            if (this.keysInThisMapper.size() == 0) {
                throw new IOException("No segment keys found for tablet with start at row (" + Bytes.toStringBinary((byte[])startRow) + ")");
            }
            if (!Bytes.equals((byte[])this.keysInThisMapper.get(0).get(), (byte[])startRow)) {
                throw new IOException("First segment key(" + Bytes.toStringBinary((byte[])this.keysInThisMapper.get(0).get()) + ") is NOT the tablet start key(" + Bytes.toStringBinary((byte[])startRow) + ")");
            }
            this.cIdx = 0;
            if (this.keysInThisMapper.size() > 1) {
                this.nIdx = 1;
            }
            this.checksum.reset();
        }

        public void updateChecksum(ImmutableBytesWritable row, Result result) {
            this.checksum.update(row.get(), 0, row.getSize());
            for (Cell c : result.rawCells()) {
                this.checksum.update(c.getRowArray(), c.getRowOffset(), c.getRowLength());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("row: " + Bytes.toStringBinary((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength())));
                }
                this.checksum.update(c.getFamilyArray(), c.getFamilyOffset(), c.getFamilyLength());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("column family: " + Bytes.toStringBinary((byte[])c.getFamilyArray(), (int)c.getFamilyOffset(), (int)c.getFamilyLength())));
                }
                this.checksum.update(c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("column qualifier: " + Bytes.toStringBinary((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength())));
                }
                byte[] tsbytes = ByteBuffer.allocate(64).putLong(c.getTimestamp()).array();
                this.checksum.update(tsbytes, 0, 64);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("timestamp: " + Bytes.toStringBinary((byte[])tsbytes)));
                }
                this.checksum.update(c.getValueArray(), c.getValueOffset(), c.getValueLength());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("value: " + Bytes.toStringBinary((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength())));
            }
        }

        public void map(ImmutableBytesWritable row, Result result, Mapper.Context context) throws IOException, InterruptedException {
            if (!this.hasRows) {
                this.hasRows = true;
            }
            if (Bytes.compareTo((byte[])this.keysInThisMapper.get(this.cIdx).get(), (byte[])row.get()) > 0) {
                throw new IOException("Row(" + Bytes.toStringBinary((byte[])row.get()) + ") is larger that its segment start key(" + Bytes.toStringBinary((byte[])this.keysInThisMapper.get(this.cIdx).get()) + ")");
            }
            if (this.nIdx != -1 && Bytes.compareTo((byte[])this.keysInThisMapper.get(this.nIdx).get(), (byte[])row.get()) <= 0) {
                context.write((Object)this.keysInThisMapper.get(this.cIdx), (Object)new LongWritable(this.checksum.getValue()));
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Segment with start key: " + Bytes.toStringBinary((byte[])this.keysInThisMapper.get(this.cIdx).get()) + ", checksum: " + this.checksum.toString()));
                }
                this.checksum.reset();
                ++this.cIdx;
                if (this.cIdx >= this.keysInThisMapper.size()) {
                    throw new IOException("No more segments to cover row(" + Bytes.toStringBinary((byte[])row.get()) + ")");
                }
                this.nIdx = this.cIdx + 1;
                if (this.nIdx == this.keysInThisMapper.size()) {
                    this.nIdx = -1;
                }
                this.updateChecksum(row, result);
            } else {
                this.updateChecksum(row, result);
            }
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (!this.hasRows) {
                LOG.info((Object)"This Split does not contain any row, will log default checksum for empty segment");
            }
            context.write((Object)this.keysInThisMapper.get(this.cIdx), (Object)new LongWritable(this.checksum.getValue()));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Segment with start key: " + Bytes.toStringBinary((byte[])this.keysInThisMapper.get(this.cIdx).get()) + ", checksum: " + this.checksum.toString()));
            }
            this.cIdx = -1;
            this.nIdx = -1;
            this.checksum.reset();
        }
    }
}

