/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.tools.mapreduce.ClusterTablePath;
import com.mapr.fs.hbase.tools.mapreduce.DiffTables;
import com.mapr.fs.hbase.tools.mapreduce.DiffTablesMeta;
import com.mapr.fs.hbase.tools.mapreduce.RangeChecksum;
import com.mapr.fs.hbase.tools.mapreduce.SegKeyRangeUtil;
import com.mapr.security.JNISecurity;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DiffTablesWithCrc
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(DiffTablesWithCrc.class);
    public final int NumThreads = 16;
    public static final String NAME = "Difftableswithcrc";
    public static final String SrcChecksumJobNAME = "DiffTablesComputeSrcChecksum";
    public static final String DstChecksumJobNAME = "DiffTablesComputeDstChecksum";
    public static String outputDir = null;
    public static String outputDiffCrcDir = null;
    public static String outputFileLocation = null;
    static long startTime = 0L;
    static long endTime = Long.MAX_VALUE;
    static String srcTableName = null;
    static String dstTableName = null;
    static ClusterTablePath outputDirCTPath = null;
    static ClusterTablePath srcCTPath = null;
    static ClusterTablePath dstCTPath = null;
    static String columnSpec = null;
    static int maxVersions = Integer.MAX_VALUE;
    static boolean exitOnFirstDiff = false;
    static String inputRegionKeyFile = null;
    static String inputSubRegionKeyFile = null;
    static List<ImmutableBytesWritable> mismatchedStartKeys = null;

    public static void compareChecksum(String srcFileUri, String dstFileUri, String mismatchedFile) throws IOException {
        Configuration srcConf = new Configuration();
        Configuration dstConf = new Configuration();
        Configuration localConf = new Configuration();
        Path srcPath = new Path(srcFileUri);
        Path dstPath = new Path(dstFileUri);
        SequenceFile.Reader srcReader = new SequenceFile.Reader(srcConf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)srcPath)});
        SequenceFile.Reader dstReader = new SequenceFile.Reader(dstConf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)dstPath)});
        Path mismatchedFilePath = new Path(mismatchedFile);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)localConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)mismatchedFilePath), SequenceFile.Writer.keyClass(ImmutableBytesWritable.class), SequenceFile.Writer.valueClass(NullWritable.class)});
        ImmutableBytesWritable srcKey = new ImmutableBytesWritable();
        LongWritable srcVal = new LongWritable();
        ImmutableBytesWritable dstKey = new ImmutableBytesWritable();
        LongWritable dstVal = new LongWritable();
        boolean srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
        boolean dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        while (srcHasNext && dstHasNext) {
            int cmpret = Bytes.compareTo((byte[])srcKey.get(), (byte[])dstKey.get());
            if (cmpret < 0) {
                LOG.info((Object)(srcFileUri + " has an extra key range with start key (" + Bytes.toStringBinary((byte[])srcKey.get()) + ")"));
                writer.append((Writable)srcKey, (Writable)NullWritable.get());
                srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
                continue;
            }
            if (cmpret > 0) {
                LOG.info((Object)(dstFileUri + " has an extra key range with start key (" + Bytes.toStringBinary((byte[])dstKey.get()) + ")"));
                writer.append((Writable)dstKey, (Writable)NullWritable.get());
                dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
                continue;
            }
            if (!srcVal.equals((Object)dstVal)) {
                LOG.info((Object)(dstFileUri + " checksum(" + srcVal.toString() + ") and " + srcFileUri + "  checksum(" + dstVal.toString() + ") are different for range start key (" + Bytes.toStringBinary((byte[])srcKey.get()) + ")"));
                writer.append((Writable)srcKey, (Writable)NullWritable.get());
            }
            srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
            dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        }
        while (srcHasNext) {
            LOG.info((Object)(srcFileUri + " has an extra key range with start key " + Bytes.toStringBinary((byte[])srcKey.get())));
            writer.append((Writable)srcKey, (Writable)NullWritable.get());
            srcHasNext = srcReader.next((Writable)srcKey, (Writable)srcVal);
        }
        while (dstHasNext) {
            LOG.info((Object)(dstFileUri + " has an extra key range with start key " + Bytes.toStringBinary((byte[])dstKey.get())));
            writer.append((Writable)dstKey, (Writable)NullWritable.get());
            dstHasNext = dstReader.next((Writable)dstKey, (Writable)dstVal);
        }
        writer.close();
        srcReader.close();
        dstReader.close();
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length <= 0) {
            DiffTablesWithCrc.printUsage(null);
            return false;
        }
        try {
            String master = null;
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equalsIgnoreCase("-h") || cmd.startsWith("--h")) {
                    DiffTablesWithCrc.printUsage(null);
                    return false;
                }
                if (cmd.equalsIgnoreCase("-src")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    srcTableName = args[++i];
                    srcCTPath = ClusterTablePath.parse(srcTableName);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-dst")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    dstTableName = args[++i];
                    dstCTPath = ClusterTablePath.parse(dstTableName);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-columns")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    columnSpec = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-starttime")) {
                    String startTimeStr;
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    startTime = (startTimeStr = args[++i]).equalsIgnoreCase("-INF") ? 0L : Long.parseLong(startTimeStr);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-endtime")) {
                    String endTimeStr;
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    endTime = (endTimeStr = args[++i]).equalsIgnoreCase("INF") ? Long.MAX_VALUE : Long.parseLong(endTimeStr);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-maxversions")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    maxVersions = Integer.parseInt(args[++i]);
                    continue;
                }
                if (cmd.equalsIgnoreCase("-outdir")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    outputDir = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-first_exit")) {
                    exitOnFirstDiff = true;
                    continue;
                }
                if (cmd.equalsIgnoreCase("-master")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    master = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-useRegionKeyFile")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    inputRegionKeyFile = args[++i];
                    continue;
                }
                if (cmd.equalsIgnoreCase("-useSubRegionKeyFile")) {
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    inputSubRegionKeyFile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-mapreduce")) {
                    String isMapreduce;
                    if (!DiffTablesWithCrc.checkNextArg(args, i)) {
                        return false;
                    }
                    if (!(isMapreduce = args[++i]).equalsIgnoreCase("false")) continue;
                    DiffTablesWithCrc.printUsage("Non-mapreduce version is not supported.");
                    return false;
                }
                if (args[i].equalsIgnoreCase("-cmpmeta")) {
                    ++i;
                    continue;
                }
                DiffTablesWithCrc.printUsage("unrecognized argument " + args[i]);
                return false;
            }
            if (srcTableName == null) {
                DiffTablesWithCrc.printUsage("Missing -src.");
                return false;
            }
            if (dstTableName == null) {
                DiffTablesWithCrc.printUsage("Missing -dst.");
                return false;
            }
            Configuration conf = HBaseConfiguration.create();
            MapRFileSystem mfs = (MapRFileSystem)FileSystem.get((Configuration)conf);
            if (!mfs.isTable(new Path(srcTableName))) {
                DiffTablesWithCrc.printUsage("Table " + srcTableName + " does not exist.");
                return false;
            }
            if (!mfs.isTable(new Path(dstTableName))) {
                DiffTablesWithCrc.printUsage("Table " + dstTableName + " does not exist.");
                return false;
            }
            if (ClusterTablePath.equal(srcCTPath, dstCTPath)) {
                System.out.println("The tables match. " + srcTableName + " and " + dstTableName + " are the same table.");
                System.exit(0);
            }
            if (startTime < 0L) {
                DiffTablesWithCrc.printUsage("starttime (" + startTime + ") cannot be negative.");
                return false;
            }
            if (endTime < 0L) {
                DiffTablesWithCrc.printUsage("endtime (" + endTime + ") cannot be negative.");
                return false;
            }
            if (startTime > endTime) {
                DiffTablesWithCrc.printUsage("endtime is smaller than starttime.");
                return false;
            }
            if (master != null && !master.equalsIgnoreCase("src") && !master.equalsIgnoreCase("dst")) {
                DiffTablesWithCrc.printUsage("-master should be given as either src or dst");
                return false;
            }
            if (maxVersions < 0) {
                DiffTablesWithCrc.printUsage("maxVersions (" + maxVersions + ") cannot be negative.");
                return false;
            }
            if (outputDir == null) {
                DiffTablesWithCrc.printUsage("Missing -outdir");
                return false;
            }
            outputDirCTPath = ClusterTablePath.parse(outputDir);
            if (SegKeyRangeUtil.checkPathExists(conf, outputDirCTPath)) {
                DiffTablesWithCrc.printUsage("Output directory " + outputDir + " already exists");
                return false;
            }
            outputDiffCrcDir = SegKeyRangeUtil.getTmpDirName(conf) + outputDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            DiffTablesWithCrc.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean checkNextArg(String[] args, int i) {
        if (i + 1 >= args.length || args[i + 1].matches("-[cdefmnosu][a-zA-Z_]*")) {
            DiffTablesWithCrc.printUsage("Missing argument after " + args[i]);
            return false;
        }
        return true;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: hbase com.mapr.fs.hbase.tools.mapreduce.DiffTablesWithCrc \n-src <source table path>\n-dst <destination table path>\n-outdir <output directory>\n[-master <src|dst> ] The master table to use for the diff.\n[-first_exit] Exit when first difference is found.\n[-columns <comma separated list of family[:column]> ]\n[-starttime <start diff at timestamp>]\n[-endtime <end diff at timestamp>]\n[-maxversions] <max number of versions to copy>\n[-cmpmeta <true|false> (default: true)]\n");
    }

    public int run(String[] args) throws Exception {
        int ret;
        Job dstJob;
        Job srcJob;
        Path dstOutDiffCrcDirPath;
        FileSystem dstFs;
        Path srcOutDiffCrcDirPath;
        FileSystem srcFs;
        Configuration conf = this.getConf();
        String srcTableNameWithoutSpecialChar = ((DiffTablesWithCrc.srcCTPath.clusterName == null ? "" : DiffTablesWithCrc.srcCTPath.clusterName) + DiffTablesWithCrc.srcCTPath.tablePathName).replace("/", "").replace(":", "");
        String dstTableNameWithoutSpecialChar = ((DiffTablesWithCrc.dstCTPath.clusterName == null ? "" : DiffTablesWithCrc.dstCTPath.clusterName) + DiffTablesWithCrc.dstCTPath.tablePathName).replace("/", "").replace(":", "");
        String srcOutDiffCrcDirName = srcCTPath.getClusterUri().toString() + outputDiffCrcDir;
        Configuration srcConf = HBaseConfiguration.create();
        String srcFullClusterName = srcCTPath.getClusterUri().toString();
        if (srcFullClusterName != null) {
            srcConf.set("fs.defaultFS", srcFullClusterName);
        }
        if ((srcFs = (srcOutDiffCrcDirPath = new Path(srcOutDiffCrcDirName)).getFileSystem(srcConf)).exists(srcOutDiffCrcDirPath)) {
            srcFs.delete(srcOutDiffCrcDirPath, true);
        }
        String srcKeyRangeDirName = new String(srcOutDiffCrcDirName + "/" + srcTableNameWithoutSpecialChar + ".keyrange");
        String srcRegionKeyFilePathName = srcKeyRangeDirName + "/" + SegKeyRangeUtil.getTabletKeyFileName(srcTableNameWithoutSpecialChar);
        String srcSubRegionKeyFilePathName = srcKeyRangeDirName + "/" + SegKeyRangeUtil.getSegKeyFileName(srcTableNameWithoutSpecialChar);
        String dstOutDiffCrcDirName = dstCTPath.getClusterUri().toString() + outputDiffCrcDir;
        Configuration dstConf = HBaseConfiguration.create();
        String dstFullClusterName = dstCTPath.getClusterUri().toString();
        if (dstFullClusterName != null) {
            dstConf.set("fs.defaultFS", dstFullClusterName);
        }
        if ((dstFs = (dstOutDiffCrcDirPath = new Path(dstOutDiffCrcDirName)).getFileSystem(dstConf)).exists(dstOutDiffCrcDirPath)) {
            dstFs.delete(dstOutDiffCrcDirPath, true);
        }
        String dstKeyRangeDirName = new String(dstOutDiffCrcDirName + "/" + dstTableNameWithoutSpecialChar + ".keyrange");
        String dstRegionKeyFilePathName = dstKeyRangeDirName + "/" + SegKeyRangeUtil.getTabletKeyFileName(dstTableNameWithoutSpecialChar);
        String dstSubRegionKeyFilePathName = dstKeyRangeDirName + "/" + SegKeyRangeUtil.getSegKeyFileName(dstTableNameWithoutSpecialChar);
        String diffTableOutDirPathName = outputDir;
        LOG.info((Object)("DiffTables output directory:" + diffTableOutDirPathName + "\nsrc side key range directory:" + srcKeyRangeDirName + ", mapper job split region file:" + srcRegionKeyFilePathName + ", checksum calculation subregion file:" + srcSubRegionKeyFilePathName + "\ndst side key range directory:" + dstKeyRangeDirName + ", mapper job split region file:" + dstRegionKeyFilePathName + ", checksum calculation subregion file:" + dstSubRegionKeyFilePathName));
        outputFileLocation = "DiffTables output are located at " + diffTableOutDirPathName + "\nsource table checksum output are located at " + srcOutDiffCrcDirName + "\ndestination table checksum output are located at " + dstOutDiffCrcDirName;
        if (inputRegionKeyFile != null) {
            SegKeyRangeUtil.copyKeyRangeFile(conf, inputRegionKeyFile, conf, srcRegionKeyFilePathName);
            SegKeyRangeUtil.copyKeyRangeFile(conf, inputRegionKeyFile, conf, dstRegionKeyFilePathName);
        } else {
            SegKeyRangeUtil.writeTabletKeyRange(srcRegionKeyFilePathName, srcTableName);
            SegKeyRangeUtil.writeTabletKeyRange(dstRegionKeyFilePathName, dstTableName);
        }
        if (inputSubRegionKeyFile != null) {
            SegKeyRangeUtil.copyKeyRangeFile(conf, inputSubRegionKeyFile, conf, srcSubRegionKeyFilePathName);
            SegKeyRangeUtil.copyKeyRangeFile(conf, inputSubRegionKeyFile, conf, dstSubRegionKeyFilePathName);
        } else {
            SegKeyRangeUtil.writeSegKeyRange(srcSubRegionKeyFilePathName, srcTableName);
            SegKeyRangeUtil.copyKeyRangeFile(conf, srcSubRegionKeyFilePathName, conf, dstSubRegionKeyFilePathName);
        }
        String localCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        boolean isSecureCluster = JNISecurity.IsSecurityEnabled((String)localCluster);
        LOG.info((Object)(localCluster + " is " + (isSecureCluster ? "" : "not ") + "secure cluster."));
        if (isSecureCluster) {
            srcConf.setBoolean("fs.maprfs.impl.disable.cache", true);
            dstConf.setBoolean("fs.maprfs.impl.disable.cache", true);
        }
        String srcChecksumDirUri = srcOutDiffCrcDirName;
        String[] srcRCArgs = RangeChecksum.convertFromDiffTablesArg(true, srcRegionKeyFilePathName, srcSubRegionKeyFilePathName, null, srcChecksumDirUri, SrcChecksumJobNAME, args);
        String dstChecksumDirUri = dstOutDiffCrcDirName;
        String[] dstRCArgs = RangeChecksum.convertFromDiffTablesArg(false, dstRegionKeyFilePathName, dstSubRegionKeyFilePathName, null, dstChecksumDirUri, DstChecksumJobNAME, args);
        if (DiffTablesWithCrc.srcCTPath.clusterName != null && DiffTablesWithCrc.srcCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
            CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.srcCTPath.clusterName);
        }
        if ((srcJob = RangeChecksum.createSubmittableJob(srcConf, srcRCArgs)) == null) {
            LOG.error((Object)("Failed to create job on cluster " + (DiffTablesWithCrc.srcCTPath.clusterName == null ? "local" : DiffTablesWithCrc.srcCTPath.clusterName)));
            return 1;
        }
        srcJob.submit();
        if (DiffTablesWithCrc.dstCTPath.clusterName != null) {
            if (DiffTablesWithCrc.dstCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.dstCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        if ((dstJob = RangeChecksum.createSubmittableJob(dstConf, dstRCArgs)) == null) {
            LOG.error((Object)("Failed to create job on cluster " + (DiffTablesWithCrc.dstCTPath.clusterName == null ? "local" : DiffTablesWithCrc.dstCTPath.clusterName)));
            return 1;
        }
        dstJob.submit();
        if (DiffTablesWithCrc.srcCTPath.clusterName != null) {
            if (DiffTablesWithCrc.srcCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.srcCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        int n = ret = srcJob.waitForCompletion(true) ? 0 : 1;
        if (ret != 0) {
            LOG.error((Object)("Wait for job to complete failed on cluster " + (DiffTablesWithCrc.srcCTPath.clusterName == null ? "local" : DiffTablesWithCrc.srcCTPath.clusterName)));
            return ret;
        }
        if (DiffTablesWithCrc.dstCTPath.clusterName != null) {
            if (DiffTablesWithCrc.dstCTPath.clusterName.compareTo(CLDBRpcCommonUtils.getInstance().getCurrentClusterName()) != 0) {
                CLDBRpcCommonUtils.getInstance().setCurrentClusterName(DiffTablesWithCrc.dstCTPath.clusterName);
            }
        } else {
            CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        }
        int n2 = ret = dstJob.waitForCompletion(true) ? 0 : 1;
        if (ret != 0) {
            LOG.error((Object)("Wait for job to complete failed on cluster " + (DiffTablesWithCrc.dstCTPath.clusterName == null ? "local" : DiffTablesWithCrc.dstCTPath.clusterName)));
            return ret;
        }
        CLDBRpcCommonUtils.getInstance().resetCurrentClusterName();
        String srcChecksumFileUri = RangeChecksum.getOutputPathName(srcChecksumDirUri, srcTableName) + "/part-r-00000";
        String destChecksumFileUri = RangeChecksum.getOutputPathName(dstChecksumDirUri, dstTableName) + "/part-r-00000";
        String mismatchedPathName = new String(outputDiffCrcDir + "/" + ((DiffTablesWithCrc.srcCTPath.clusterName == null ? "" : DiffTablesWithCrc.srcCTPath.clusterName) + DiffTablesWithCrc.srcCTPath.tablePathName).replace("/", "").replace(":", "") + ((DiffTablesWithCrc.dstCTPath.clusterName == null ? "" : DiffTablesWithCrc.dstCTPath.clusterName) + DiffTablesWithCrc.dstCTPath.tablePathName).replace("/", "").replace(":", "") + ".mismatchedkeyrange");
        LOG.info((Object)("srcChecksumFileUri=(" + srcChecksumFileUri + "), destChecksumFileUri=(" + destChecksumFileUri + "), mismatchedPathName=(" + mismatchedPathName + "), diffTableOutDirPathName =(" + diffTableOutDirPathName + ")"));
        DiffTablesWithCrc.compareChecksum(srcChecksumFileUri, destChecksumFileUri, mismatchedPathName);
        List<ImmutableBytesWritable> mismatchedStartKeys = SegKeyRangeUtil.readKeyRange(conf, new Path(mismatchedPathName));
        if (mismatchedStartKeys.isEmpty()) {
            LOG.info((Object)"Succeed. Checksum for each range matches, skip row by row comparison. ");
            SegKeyRangeUtil.writeStringToFile(conf, "", diffTableOutDirPathName + "/" + "_SUCCESS");
            return 0;
        }
        String[] diffRangeArgs = DiffTables.convertFromDiffTablesArg(diffTableOutDirPathName, srcSubRegionKeyFilePathName, mismatchedPathName, args);
        if (!DiffTables.doCommandLine(diffRangeArgs)) {
            System.exit(1);
        }
        try {
            Configuration diffTableConf = new Configuration();
            if (isSecureCluster) {
                diffTableConf.setBoolean("fs.maprfs.impl.disable.cache", true);
            }
            ret = ToolRunner.run((Configuration)diffTableConf, (Tool)new DiffTables(), (String[])diffRangeArgs);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        if (ret != 0) {
            LOG.error((Object)"DiffTables job failed on this cluster.");
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int ret;
        block8: {
            Configuration conf = HBaseConfiguration.create();
            ret = 0;
            try {
                if (!DiffTablesWithCrc.doCommandLine(args)) {
                    System.exit(1);
                }
                if ((ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTablesMeta(true), (String[])args)) == 1) {
                    System.out.println("ERROR: Metadata is different.");
                    System.out.println("To skip metadata comparison, use the option -cmpmeta false.");
                    System.exit(ret);
                } else if (ret == 3) {
                    System.out.println("Skip Metadata test.");
                } else if (ret == 0) {
                    System.out.println("DiffTablesMeta completed. Metadata of the two tables is same.");
                }
                ret = ToolRunner.run((Configuration)conf, (Tool)new DiffTablesWithCrc(), (String[])args);
            }
            catch (Exception e) {
                ret = 1;
                e.printStackTrace();
                if (outputFileLocation == null) break block8;
                System.err.println(outputFileLocation);
            }
        }
        System.exit(ret);
    }
}

