/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestResultConverter {
    private static final byte[] ROW = "row2".getBytes();
    static String time = "TIME";

    public static void main(String[] args) throws Exception {
        boolean shouldGet;
        boolean shouldScan;
        Get g;
        boolean shouldInc;
        Get g2;
        Configuration conf = HBaseConfiguration.create();
        String tableName = "/mytableinc";
        HTableDescriptor des = new HTableDescriptor(tableName.getBytes());
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (!admin.tableExists(tableName)) {
            for (int i = 0; i < 10; ++i) {
                des.addFamily(new HColumnDescriptor("f" + i));
            }
            try {
                admin.createTable(des);
            }
            catch (TableExistsException i) {
                // empty catch block
            }
        }
        HTable table = new HTable(conf, tableName);
        boolean shouldAppend = true;
        boolean shouldPut = true;
        Result result = null;
        if (shouldPut) {
            int valLen = shouldAppend ? 7 : 8;
            Random rand = new Random();
            Put p = new Put(ROW);
            for (int i = 0; i < 10; ++i) {
                byte[] value = Arrays.copyOfRange(Bytes.toBytes((long)(((long)i << 56) + 0x1000000000000L + 1L)), 0, valLen);
                p.add(new String("f" + i).getBytes(), ("c1f" + i).getBytes(), value);
                if (rand.nextInt(3) == 0) {
                    value = Arrays.copyOfRange(Bytes.toBytes((long)(((long)i << 56) + 0x2000000000000L + 1L)), 0, valLen);
                    p.add(("f" + i).getBytes(), ("c2f" + i).getBytes(), value);
                }
                if (rand.nextInt(3) == 0) {
                    value = Arrays.copyOfRange(Bytes.toBytes((long)(((long)i << 56) + 0x3000000000000L + 1L)), 0, valLen);
                    p.add(("f" + i).getBytes(), ("c3f" + i).getBytes(), value);
                }
                if (rand.nextInt(3) != 0) continue;
                value = Arrays.copyOfRange(Bytes.toBytes((long)(((long)i << 56) + 1L)), 0, valLen);
                p.add(("f" + i).getBytes(), null, value);
            }
            table.put(p);
            System.out.println("did put in " + tableName);
            table.flushCommits();
            Get g3 = new Get(ROW);
            result = table.get(g3);
            if (!result.isEmpty()) {
                System.out.println("After put:");
                TestResultConverter.printResult(result);
            }
        }
        if (shouldAppend && !(result = table.get(g2 = new Get(ROW))).isEmpty()) {
            Append append = new Append(ROW);
            for (KeyValue cell : result.raw()) {
                append.add(cell.getFamily(), cell.getQualifier(), new byte[]{1});
            }
            result = table.append(append);
            System.out.println("After append:");
            TestResultConverter.printResult(result);
        }
        if ((shouldInc = true) && !(result = table.get(g = new Get(ROW))).isEmpty()) {
            Increment inc = new Increment(ROW);
            for (KeyValue cell : result.raw()) {
                inc.addColumn(cell.getFamily(), cell.getQualifier(), 1L);
            }
            result = table.increment(inc);
            System.out.println("After increment:");
            TestResultConverter.printResult(result);
        }
        if (shouldScan = true) {
            Scan scan = new Scan();
            scan.setMaxVersions();
            ResultScanner scanner = table.getScanner(scan);
            while ((result = scanner.next()) != null) {
                System.out.println("Scan result for row: " + Bytes.toStringBinary((byte[])result.getRow()));
                TestResultConverter.printResult(result);
            }
            scanner.close();
        }
        if (shouldGet = true) {
            Get g4 = new Get(ROW);
            g4.setMaxVersions();
            result = table.get(g4);
            System.out.println("Get result:");
            TestResultConverter.printResult(result);
            Cell[] cells = result.rawCells();
            Result newResult = Result.create((Cell[])cells);
            Result.compareResults((Result)result, (Result)newResult);
        }
        table.close();
        admin.close();
    }

    public static void printResult(Result result) {
        KeyValue[] kvs = result.raw();
        for (int i = 0; i < kvs.length; ++i) {
            System.out.println(String.format("coulmn => %s:%s\t timestamp => %d\tvalue => %s", Bytes.toString((byte[])kvs[i].getFamily()), Bytes.toString((byte[])kvs[i].getQualifier()), kvs[i].getTimestamp(), Bytes.toStringBinary((byte[])kvs[i].getValue())));
        }
    }
}

