/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.hbase.HRegionConverter;
import com.mapr.fs.hbase.HTableProperties;
import com.mapr.fs.hbase.MapRDBConstants;
import com.mapr.fs.hbase.SchemaHelper;
import com.mapr.fs.jni.IOExceptionWithErrorCode;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.tables.CFPermissions;
import com.mapr.fs.tables.MapRAdmin;
import com.mapr.fs.tables.TableProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseAdminImpl
extends AbstractHBaseAdmin
implements MapRDBConstants {
    public static int MaxTableCreateRetryCount;
    private static final Log LOG;
    private volatile MapRAdmin maprAdmin_;
    private volatile MapRFileSystem maprfilesystem_;
    private final BaseTableMappingRules tableMappingRule_;
    private final Configuration configuration_;
    private User user_ = null;
    public static String FIRST_JSON_COL_FAMILY;
    private static boolean maprDaemonEnvVariableChecked;
    private static boolean maprDaemonProcess;

    public HBaseAdminImpl(Configuration c, BaseTableMappingRules tableMappingRule) {
        this.configuration_ = c;
        this.tableMappingRule_ = tableMappingRule;
    }

    public synchronized void close() throws IOException {
        if (this.maprfilesystem_ != null) {
            this.maprfilesystem_.close();
            this.maprfilesystem_ = null;
        }
    }

    public void setUser(User user) {
        this.user_ = user;
    }

    public boolean tableExists(String tablePath) throws IOException {
        return this.maprfs().isTable(this.getTablePath(tablePath));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables(null);
    }

    public HTableDescriptor[] listTables(String lookupPattern) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                descriptors.add(SchemaHelper.toHTableDescriptor(this.maprfs(), status[i].getPath(), lookupPattern == null || !lookupPattern.contains("/")));
            }
        }
        return descriptors.toArray(new HTableDescriptor[descriptors.size()]);
    }

    public TableName[] listTableNames() throws IOException {
        return this.listTableNames(null);
    }

    public TableName[] listTableNames(String lookupPattern) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        FileStatus[] status = this.doListTables(lookupPattern);
        if (status != null && status.length > 0) {
            for (int i = 0; i < status.length; ++i) {
                if (lookupPattern == null || !lookupPattern.contains("/")) {
                    tableNames.add(TableName.valueOf((String)status[i].getPath().getName()));
                    continue;
                }
                tableNames.add(TableName.valueOf((String)status[i].getPath().toUri().getPath()));
            }
        }
        return tableNames.toArray(new TableName[tableNames.size()]);
    }

    protected FileStatus[] doListTables(String lookupPath) throws IOException {
        String name;
        Path path = null;
        String checkPattern = null;
        if (lookupPath == null || lookupPath.length() == 0 || lookupPath.equals(".*")) {
            path = this.tableMappingRule_.getDefaultTablePath();
            if (!this.maprfs().exists(path)) {
                throw new IOException("doListTables() called for default path(" + path.toUri().getPath() + "), but it does not exists.");
            }
        } else {
            int lio_slash = lookupPath.lastIndexOf("/");
            String origLookup = lookupPath;
            boolean isDir = false;
            try {
                path = this.getTablePath(lookupPath);
                isDir = this.maprfs().getMapRFileStatus(path).isDir();
            }
            catch (FileNotFoundException e) {
                path = null;
            }
            if (!isDir) {
                if (lio_slash != -1) {
                    lookupPath = lookupPath.substring(0, lio_slash + 1);
                    checkPattern = origLookup.substring(lio_slash + 1);
                }
                path = this.getTablePath(lookupPath);
            }
        }
        if (this.maprfs().isTable(path)) {
            return new FileStatus[]{this.maprfs().getFileStatus(path)};
        }
        String string = name = checkPattern != null ? checkPattern : ".*";
        if (!this.maprfs().exists(path)) {
            Path parent = path.getParent();
            if (!this.maprfs().exists(parent)) {
                throw new IOException("Path '" + path.toString() + "' or its parent " + "does not exist.");
            }
            name = path.getName();
            path = parent;
        }
        final Pattern filter = Pattern.compile(name);
        return this.maprfs().listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                try {
                    return filter.matcher(path.getName()).matches() && HBaseAdminImpl.this.maprfs().isTable(path);
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public HTableDescriptor getTableDescriptor(String tableName) throws TableNotFoundException, IOException {
        if (tableName == null || tableName.length() == 0) {
            return null;
        }
        return this.getTableDescriptor(this.getTablePath(tableName));
    }

    protected HTableDescriptor getTableDescriptor(Path tablePath) throws TableNotFoundException, IOException {
        this.checkTable(tablePath);
        return SchemaHelper.toHTableDescriptor(this.maprfs(), tablePath);
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        if (!maprDaemonEnvVariableChecked) {
            String maprDaemonProcessStr = System.getenv().get("MAPR_DAEMON");
            maprDaemonProcess = maprDaemonProcessStr != null && maprDaemonProcessStr.equalsIgnoreCase("spyglass");
            maprDaemonEnvVariableChecked = true;
        }
        if (maprDaemonProcess) {
            this.maprfs().enablePrivilegedProcessAccess(true);
        }
        if (desc == null || desc.getName() == null) {
            throw new IllegalArgumentException("Table descriptor or name can not be null: " + desc);
        }
        this.checkTableDesc(desc);
        try {
            Path path = this.getTablePath(desc.getName());
            if (this.maprfs().exists(path)) {
                throw new TableExistsException(path.toString());
            }
            Dbserver.TableAttr.Builder attrBuilder = Dbserver.TableAttr.newBuilder();
            this.toTableAttr(desc, attrBuilder);
            this.maprfs().createTable(path, null, attrBuilder.build(), Dbserver.TableAces.getDefaultInstance(), splitKeys, false, -1);
            boolean found_def = false;
            String ttStr = desc.getValue("TABLETYPE");
            boolean isJson = false;
            if (ttStr != null && ttStr.toLowerCase().equals("json")) {
                isJson = true;
            }
            if (isJson) {
                HColumnDescriptor dcf = null;
                String name = null;
                for (HColumnDescriptor cf : desc.getFamilies()) {
                    name = cf.getNameAsString();
                    if (!name.equals(FIRST_JSON_COL_FAMILY)) continue;
                    found_def = true;
                    dcf = cf;
                    break;
                }
                if (!found_def) {
                    LOG.error((Object)("Create JSON table " + path + " need to parse default CF " + "first"));
                } else {
                    this.maprfs().createColumnFamily(path, name, SchemaHelper.toColumnFamilyAttr(dcf, false));
                }
            }
            for (HColumnDescriptor cf : desc.getFamilies()) {
                String name = cf.getNameAsString();
                if (found_def && name.equals(FIRST_JSON_COL_FAMILY)) continue;
                Dbserver.ColumnFamilyAttr cfAttr = SchemaHelper.toColumnFamilyAttr(cf, false);
                if (isJson) {
                    cfAttr = Dbserver.ColumnFamilyAttr.newBuilder((Dbserver.ColumnFamilyAttr)cfAttr).setJsonFamilyPath(name).build();
                }
                this.maprfs().createColumnFamily(path, name, cfAttr);
            }
            HTableProperties.setTableProperties(path, desc.getValues());
            LOG.debug((Object)("Created table " + path));
        }
        catch (IOException e) {
            LOG.debug((Object)("Error creating table '" + desc.getNameAsString() + "': " + e.getMessage()));
            throw e;
        }
        if (maprDaemonProcess) {
            this.maprfs().enablePrivilegedProcessAccess(false);
        }
    }

    public void deleteTable(String tablePath) throws IOException {
        this.deleteTable(this.getTablePath(tablePath));
    }

    public void deleteTable(Path tablePath) throws IOException {
        this.checkTable(tablePath);
        MapRFileStatus status = this.maprfs().getMapRFileStatus(tablePath);
        if (!status.isTable()) {
            throw new IOException("Path '" + tablePath.toString() + "' is not a table");
        }
        this.maprfs().delete(tablePath, false);
        HTableProperties.removeProperties(tablePath);
        LOG.debug((Object)("Deleted table " + tablePath));
    }

    public HTableDescriptor[] deleteTables(String lookupPath) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        FileStatus[] tables = this.doListTables(lookupPath);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                Path path = table.getPath();
                try {
                    this.deleteTable(path);
                }
                catch (IOException ex) {
                    LOG.info((Object)("Failed to delete table " + path.getName()), (Throwable)ex);
                    failed.add(SchemaHelper.toHTableDescriptor(this.maprfs(), path));
                }
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void addColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.addColumn(this.getTablePath(tableName), cf);
    }

    public void addColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkTable(tablePath);
        this.checkColumnDesc(cf);
        String name = cf.getNameAsString();
        try {
            this.maprfs().createColumnFamily(this.maprfs().resolveTablePath(tablePath), name, SchemaHelper.toColumnFamilyAttr(cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while adding column familiy '" + name + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void modifyColumn(String tableName, HColumnDescriptor cf) throws IOException {
        this.modifyColumn(this.getTablePath(tableName), cf);
    }

    public void modifyColumn(Path tablePath, HColumnDescriptor cf) throws IOException {
        this.checkColumnDesc(cf);
        HTableDescriptor desc = this.getTableDescriptor(tablePath);
        if (!desc.hasFamily(cf.getName())) {
            throw new InvalidFamilyOperationException("Column family '" + cf.getNameAsString() + "' does not exist");
        }
        HColumnDescriptor oldcf = desc.getFamily(cf.getName());
        try {
            this.maprfs().modifyColumnFamily(this.maprfs().resolveTablePath(tablePath), cf.getNameAsString(), SchemaHelper.toColumnFamilyAttr(oldcf, cf, false));
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while modifying column familiy '" + cf.getNameAsString() + "' for table '" + tablePath + "'"));
            throw e;
        }
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        try {
            this.maprfs().deleteColumnFamily(this.maprfs().resolveTablePath(path), columnName);
        }
        catch (IOException e) {
            LOG.error((Object)("Exception while deleting column familiy '" + columnName + "' for table '" + tableName + "'"));
            throw e;
        }
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        this.checkTableDesc(htd);
        String blStr = htd.getValue("BULKLOAD");
        if (blStr != null && blStr.equals("true")) {
            throw new IOException("Cannot alter bulkload attribute to true.");
        }
        String jsonStr = htd.getValue("TABLETYPE");
        if (jsonStr != null) {
            throw new IOException("Cannot alter tabletype attribute.");
        }
        TableProperties tableProp = this.maprfs().getTableProperties(path);
        Dbserver.TableAttr.Builder attrBuilder = Dbserver.TableAttr.newBuilder();
        this.toTableAttr(htd, attrBuilder);
        this.maprfs().modifyTableAttr(path, attrBuilder.build(), tableProp.getAces());
        HTableProperties.setTableProperties(path, htd.getValues());
    }

    public void enableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        HTableProperties.setTableProperty(path, "DISABLED", HTableProperties.FALSE);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, false);
    }

    public void disableTable(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        HTableProperties.setTableProperty(path, "DISABLED", HTableProperties.TRUE);
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.setTableDisabledStatus(regex, true);
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        Path path = this.getTablePath(tableName);
        this.checkTable(path);
        return Boolean.parseBoolean(HTableProperties.getTableProperty(path, "DISABLED"));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.tableExists(tableName);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("isTableAvailable with splitkeys is currently not supported for MapR tables.");
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        List nextSet;
        ArrayList<HRegionInfo> tableRegions = new ArrayList<HRegionInfo>();
        String tablePath = Bytes.toString((byte[])tableName);
        MapRTabletScanner scanner = this.maprfs().getTabletScanner(new Path(tablePath));
        while ((nextSet = scanner.nextSet()) != null) {
            for (Dbserver.TabletDesc tablet : nextSet) {
                tableRegions.add(HRegionConverter.toHRegionInfo(tablet, tableName));
            }
        }
        return tableRegions;
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        String fidString;
        if (splitPoint != null) {
            throw new UnsupportedOperationException("Region split with 'splitPoint' is currently not supported for MapR tables.");
        }
        String fid = null;
        String tableNameOrRegionStr = Bytes.toString((byte[])tableNameOrRegionName);
        Path tablePath = this.getTablePath(tableNameOrRegionStr);
        int fidOffset = tableNameOrRegionStr.lastIndexOf(",");
        if (fidOffset != -1 && MapRFileSystem.isFidString((String)(fidString = tableNameOrRegionStr.substring(fidOffset + 1)))) {
            fid = fidString;
            tablePath = this.getTablePath(tableNameOrRegionStr.substring(0, fidOffset));
        }
        this.admin().split(tablePath, fid);
    }

    public void setTablePermissions(String tablePath, Map<String, String> permissions) throws IOException {
        this.admin().setTablePermissions(this.getTablePath(tablePath), permissions);
    }

    public Map<String, String> getTablePermissions(String tablePath) throws IOException {
        return this.admin().getTablePermissions(this.getTablePath(tablePath));
    }

    public void deleteTablePermission(String tablePath, String permission) throws IOException {
        this.admin().deleteTablePermission(this.getTablePath(tablePath), permission);
    }

    public void setFamilyPermissions(String tablePath, String family, CFPermissions cfPermissions) throws IOException {
        this.admin().setFamilyPermissions(this.getTablePath(tablePath), family, cfPermissions);
    }

    public List<CFPermissions> getFamilyPermissions(String tablePath) throws IOException {
        return this.admin().getFamilyPermissions(this.getTablePath(tablePath));
    }

    public void deleteColumnPermission(String tablePath, String column, String permission) throws IOException {
        this.admin().deleteColumnPermission(this.getTablePath(tablePath), column, permission);
    }

    protected synchronized MapRFileSystem maprfs() throws IOException {
        if (this.maprfilesystem_ == null) {
            try {
                this.maprfilesystem_ = this.user_ != null ? (MapRFileSystem)this.user_.getUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MapRFileSystem>(){

                    @Override
                    public MapRFileSystem run() throws Exception {
                        return HBaseAdminImpl.this.createMaprFS();
                    }
                }) : this.createMaprFS();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
        return this.maprfilesystem_;
    }

    protected synchronized MapRAdmin admin() throws IOException {
        if (this.maprAdmin_ == null) {
            this.maprAdmin_ = new MapRAdmin(this.maprfs());
        }
        return this.maprAdmin_;
    }

    private synchronized MapRFileSystem createMaprFS() throws IOException, URISyntaxException {
        MapRFileSystem maprfs = new MapRFileSystem();
        maprfs.initialize(new URI("maprfs:///"), this.configuration_);
        return maprfs;
    }

    protected HTableDescriptor[] setTableDisabledStatus(String regex, Boolean disabled) throws IOException {
        if (regex == null) {
            return null;
        }
        FileStatus[] tables = this.doListTables(regex);
        if (tables != null && tables.length > 0) {
            for (FileStatus table : tables) {
                HTableProperties.setTableProperty(table.getPath(), "DISABLED", disabled.toString());
            }
        }
        return new HTableDescriptor[0];
    }

    protected Path getTablePath(String tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected Path getTablePath(byte[] tableName) throws IOException {
        return this.tableMappingRule_.getMaprTablePath(tableName);
    }

    protected void unSupportedOperation(String operation) {
        throw new UnsupportedOperationException(operation + " called on MapR HBaseAdminImpl");
    }

    protected void checkTable(Path path) throws IOException, TableNotFoundException {
        if (!this.maprfs().exists(path)) {
            throw new TableNotFoundException("Table '" + path + "' does not exist.");
        }
        if (!this.maprfs().isTable(path)) {
            throw new TableNotFoundException("Path '" + path + "' is a not a table.");
        }
    }

    private void toTableAttr(HTableDescriptor desc, Dbserver.TableAttr.Builder attrBuilder) {
        Map htdMap = desc.getValues();
        Iterator it = htdMap.entrySet().iterator();
        boolean hasMarlinAttrs = false;
        Marlincommon.MarlinTableAttr.Builder marlinAttrBuilder = Marlincommon.MarlinTableAttr.newBuilder();
        Marlinserver.MarlinInternalDefaults mdef = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        while (it.hasNext()) {
            Map.Entry pairs = it.next();
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getKey()).get());
            String value = Bytes.toString((byte[])((ImmutableBytesWritable)pairs.getValue()).get());
            if (key.equals("BULKLOAD")) {
                attrBuilder.setBulkLoad(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("MAX_FILESIZE")) {
                long regionSize = Long.parseLong(value, 10);
                attrBuilder.setRegionSizeMB(regionSize / 0x100000L);
                continue;
            }
            if (key.equals("AUTOSPLIT")) {
                attrBuilder.setAutoSplit(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("MAX_VALUE_SIZE_IN_MEM")) {
                attrBuilder.setMaxValueSzInMemIndex(Integer.parseInt(value));
                continue;
            }
            if (key.equals("RECLAIM_THRESH_PCNT_FOR_PACK")) {
                attrBuilder.setReclaimThreshPcntForPack(Integer.parseInt(value));
                continue;
            }
            if (key.equals("MAXSPILLS")) {
                attrBuilder.setMaxSpills(Integer.parseInt(value));
                continue;
            }
            if (key.equals("MINIPACK")) {
                attrBuilder.setMiniPack(Boolean.parseBoolean(value));
                continue;
            }
            if (key.equals("SIZE_THRESH_PCNT_FOR_PACK")) {
                attrBuilder.setSizeThreshPcntForPack(Integer.parseInt(value));
                continue;
            }
            if (key.equals("DELETE_TTL")) {
                attrBuilder.setDeleteTTL(Long.parseLong(value));
                continue;
            }
            if (key.equals(mdef.getHattrIsMarlinTable())) {
                attrBuilder.setIsMarlinTable(Boolean.parseBoolean(value));
                hasMarlinAttrs = true;
                continue;
            }
            if (key.equals(mdef.getHattrAutoCreateTopics())) {
                marlinAttrBuilder.setAutoCreateTopics(Boolean.parseBoolean(value));
                hasMarlinAttrs = true;
                continue;
            }
            if (key.equals(mdef.getHattrDefaultPartitions())) {
                marlinAttrBuilder.setDefaultNumFeedsPerTopic(Integer.parseInt(value));
                hasMarlinAttrs = true;
                continue;
            }
            if (key.equals("TABLETYPE")) {
                if (value != null && !value.toLowerCase().equals("json") && !value.toLowerCase().equals("binary")) {
                    throw new IllegalArgumentException("Table type can only be one of 'json' or 'binary' : " + desc);
                }
                boolean isJson = false;
                if (value != null && value.toLowerCase().equals("json")) {
                    isJson = true;
                }
                attrBuilder.setJson(isJson);
                continue;
            }
            if (!key.equals("JSON_INSERT_ORDER")) continue;
            attrBuilder.setInsertionOrder(Boolean.parseBoolean(value));
        }
        if (hasMarlinAttrs) {
            attrBuilder.setMarlinAttr(marlinAttrBuilder.build());
        }
    }

    public long getNumRows(String path) throws IOException {
        Path tablePath = new Path(path);
        this.checkTable(tablePath);
        return this.admin().getNumRows(tablePath);
    }

    private void checkTableDesc(HTableDescriptor htd) {
        for (HColumnDescriptor family : htd.getColumnFamilies()) {
            this.checkColumnDesc(family);
        }
    }

    private void checkColumnDesc(HColumnDescriptor hcd) {
        String value = hcd.getValue("KEEP_DELETED_CELLS");
        if (value != null && !"false".equalsIgnoreCase(value)) {
            throw new UnsupportedOperationException("'KEEP_DELETED_CELLS' flag on the column family is not supported with MapR-DB tables.");
        }
        if (hcd.getValue("ENCRYPTION") != null) {
            throw new UnsupportedOperationException("Encryption of MapR-DB tables is currently not supported.");
        }
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = null;
        if (preserveSplits) {
            List<HRegionInfo> regions = this.getTableRegions(tableName.getQualifier());
            Collections.sort(regions);
            ArrayList<byte[]> splitKeyList = new ArrayList<byte[]>(regions.size());
            for (HRegionInfo region : regions) {
                if (region.getEndKey() == null || region.getEndKey().length == 0) continue;
                splitKeyList.add(region.getEndKey());
            }
            splitKeys = (byte[][])splitKeyList.toArray((T[])new byte[splitKeyList.size()][]);
        }
        String tablePath = tableName.getAliasAsString();
        HTableDescriptor htd = this.getTableDescriptor(tablePath);
        Map<String, String> tablePerms = this.getTablePermissions(tablePath);
        List<CFPermissions> cfPerms = this.getFamilyPermissions(tablePath);
        this.deleteTable(tablePath);
        htd.remove(HTableDescriptor.MAPR_UUID_KEY);
        htd.remove("DISABLED");
        int retrycount = 0;
        boolean tableCreated = false;
        while (!tableCreated) {
            try {
                this.createTable(htd, splitKeys);
                tableCreated = true;
            }
            catch (IOExceptionWithErrorCode e) {
                if (e.getErrorCode() != 28 && e.getErrorCode() != 122) {
                    String tableInfo = this.toStringTableInfo(tableName, splitKeys, htd, tablePerms, cfPerms);
                    LOG.info((Object)tableInfo);
                    throw new IOExceptionWithErrorCode(e.getMessage() + tableInfo, e.getErrorCode());
                }
                if (++retrycount >= MaxTableCreateRetryCount) {
                    String tableInfo = this.toStringTableInfo(tableName, splitKeys, htd, tablePerms, cfPerms);
                    LOG.info((Object)tableInfo);
                    throw new IOExceptionWithErrorCode(e.getMessage() + tableInfo, e.getErrorCode());
                }
                try {
                    LOG.info((Object)"Will retry table create in 30 seconds.");
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)"Retry of table create get interrupted");
                    String tableInfo = this.toStringTableInfo(tableName, splitKeys, htd, tablePerms, cfPerms);
                    LOG.info((Object)tableInfo);
                    throw new IOExceptionWithErrorCode(e.getMessage() + tableInfo, e.getErrorCode());
                }
            }
        }
        this.setTablePermissions(tablePath, tablePerms);
        for (CFPermissions cfp : cfPerms) {
            this.setFamilyPermissions(tablePath, cfp.getFamily(), cfp);
        }
    }

    private String toStringTableInfo(TableName tableName, byte[][] splitKeys, HTableDescriptor htd, Map<String, String> tablePerms, List<CFPermissions> cfPerms) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nRecreate table failed, please use the following table information to recreate it manually");
        sb.append("\nTable:");
        sb.append("\n" + tableName.toString());
        if (splitKeys != null) {
            sb.append("\nSplit Keys:");
            for (byte[] key : splitKeys) {
                sb.append("\n\t" + Bytes.toStringBinary((byte[])key));
            }
        }
        sb.append("\nHTableDescriptor:");
        sb.append("\n" + htd.toString());
        sb.append("\nTable Permissions:");
        for (Map.Entry<String, String> entry : tablePerms.entrySet()) {
            sb.append("\n\t" + entry.getKey() + " " + entry.getValue());
        }
        sb.append("\nPermissions:");
        for (CFPermissions cfp : cfPerms) {
            Map cfperms = cfp.getCfPermissions();
            sb.append("\nColumnFamily Permissions:");
            for (Map.Entry entry : cfperms.entrySet()) {
                sb.append("\n\t" + (String)entry.getKey() + " " + (String)entry.getValue());
            }
            sb.append("\nColumn Permissions:");
            Set set = cfp.getColumnNames();
            for (String colname : set) {
                sb.append("\n\t" + colname);
                Map colperms = cfp.getColPermission(colname);
                for (Map.Entry entry : colperms.entrySet()) {
                    sb.append("\n\t\t" + (String)entry.getKey() + " " + (String)entry.getValue());
                }
            }
        }
        return sb.toString();
    }

    static {
        ShimLoader.load();
        MaxTableCreateRetryCount = 5;
        LOG = LogFactory.getLog(HBaseAdminImpl.class);
        FIRST_JSON_COL_FAMILY = "default";
        maprDaemonEnvVariableChecked = false;
        maprDaemonProcess = false;
    }
}

