/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import com.mapr.fs.hbase.HFileScannerProxy;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class HFileInputFormat
extends FileInputFormat<ImmutableBytesWritable, KeyValue> {
    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }

    public RecordReader<ImmutableBytesWritable, KeyValue> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new RecordReader<ImmutableBytesWritable, KeyValue>(){
            HFile.Reader reader;
            HFileScanner scanner;
            Integer entryNumber = 0;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                Configuration conf = context.getConfiguration();
                Path path = ((FileSplit)split).getPath();
                FileSystem fs = path.getFileSystem(conf);
                this.reader = HFile.createReader((FileSystem)fs, (Path)path, (CacheConfig)new CacheConfig(conf), (Configuration)conf);
                this.reader.loadFileInfo();
                this.scanner = this.reader.getScanner(false, false);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                1 var1_1 = this;
                var1_1.entryNumber = var1_1.entryNumber + 1;
                if (!this.scanner.isSeeked()) {
                    return this.scanner.seekTo();
                }
                return this.scanner.next();
            }

            public ImmutableBytesWritable getCurrentKey() throws IOException, InterruptedException {
                return new ImmutableBytesWritable(HFileScannerProxy.getKeyValue(this.scanner).getRow());
            }

            public KeyValue getCurrentValue() throws IOException, InterruptedException {
                return (KeyValue)HFileScannerProxy.getKeyValue(this.scanner);
            }

            public float getProgress() throws IOException, InterruptedException {
                return (float)this.entryNumber.intValue() / (float)this.reader.getEntries();
            }

            public void close() throws IOException {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
        };
    }
}

