/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.tools.mapreduce;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterTablePath {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterTablePath.class);
    public static final String CLUSTERPREFIX = "maprfs:///mapr/";
    public static final String CLUSTERPREFIX2 = "/mapr/";
    public static final String CLUSTERPREFIX3 = "maprfs://";
    public static final String WRONGCLUSTERPREFIX = "maprfs:";
    public final String clusterName;
    public final String tablePathName;

    public ClusterTablePath(String cName, String tPath) {
        if (cName == null && tPath == null) {
            throw new NullPointerException("cluster name and table path name cannot both be null.");
        }
        this.tablePathName = tPath;
        this.clusterName = cName == null || cName.equals("") ? null : cName;
    }

    public String toString() {
        return this.getFullPathName();
    }

    public URI getClusterUri() {
        URI uri = null;
        try {
            uri = this.clusterName == null ? new URI("maprfs:///") : new URI(CLUSTERPREFIX3 + this.clusterName + "/");
        }
        catch (URISyntaxException e) {
            LOG.error("Fail to generate cluster uri. Reason:");
            e.printStackTrace();
        }
        return uri;
    }

    public String getFullPathName() {
        if (this.clusterName == null) {
            return this.tablePathName;
        }
        return CLUSTERPREFIX3 + this.clusterName + this.tablePathName;
    }

    public Path getFullPath() {
        return new Path(this.getFullPathName());
    }

    public static boolean equal(ClusterTablePath ctp1, ClusterTablePath ctp2) {
        boolean clusterIsSame = false;
        clusterIsSame = ctp1.clusterName == null && ctp2.clusterName == null ? true : (ctp1.clusterName == null && ctp2.clusterName != null ? false : (ctp1.clusterName != null && ctp2.clusterName == null ? false : ctp1.clusterName.equals(ctp2.clusterName)));
        if (!clusterIsSame) {
            LOG.debug(ctp1 + "'s cluster is different from " + ctp2 + "'s cluster");
            return false;
        }
        boolean tablePathIsSame = false;
        tablePathIsSame = ctp1.tablePathName == null && ctp2.tablePathName == null ? true : (ctp1.tablePathName == null && ctp2.tablePathName != null ? false : (ctp1.tablePathName != null && ctp2.tablePathName == null ? false : ctp1.tablePathName.equals(ctp2.tablePathName)));
        if (!tablePathIsSame) {
            LOG.debug(ctp1 + "'s tablePath is different from " + ctp2 + "'s tablePath");
            return false;
        }
        LOG.debug(ctp1 + " is same as " + ctp2);
        return true;
    }

    public boolean equal(ClusterTablePath ctp) {
        return ClusterTablePath.equal(this, ctp);
    }

    public static ClusterTablePath parse(String tablePathName) {
        Object cName = null;
        Object tPath = null;
        String sub = null;
        if (tablePathName.startsWith(CLUSTERPREFIX)) {
            sub = tablePathName.substring(CLUSTERPREFIX.length());
        } else if (tablePathName.startsWith(CLUSTERPREFIX2)) {
            sub = tablePathName.substring(CLUSTERPREFIX2.length());
        } else if (tablePathName.startsWith(CLUSTERPREFIX3)) {
            sub = tablePathName.substring(CLUSTERPREFIX3.length());
        } else {
            if (tablePathName.startsWith(WRONGCLUSTERPREFIX)) {
                sub = tablePathName.substring(WRONGCLUSTERPREFIX.length());
                LOG.error("'/' is missing from input path(" + tablePathName + "), it should start with " + CLUSTERPREFIX2 + ", or " + CLUSTERPREFIX3);
                return null;
            }
            return new ClusterTablePath(null, tablePathName);
        }
        if (sub.equals("")) {
            return new ClusterTablePath(null, "/");
        }
        String[] splits = sub.split("/", 2);
        if (splits.length <= 0) {
            LOG.error("cluster name is missing from input path(" + tablePathName + "), it should start with " + CLUSTERPREFIX2 + "clustername/tablepathname");
            return null;
        }
        if (splits.length <= 1) {
            LOG.error("tablepathname is missing from input path(" + tablePathName + "), to get the root directory of cluster " + splits[0] + ", use " + CLUSTERPREFIX3 + splits[0] + "/");
            return null;
        }
        LOG.debug("cluster(" + splits[0] + "), table path(/" + splits[1] + ")");
        return new ClusterTablePath(splits[0], "/" + splits[1]);
    }
}

